<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HelpDesk.CustomerManagementServiceRequest StructType
 * @subpackage Structs
 */
class HelpDesk_CustomerManagementServiceRequest extends HelpDesk_ServiceRequest
{
    /**
     * The ActionDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ActionDetails;
    /**
     * The QueryName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $QueryName;
    /**
     * The RequiredAction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RequiredAction;
    /**
     * Constructor method for HelpDesk.CustomerManagementServiceRequest
     * @uses HelpDesk_CustomerManagementServiceRequest::setActionDetails()
     * @uses HelpDesk_CustomerManagementServiceRequest::setQueryName()
     * @uses HelpDesk_CustomerManagementServiceRequest::setRequiredAction()
     * @param string $actionDetails
     * @param string $queryName
     * @param string $requiredAction
     */
    public function __construct($actionDetails = null, $queryName = null, $requiredAction = null)
    {
        $this
            ->setActionDetails($actionDetails)
            ->setQueryName($queryName)
            ->setRequiredAction($requiredAction);
    }
    /**
     * Get ActionDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActionDetails()
    {
        return isset($this->ActionDetails) ? $this->ActionDetails : null;
    }
    /**
     * Set ActionDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $actionDetails
     * @return \patest\StructType\HelpDesk_CustomerManagementServiceRequest
     */
    public function setActionDetails($actionDetails = null)
    {
        // validation for constraint: string
        if (!is_null($actionDetails) && !is_string($actionDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actionDetails, true), gettype($actionDetails)), __LINE__);
        }
        if (is_null($actionDetails) || (is_array($actionDetails) && empty($actionDetails))) {
            unset($this->ActionDetails);
        } else {
            $this->ActionDetails = $actionDetails;
        }
        return $this;
    }
    /**
     * Get QueryName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getQueryName()
    {
        return isset($this->QueryName) ? $this->QueryName : null;
    }
    /**
     * Set QueryName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $queryName
     * @return \patest\StructType\HelpDesk_CustomerManagementServiceRequest
     */
    public function setQueryName($queryName = null)
    {
        // validation for constraint: string
        if (!is_null($queryName) && !is_string($queryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($queryName, true), gettype($queryName)), __LINE__);
        }
        if (is_null($queryName) || (is_array($queryName) && empty($queryName))) {
            unset($this->QueryName);
        } else {
            $this->QueryName = $queryName;
        }
        return $this;
    }
    /**
     * Get RequiredAction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequiredAction()
    {
        return isset($this->RequiredAction) ? $this->RequiredAction : null;
    }
    /**
     * Set RequiredAction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requiredAction
     * @return \patest\StructType\HelpDesk_CustomerManagementServiceRequest
     */
    public function setRequiredAction($requiredAction = null)
    {
        // validation for constraint: string
        if (!is_null($requiredAction) && !is_string($requiredAction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requiredAction, true), gettype($requiredAction)), __LINE__);
        }
        if (is_null($requiredAction) || (is_array($requiredAction) && empty($requiredAction))) {
            unset($this->RequiredAction);
        } else {
            $this->RequiredAction = $requiredAction;
        }
        return $this;
    }
}
