<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HelpDesk.CommonFindRequest StructType
 * @subpackage Structs
 */
class HelpDesk_CommonFindRequest extends AnyEntity
{
    /**
     * The ActionDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ActionDetails;
    /**
     * The AssignedTo
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AssignedTo;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The CreatedBy
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CreatedBy;
    /**
     * The CreatedFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedFrom;
    /**
     * The CreatedUntil
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedUntil;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The ExpiryFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExpiryFrom;
    /**
     * The ExpiryUntil
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExpiryUntil;
    /**
     * The ExplanationId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ExplanationId;
    /**
     * The GiftVoucherDefinitionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GiftVoucherDefinitionId;
    /**
     * The HandledOnDateFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HandledOnDateFrom;
    /**
     * The HandledOnDateUntil
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HandledOnDateUntil;
    /**
     * The HandleRequestNotLaterThanFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HandleRequestNotLaterThanFrom;
    /**
     * The HandleRequestNotLaterThanUntil
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HandleRequestNotLaterThanUntil;
    /**
     * The HardwareType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HardwareType;
    /**
     * The ItemType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ItemType;
    /**
     * The MembershipDefinitionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MembershipDefinitionId;
    /**
     * The MerchandiseId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MerchandiseId;
    /**
     * The PriceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceTypeId;
    /**
     * The PrinterId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PrinterId;
    /**
     * The Priority
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Priority;
    /**
     * The QuantityFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $QuantityFrom;
    /**
     * The QuantityTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $QuantityTo;
    /**
     * The QueryName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $QueryName;
    /**
     * The RelatedDepartment
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RelatedDepartment;
    /**
     * The RelatedUser
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RelatedUser;
    /**
     * The RequestCategory
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RequestCategory;
    /**
     * The RequestType
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RequestType;
    /**
     * The RequiredAction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RequiredAction;
    /**
     * The SalePointId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SalePointId;
    /**
     * The ScannerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ScannerId;
    /**
     * The SeasonId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeasonId;
    /**
     * The SeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeriesId;
    /**
     * The ShowId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ShowId;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Status;
    /**
     * The SubsidizingOrg
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SubsidizingOrg;
    /**
     * The Topic
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Topic;
    /**
     * Constructor method for HelpDesk.CommonFindRequest
     * @uses HelpDesk_CommonFindRequest::setActionDetails()
     * @uses HelpDesk_CommonFindRequest::setAssignedTo()
     * @uses HelpDesk_CommonFindRequest::setClientId()
     * @uses HelpDesk_CommonFindRequest::setCreatedBy()
     * @uses HelpDesk_CommonFindRequest::setCreatedFrom()
     * @uses HelpDesk_CommonFindRequest::setCreatedUntil()
     * @uses HelpDesk_CommonFindRequest::setEventId()
     * @uses HelpDesk_CommonFindRequest::setExpiryFrom()
     * @uses HelpDesk_CommonFindRequest::setExpiryUntil()
     * @uses HelpDesk_CommonFindRequest::setExplanationId()
     * @uses HelpDesk_CommonFindRequest::setGiftVoucherDefinitionId()
     * @uses HelpDesk_CommonFindRequest::setHandledOnDateFrom()
     * @uses HelpDesk_CommonFindRequest::setHandledOnDateUntil()
     * @uses HelpDesk_CommonFindRequest::setHandleRequestNotLaterThanFrom()
     * @uses HelpDesk_CommonFindRequest::setHandleRequestNotLaterThanUntil()
     * @uses HelpDesk_CommonFindRequest::setHardwareType()
     * @uses HelpDesk_CommonFindRequest::setItemType()
     * @uses HelpDesk_CommonFindRequest::setMembershipDefinitionId()
     * @uses HelpDesk_CommonFindRequest::setMerchandiseId()
     * @uses HelpDesk_CommonFindRequest::setPriceTypeId()
     * @uses HelpDesk_CommonFindRequest::setPrinterId()
     * @uses HelpDesk_CommonFindRequest::setPriority()
     * @uses HelpDesk_CommonFindRequest::setQuantityFrom()
     * @uses HelpDesk_CommonFindRequest::setQuantityTo()
     * @uses HelpDesk_CommonFindRequest::setQueryName()
     * @uses HelpDesk_CommonFindRequest::setRelatedDepartment()
     * @uses HelpDesk_CommonFindRequest::setRelatedUser()
     * @uses HelpDesk_CommonFindRequest::setRequestCategory()
     * @uses HelpDesk_CommonFindRequest::setRequestType()
     * @uses HelpDesk_CommonFindRequest::setRequiredAction()
     * @uses HelpDesk_CommonFindRequest::setSalePointId()
     * @uses HelpDesk_CommonFindRequest::setScannerId()
     * @uses HelpDesk_CommonFindRequest::setSeasonId()
     * @uses HelpDesk_CommonFindRequest::setSeriesId()
     * @uses HelpDesk_CommonFindRequest::setShowId()
     * @uses HelpDesk_CommonFindRequest::setStatus()
     * @uses HelpDesk_CommonFindRequest::setSubsidizingOrg()
     * @uses HelpDesk_CommonFindRequest::setTopic()
     * @param string $actionDetails
     * @param string $assignedTo
     * @param string $clientId
     * @param string $createdBy
     * @param string $createdFrom
     * @param string $createdUntil
     * @param string $eventId
     * @param string $expiryFrom
     * @param string $expiryUntil
     * @param string $explanationId
     * @param string $giftVoucherDefinitionId
     * @param string $handledOnDateFrom
     * @param string $handledOnDateUntil
     * @param string $handleRequestNotLaterThanFrom
     * @param string $handleRequestNotLaterThanUntil
     * @param string $hardwareType
     * @param string $itemType
     * @param string $membershipDefinitionId
     * @param string $merchandiseId
     * @param string $priceTypeId
     * @param string $printerId
     * @param string $priority
     * @param int $quantityFrom
     * @param int $quantityTo
     * @param string $queryName
     * @param string $relatedDepartment
     * @param string $relatedUser
     * @param string $requestCategory
     * @param string $requestType
     * @param string $requiredAction
     * @param string $salePointId
     * @param string $scannerId
     * @param string $seasonId
     * @param string $seriesId
     * @param string $showId
     * @param string $status
     * @param string $subsidizingOrg
     * @param string $topic
     */
    public function __construct($actionDetails = null, $assignedTo = null, $clientId = null, $createdBy = null, $createdFrom = null, $createdUntil = null, $eventId = null, $expiryFrom = null, $expiryUntil = null, $explanationId = null, $giftVoucherDefinitionId = null, $handledOnDateFrom = null, $handledOnDateUntil = null, $handleRequestNotLaterThanFrom = null, $handleRequestNotLaterThanUntil = null, $hardwareType = null, $itemType = null, $membershipDefinitionId = null, $merchandiseId = null, $priceTypeId = null, $printerId = null, $priority = null, $quantityFrom = null, $quantityTo = null, $queryName = null, $relatedDepartment = null, $relatedUser = null, $requestCategory = null, $requestType = null, $requiredAction = null, $salePointId = null, $scannerId = null, $seasonId = null, $seriesId = null, $showId = null, $status = null, $subsidizingOrg = null, $topic = null)
    {
        $this
            ->setActionDetails($actionDetails)
            ->setAssignedTo($assignedTo)
            ->setClientId($clientId)
            ->setCreatedBy($createdBy)
            ->setCreatedFrom($createdFrom)
            ->setCreatedUntil($createdUntil)
            ->setEventId($eventId)
            ->setExpiryFrom($expiryFrom)
            ->setExpiryUntil($expiryUntil)
            ->setExplanationId($explanationId)
            ->setGiftVoucherDefinitionId($giftVoucherDefinitionId)
            ->setHandledOnDateFrom($handledOnDateFrom)
            ->setHandledOnDateUntil($handledOnDateUntil)
            ->setHandleRequestNotLaterThanFrom($handleRequestNotLaterThanFrom)
            ->setHandleRequestNotLaterThanUntil($handleRequestNotLaterThanUntil)
            ->setHardwareType($hardwareType)
            ->setItemType($itemType)
            ->setMembershipDefinitionId($membershipDefinitionId)
            ->setMerchandiseId($merchandiseId)
            ->setPriceTypeId($priceTypeId)
            ->setPrinterId($printerId)
            ->setPriority($priority)
            ->setQuantityFrom($quantityFrom)
            ->setQuantityTo($quantityTo)
            ->setQueryName($queryName)
            ->setRelatedDepartment($relatedDepartment)
            ->setRelatedUser($relatedUser)
            ->setRequestCategory($requestCategory)
            ->setRequestType($requestType)
            ->setRequiredAction($requiredAction)
            ->setSalePointId($salePointId)
            ->setScannerId($scannerId)
            ->setSeasonId($seasonId)
            ->setSeriesId($seriesId)
            ->setShowId($showId)
            ->setStatus($status)
            ->setSubsidizingOrg($subsidizingOrg)
            ->setTopic($topic);
    }
    /**
     * Get ActionDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActionDetails()
    {
        return isset($this->ActionDetails) ? $this->ActionDetails : null;
    }
    /**
     * Set ActionDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $actionDetails
     * @return \patest\StructType\HelpDesk_CommonFindRequest
     */
    public function setActionDetails($actionDetails = null)
    {
        // validation for constraint: string
        if (!is_null($actionDetails) && !is_string($actionDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actionDetails, true), gettype($actionDetails)), __LINE__);
        }
        if (is_null($actionDetails) || (is_array($actionDetails) && empty($actionDetails))) {
            unset($this->ActionDetails);
        } else {
            $this->ActionDetails = $actionDetails;
        }
        return $this;
    }
    /**
     * Get AssignedTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAssignedTo()
    {
        return isset($this->AssignedTo) ? $this->AssignedTo : null;
    }
    /**
     * Set AssignedTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $assignedTo
     * @return \patest\StructType\HelpDesk_CommonFindRequest
     */
    public function setAssignedTo($assignedTo = null)
    {
        // validation for constraint: string
        if (!is_null($assignedTo) && !is_string($assignedTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($assignedTo, true), gettype($assignedTo)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($assignedTo) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $assignedTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($assignedTo, true)), __LINE__);
        }
        if (is_null($assignedTo) || (is_array($assignedTo) && empty($assignedTo))) {
            unset($this->AssignedTo);
        } else {
            $this->AssignedTo = $assignedTo;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\HelpDesk_CommonFindRequest
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdBy
     * @return \patest\StructType\HelpDesk_CommonFindRequest
     */
    public function setCreatedBy($createdBy = null)
    {
        // validation for constraint: string
        if (!is_null($createdBy) && !is_string($createdBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdBy, true), gettype($createdBy)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($createdBy) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $createdBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($createdBy, true)), __LINE__);
        }
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedFrom()
    {
        return isset($this->CreatedFrom) ? $this->CreatedFrom : null;
    }
    /**
     * Set CreatedFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdFrom
     * @return \patest\StructType\HelpDesk_CommonFindRequest
     */
    public function setCreatedFrom($createdFrom = null)
    {
        // validation for constraint: string
        if (!is_null($createdFrom) && !is_string($createdFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdFrom, true), gettype($createdFrom)), __LINE__);
        }
        if (is_null($createdFrom) || (is_array($createdFrom) && empty($createdFrom))) {
            unset($this->CreatedFrom);
        } else {
            $this->CreatedFrom = $createdFrom;
        }
        return $this;
    }
    /**
     * Get CreatedUntil value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedUntil()
    {
        return isset($this->CreatedUntil) ? $this->CreatedUntil : null;
    }
    /**
     * Set CreatedUntil value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdUntil
     * @return \patest\StructType\HelpDesk_CommonFindRequest
     */
    public function setCreatedUntil($createdUntil = null)
    {
        // validation for constraint: string
        if (!is_null($createdUntil) && !is_string($createdUntil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdUntil, true), gettype($createdUntil)), __LINE__);
        }
        if (is_null($createdUntil) || (is_array($createdUntil) && empty($createdUntil))) {
            unset($this->CreatedUntil);
        } else {
            $this->CreatedUntil = $createdUntil;
        }
        return $this;
    }
    /**
     * Get EventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventId()
    {
        return isset($this->EventId) ? $this->EventId : null;
    }
    /**
     * Set EventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventId
     * @return \patest\StructType\HelpDesk_CommonFindRequest
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        if (is_null($eventId) || (is_array($eventId) && empty($eventId))) {
            unset($this->EventId);
        } else {
            $this->EventId = $eventId;
        }
        return $this;
    }
    /**
     * Get ExpiryFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExpiryFrom()
    {
        return isset($this->ExpiryFrom) ? $this->ExpiryFrom : null;
    }
    /**
     * Set ExpiryFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $expiryFrom
     * @return \patest\StructType\HelpDesk_CommonFindRequest
     */
    public function setExpiryFrom($expiryFrom = null)
    {
        // validation for constraint: string
        if (!is_null($expiryFrom) && !is_string($expiryFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expiryFrom, true), gettype($expiryFrom)), __LINE__);
        }
        if (is_null($expiryFrom) || (is_array($expiryFrom) && empty($expiryFrom))) {
            unset($this->ExpiryFrom);
        } else {
            $this->ExpiryFrom = $expiryFrom;
        }
        return $this;
    }
    /**
     * Get ExpiryUntil value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExpiryUntil()
    {
        return isset($this->ExpiryUntil) ? $this->ExpiryUntil : null;
    }
    /**
     * Set ExpiryUntil value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $expiryUntil
     * @return \patest\StructType\HelpDesk_CommonFindRequest
     */
    public function setExpiryUntil($expiryUntil = null)
    {
        // validation for constraint: string
        if (!is_null($expiryUntil) && !is_string($expiryUntil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expiryUntil, true), gettype($expiryUntil)), __LINE__);
        }
        if (is_null($expiryUntil) || (is_array($expiryUntil) && empty($expiryUntil))) {
            unset($this->ExpiryUntil);
        } else {
            $this->ExpiryUntil = $expiryUntil;
        }
        return $this;
    }
    /**
     * Get ExplanationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExplanationId()
    {
        return isset($this->ExplanationId) ? $this->ExplanationId : null;
    }
    /**
     * Set ExplanationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $explanationId
     * @return \patest\StructType\HelpDesk_CommonFindRequest
     */
    public function setExplanationId($explanationId = null)
    {
        // validation for constraint: string
        if (!is_null($explanationId) && !is_string($explanationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($explanationId, true), gettype($explanationId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($explanationId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $explanationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($explanationId, true)), __LINE__);
        }
        if (is_null($explanationId) || (is_array($explanationId) && empty($explanationId))) {
            unset($this->ExplanationId);
        } else {
            $this->ExplanationId = $explanationId;
        }
        return $this;
    }
    /**
     * Get GiftVoucherDefinitionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGiftVoucherDefinitionId()
    {
        return isset($this->GiftVoucherDefinitionId) ? $this->GiftVoucherDefinitionId : null;
    }
    /**
     * Set GiftVoucherDefinitionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $giftVoucherDefinitionId
     * @return \patest\StructType\HelpDesk_CommonFindRequest
     */
    public function setGiftVoucherDefinitionId($giftVoucherDefinitionId = null)
    {
        // validation for constraint: string
        if (!is_null($giftVoucherDefinitionId) && !is_string($giftVoucherDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftVoucherDefinitionId, true), gettype($giftVoucherDefinitionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($giftVoucherDefinitionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $giftVoucherDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($giftVoucherDefinitionId, true)), __LINE__);
        }
        if (is_null($giftVoucherDefinitionId) || (is_array($giftVoucherDefinitionId) && empty($giftVoucherDefinitionId))) {
            unset($this->GiftVoucherDefinitionId);
        } else {
            $this->GiftVoucherDefinitionId = $giftVoucherDefinitionId;
        }
        return $this;
    }
    /**
     * Get HandledOnDateFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHandledOnDateFrom()
    {
        return isset($this->HandledOnDateFrom) ? $this->HandledOnDateFrom : null;
    }
    /**
     * Set HandledOnDateFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $handledOnDateFrom
     * @return \patest\StructType\HelpDesk_CommonFindRequest
     */
    public function setHandledOnDateFrom($handledOnDateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($handledOnDateFrom) && !is_string($handledOnDateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($handledOnDateFrom, true), gettype($handledOnDateFrom)), __LINE__);
        }
        if (is_null($handledOnDateFrom) || (is_array($handledOnDateFrom) && empty($handledOnDateFrom))) {
            unset($this->HandledOnDateFrom);
        } else {
            $this->HandledOnDateFrom = $handledOnDateFrom;
        }
        return $this;
    }
    /**
     * Get HandledOnDateUntil value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHandledOnDateUntil()
    {
        return isset($this->HandledOnDateUntil) ? $this->HandledOnDateUntil : null;
    }
    /**
     * Set HandledOnDateUntil value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $handledOnDateUntil
     * @return \patest\StructType\HelpDesk_CommonFindRequest
     */
    public function setHandledOnDateUntil($handledOnDateUntil = null)
    {
        // validation for constraint: string
        if (!is_null($handledOnDateUntil) && !is_string($handledOnDateUntil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($handledOnDateUntil, true), gettype($handledOnDateUntil)), __LINE__);
        }
        if (is_null($handledOnDateUntil) || (is_array($handledOnDateUntil) && empty($handledOnDateUntil))) {
            unset($this->HandledOnDateUntil);
        } else {
            $this->HandledOnDateUntil = $handledOnDateUntil;
        }
        return $this;
    }
    /**
     * Get HandleRequestNotLaterThanFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHandleRequestNotLaterThanFrom()
    {
        return isset($this->HandleRequestNotLaterThanFrom) ? $this->HandleRequestNotLaterThanFrom : null;
    }
    /**
     * Set HandleRequestNotLaterThanFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $handleRequestNotLaterThanFrom
     * @return \patest\StructType\HelpDesk_CommonFindRequest
     */
    public function setHandleRequestNotLaterThanFrom($handleRequestNotLaterThanFrom = null)
    {
        // validation for constraint: string
        if (!is_null($handleRequestNotLaterThanFrom) && !is_string($handleRequestNotLaterThanFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($handleRequestNotLaterThanFrom, true), gettype($handleRequestNotLaterThanFrom)), __LINE__);
        }
        if (is_null($handleRequestNotLaterThanFrom) || (is_array($handleRequestNotLaterThanFrom) && empty($handleRequestNotLaterThanFrom))) {
            unset($this->HandleRequestNotLaterThanFrom);
        } else {
            $this->HandleRequestNotLaterThanFrom = $handleRequestNotLaterThanFrom;
        }
        return $this;
    }
    /**
     * Get HandleRequestNotLaterThanUntil value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHandleRequestNotLaterThanUntil()
    {
        return isset($this->HandleRequestNotLaterThanUntil) ? $this->HandleRequestNotLaterThanUntil : null;
    }
    /**
     * Set HandleRequestNotLaterThanUntil value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $handleRequestNotLaterThanUntil
     * @return \patest\StructType\HelpDesk_CommonFindRequest
     */
    public function setHandleRequestNotLaterThanUntil($handleRequestNotLaterThanUntil = null)
    {
        // validation for constraint: string
        if (!is_null($handleRequestNotLaterThanUntil) && !is_string($handleRequestNotLaterThanUntil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($handleRequestNotLaterThanUntil, true), gettype($handleRequestNotLaterThanUntil)), __LINE__);
        }
        if (is_null($handleRequestNotLaterThanUntil) || (is_array($handleRequestNotLaterThanUntil) && empty($handleRequestNotLaterThanUntil))) {
            unset($this->HandleRequestNotLaterThanUntil);
        } else {
            $this->HandleRequestNotLaterThanUntil = $handleRequestNotLaterThanUntil;
        }
        return $this;
    }
    /**
     * Get HardwareType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHardwareType()
    {
        return isset($this->HardwareType) ? $this->HardwareType : null;
    }
    /**
     * Set HardwareType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\HardwareTypes::valueIsValid()
     * @uses \patest\EnumType\HardwareTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $hardwareType
     * @return \patest\StructType\HelpDesk_CommonFindRequest
     */
    public function setHardwareType($hardwareType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\HardwareTypes::valueIsValid($hardwareType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\HardwareTypes', is_array($hardwareType) ? implode(', ', $hardwareType) : var_export($hardwareType, true), implode(', ', \patest\EnumType\HardwareTypes::getValidValues())), __LINE__);
        }
        if (is_null($hardwareType) || (is_array($hardwareType) && empty($hardwareType))) {
            unset($this->HardwareType);
        } else {
            $this->HardwareType = $hardwareType;
        }
        return $this;
    }
    /**
     * Get ItemType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemType()
    {
        return isset($this->ItemType) ? $this->ItemType : null;
    }
    /**
     * Set ItemType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\AllItemTypes::valueIsValid()
     * @uses \patest\EnumType\AllItemTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $itemType
     * @return \patest\StructType\HelpDesk_CommonFindRequest
     */
    public function setItemType($itemType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\AllItemTypes::valueIsValid($itemType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\AllItemTypes', is_array($itemType) ? implode(', ', $itemType) : var_export($itemType, true), implode(', ', \patest\EnumType\AllItemTypes::getValidValues())), __LINE__);
        }
        if (is_null($itemType) || (is_array($itemType) && empty($itemType))) {
            unset($this->ItemType);
        } else {
            $this->ItemType = $itemType;
        }
        return $this;
    }
    /**
     * Get MembershipDefinitionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMembershipDefinitionId()
    {
        return isset($this->MembershipDefinitionId) ? $this->MembershipDefinitionId : null;
    }
    /**
     * Set MembershipDefinitionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $membershipDefinitionId
     * @return \patest\StructType\HelpDesk_CommonFindRequest
     */
    public function setMembershipDefinitionId($membershipDefinitionId = null)
    {
        // validation for constraint: string
        if (!is_null($membershipDefinitionId) && !is_string($membershipDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($membershipDefinitionId, true), gettype($membershipDefinitionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($membershipDefinitionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $membershipDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($membershipDefinitionId, true)), __LINE__);
        }
        if (is_null($membershipDefinitionId) || (is_array($membershipDefinitionId) && empty($membershipDefinitionId))) {
            unset($this->MembershipDefinitionId);
        } else {
            $this->MembershipDefinitionId = $membershipDefinitionId;
        }
        return $this;
    }
    /**
     * Get MerchandiseId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMerchandiseId()
    {
        return isset($this->MerchandiseId) ? $this->MerchandiseId : null;
    }
    /**
     * Set MerchandiseId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $merchandiseId
     * @return \patest\StructType\HelpDesk_CommonFindRequest
     */
    public function setMerchandiseId($merchandiseId = null)
    {
        // validation for constraint: string
        if (!is_null($merchandiseId) && !is_string($merchandiseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchandiseId, true), gettype($merchandiseId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($merchandiseId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $merchandiseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($merchandiseId, true)), __LINE__);
        }
        if (is_null($merchandiseId) || (is_array($merchandiseId) && empty($merchandiseId))) {
            unset($this->MerchandiseId);
        } else {
            $this->MerchandiseId = $merchandiseId;
        }
        return $this;
    }
    /**
     * Get PriceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceTypeId()
    {
        return isset($this->PriceTypeId) ? $this->PriceTypeId : null;
    }
    /**
     * Set PriceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceTypeId
     * @return \patest\StructType\HelpDesk_CommonFindRequest
     */
    public function setPriceTypeId($priceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($priceTypeId) && !is_string($priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceTypeId, true), gettype($priceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceTypeId, true)), __LINE__);
        }
        if (is_null($priceTypeId) || (is_array($priceTypeId) && empty($priceTypeId))) {
            unset($this->PriceTypeId);
        } else {
            $this->PriceTypeId = $priceTypeId;
        }
        return $this;
    }
    /**
     * Get PrinterId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrinterId()
    {
        return isset($this->PrinterId) ? $this->PrinterId : null;
    }
    /**
     * Set PrinterId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $printerId
     * @return \patest\StructType\HelpDesk_CommonFindRequest
     */
    public function setPrinterId($printerId = null)
    {
        // validation for constraint: string
        if (!is_null($printerId) && !is_string($printerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($printerId, true), gettype($printerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($printerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $printerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($printerId, true)), __LINE__);
        }
        if (is_null($printerId) || (is_array($printerId) && empty($printerId))) {
            unset($this->PrinterId);
        } else {
            $this->PrinterId = $printerId;
        }
        return $this;
    }
    /**
     * Get Priority value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriority()
    {
        return isset($this->Priority) ? $this->Priority : null;
    }
    /**
     * Set Priority value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\RequestPriority::valueIsValid()
     * @uses \patest\EnumType\RequestPriority::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $priority
     * @return \patest\StructType\HelpDesk_CommonFindRequest
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\RequestPriority::valueIsValid($priority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\RequestPriority', is_array($priority) ? implode(', ', $priority) : var_export($priority, true), implode(', ', \patest\EnumType\RequestPriority::getValidValues())), __LINE__);
        }
        if (is_null($priority) || (is_array($priority) && empty($priority))) {
            unset($this->Priority);
        } else {
            $this->Priority = $priority;
        }
        return $this;
    }
    /**
     * Get QuantityFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getQuantityFrom()
    {
        return isset($this->QuantityFrom) ? $this->QuantityFrom : null;
    }
    /**
     * Set QuantityFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $quantityFrom
     * @return \patest\StructType\HelpDesk_CommonFindRequest
     */
    public function setQuantityFrom($quantityFrom = null)
    {
        // validation for constraint: int
        if (!is_null($quantityFrom) && !(is_int($quantityFrom) || ctype_digit($quantityFrom))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantityFrom, true), gettype($quantityFrom)), __LINE__);
        }
        if (is_null($quantityFrom) || (is_array($quantityFrom) && empty($quantityFrom))) {
            unset($this->QuantityFrom);
        } else {
            $this->QuantityFrom = $quantityFrom;
        }
        return $this;
    }
    /**
     * Get QuantityTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getQuantityTo()
    {
        return isset($this->QuantityTo) ? $this->QuantityTo : null;
    }
    /**
     * Set QuantityTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $quantityTo
     * @return \patest\StructType\HelpDesk_CommonFindRequest
     */
    public function setQuantityTo($quantityTo = null)
    {
        // validation for constraint: int
        if (!is_null($quantityTo) && !(is_int($quantityTo) || ctype_digit($quantityTo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantityTo, true), gettype($quantityTo)), __LINE__);
        }
        if (is_null($quantityTo) || (is_array($quantityTo) && empty($quantityTo))) {
            unset($this->QuantityTo);
        } else {
            $this->QuantityTo = $quantityTo;
        }
        return $this;
    }
    /**
     * Get QueryName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getQueryName()
    {
        return isset($this->QueryName) ? $this->QueryName : null;
    }
    /**
     * Set QueryName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $queryName
     * @return \patest\StructType\HelpDesk_CommonFindRequest
     */
    public function setQueryName($queryName = null)
    {
        // validation for constraint: string
        if (!is_null($queryName) && !is_string($queryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($queryName, true), gettype($queryName)), __LINE__);
        }
        if (is_null($queryName) || (is_array($queryName) && empty($queryName))) {
            unset($this->QueryName);
        } else {
            $this->QueryName = $queryName;
        }
        return $this;
    }
    /**
     * Get RelatedDepartment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelatedDepartment()
    {
        return isset($this->RelatedDepartment) ? $this->RelatedDepartment : null;
    }
    /**
     * Set RelatedDepartment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relatedDepartment
     * @return \patest\StructType\HelpDesk_CommonFindRequest
     */
    public function setRelatedDepartment($relatedDepartment = null)
    {
        // validation for constraint: string
        if (!is_null($relatedDepartment) && !is_string($relatedDepartment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relatedDepartment, true), gettype($relatedDepartment)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($relatedDepartment) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $relatedDepartment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($relatedDepartment, true)), __LINE__);
        }
        if (is_null($relatedDepartment) || (is_array($relatedDepartment) && empty($relatedDepartment))) {
            unset($this->RelatedDepartment);
        } else {
            $this->RelatedDepartment = $relatedDepartment;
        }
        return $this;
    }
    /**
     * Get RelatedUser value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelatedUser()
    {
        return isset($this->RelatedUser) ? $this->RelatedUser : null;
    }
    /**
     * Set RelatedUser value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relatedUser
     * @return \patest\StructType\HelpDesk_CommonFindRequest
     */
    public function setRelatedUser($relatedUser = null)
    {
        // validation for constraint: string
        if (!is_null($relatedUser) && !is_string($relatedUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relatedUser, true), gettype($relatedUser)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($relatedUser) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $relatedUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($relatedUser, true)), __LINE__);
        }
        if (is_null($relatedUser) || (is_array($relatedUser) && empty($relatedUser))) {
            unset($this->RelatedUser);
        } else {
            $this->RelatedUser = $relatedUser;
        }
        return $this;
    }
    /**
     * Get RequestCategory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestCategory()
    {
        return isset($this->RequestCategory) ? $this->RequestCategory : null;
    }
    /**
     * Set RequestCategory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestCategory
     * @return \patest\StructType\HelpDesk_CommonFindRequest
     */
    public function setRequestCategory($requestCategory = null)
    {
        // validation for constraint: string
        if (!is_null($requestCategory) && !is_string($requestCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestCategory, true), gettype($requestCategory)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($requestCategory) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $requestCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($requestCategory, true)), __LINE__);
        }
        if (is_null($requestCategory) || (is_array($requestCategory) && empty($requestCategory))) {
            unset($this->RequestCategory);
        } else {
            $this->RequestCategory = $requestCategory;
        }
        return $this;
    }
    /**
     * Get RequestType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestType()
    {
        return isset($this->RequestType) ? $this->RequestType : null;
    }
    /**
     * Set RequestType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestType
     * @return \patest\StructType\HelpDesk_CommonFindRequest
     */
    public function setRequestType($requestType = null)
    {
        // validation for constraint: string
        if (!is_null($requestType) && !is_string($requestType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestType, true), gettype($requestType)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($requestType) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $requestType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($requestType, true)), __LINE__);
        }
        if (is_null($requestType) || (is_array($requestType) && empty($requestType))) {
            unset($this->RequestType);
        } else {
            $this->RequestType = $requestType;
        }
        return $this;
    }
    /**
     * Get RequiredAction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequiredAction()
    {
        return isset($this->RequiredAction) ? $this->RequiredAction : null;
    }
    /**
     * Set RequiredAction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requiredAction
     * @return \patest\StructType\HelpDesk_CommonFindRequest
     */
    public function setRequiredAction($requiredAction = null)
    {
        // validation for constraint: string
        if (!is_null($requiredAction) && !is_string($requiredAction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requiredAction, true), gettype($requiredAction)), __LINE__);
        }
        if (is_null($requiredAction) || (is_array($requiredAction) && empty($requiredAction))) {
            unset($this->RequiredAction);
        } else {
            $this->RequiredAction = $requiredAction;
        }
        return $this;
    }
    /**
     * Get SalePointId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalePointId()
    {
        return isset($this->SalePointId) ? $this->SalePointId : null;
    }
    /**
     * Set SalePointId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salePointId
     * @return \patest\StructType\HelpDesk_CommonFindRequest
     */
    public function setSalePointId($salePointId = null)
    {
        // validation for constraint: string
        if (!is_null($salePointId) && !is_string($salePointId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salePointId, true), gettype($salePointId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($salePointId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $salePointId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($salePointId, true)), __LINE__);
        }
        if (is_null($salePointId) || (is_array($salePointId) && empty($salePointId))) {
            unset($this->SalePointId);
        } else {
            $this->SalePointId = $salePointId;
        }
        return $this;
    }
    /**
     * Get ScannerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getScannerId()
    {
        return isset($this->ScannerId) ? $this->ScannerId : null;
    }
    /**
     * Set ScannerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $scannerId
     * @return \patest\StructType\HelpDesk_CommonFindRequest
     */
    public function setScannerId($scannerId = null)
    {
        // validation for constraint: string
        if (!is_null($scannerId) && !is_string($scannerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scannerId, true), gettype($scannerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($scannerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $scannerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($scannerId, true)), __LINE__);
        }
        if (is_null($scannerId) || (is_array($scannerId) && empty($scannerId))) {
            unset($this->ScannerId);
        } else {
            $this->ScannerId = $scannerId;
        }
        return $this;
    }
    /**
     * Get SeasonId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeasonId()
    {
        return isset($this->SeasonId) ? $this->SeasonId : null;
    }
    /**
     * Set SeasonId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seasonId
     * @return \patest\StructType\HelpDesk_CommonFindRequest
     */
    public function setSeasonId($seasonId = null)
    {
        // validation for constraint: string
        if (!is_null($seasonId) && !is_string($seasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seasonId, true), gettype($seasonId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seasonId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seasonId, true)), __LINE__);
        }
        if (is_null($seasonId) || (is_array($seasonId) && empty($seasonId))) {
            unset($this->SeasonId);
        } else {
            $this->SeasonId = $seasonId;
        }
        return $this;
    }
    /**
     * Get SeriesId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesId()
    {
        return isset($this->SeriesId) ? $this->SeriesId : null;
    }
    /**
     * Set SeriesId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesId
     * @return \patest\StructType\HelpDesk_CommonFindRequest
     */
    public function setSeriesId($seriesId = null)
    {
        // validation for constraint: string
        if (!is_null($seriesId) && !is_string($seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesId, true), gettype($seriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seriesId, true)), __LINE__);
        }
        if (is_null($seriesId) || (is_array($seriesId) && empty($seriesId))) {
            unset($this->SeriesId);
        } else {
            $this->SeriesId = $seriesId;
        }
        return $this;
    }
    /**
     * Get ShowId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowId()
    {
        return isset($this->ShowId) ? $this->ShowId : null;
    }
    /**
     * Set ShowId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showId
     * @return \patest\StructType\HelpDesk_CommonFindRequest
     */
    public function setShowId($showId = null)
    {
        // validation for constraint: string
        if (!is_null($showId) && !is_string($showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showId, true), gettype($showId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($showId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($showId, true)), __LINE__);
        }
        if (is_null($showId) || (is_array($showId) && empty($showId))) {
            unset($this->ShowId);
        } else {
            $this->ShowId = $showId;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $status
     * @return \patest\StructType\HelpDesk_CommonFindRequest
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($status) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($status, true)), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get SubsidizingOrg value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubsidizingOrg()
    {
        return isset($this->SubsidizingOrg) ? $this->SubsidizingOrg : null;
    }
    /**
     * Set SubsidizingOrg value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subsidizingOrg
     * @return \patest\StructType\HelpDesk_CommonFindRequest
     */
    public function setSubsidizingOrg($subsidizingOrg = null)
    {
        // validation for constraint: string
        if (!is_null($subsidizingOrg) && !is_string($subsidizingOrg)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subsidizingOrg, true), gettype($subsidizingOrg)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($subsidizingOrg) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $subsidizingOrg)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($subsidizingOrg, true)), __LINE__);
        }
        if (is_null($subsidizingOrg) || (is_array($subsidizingOrg) && empty($subsidizingOrg))) {
            unset($this->SubsidizingOrg);
        } else {
            $this->SubsidizingOrg = $subsidizingOrg;
        }
        return $this;
    }
    /**
     * Get Topic value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTopic()
    {
        return isset($this->Topic) ? $this->Topic : null;
    }
    /**
     * Set Topic value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $topic
     * @return \patest\StructType\HelpDesk_CommonFindRequest
     */
    public function setTopic($topic = null)
    {
        // validation for constraint: string
        if (!is_null($topic) && !is_string($topic)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($topic, true), gettype($topic)), __LINE__);
        }
        if (is_null($topic) || (is_array($topic) && empty($topic))) {
            unset($this->Topic);
        } else {
            $this->Topic = $topic;
        }
        return $this;
    }
}
