<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GiftVoucher.GiftVoucherDefinition StructType
 * @subpackage Structs
 */
class GiftVoucher_GiftVoucherDefinition extends GiftVoucher_Base
{
    /**
     * The AclSchemeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AclSchemeId;
    /**
     * The AfterExpiryLedgerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AfterExpiryLedgerId;
    /**
     * The AvailableForDisplayFrom
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AvailableForDisplayFrom;
    /**
     * The AvailableForDisplayUntil
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AvailableForDisplayUntil;
    /**
     * The AvailableForSaleFrom
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AvailableForSaleFrom;
    /**
     * The AvailableForSaleUntil
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AvailableForSaleUntil;
    /**
     * The BeneficiaryTicketsQuantity
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $BeneficiaryTicketsQuantity;
    /**
     * The CrossOrgUnitsAclSchemeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CrossOrgUnitsAclSchemeId;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Description;
    /**
     * The ExpiresInDays
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ExpiresInDays;
    /**
     * The GiftVoucherTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GiftVoucherTypeId;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The IsAvailableForDisplay
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAvailableForDisplay;
    /**
     * The IsAvailableForSale
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAvailableForSale;
    /**
     * The IsClientMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsClientMessage;
    /**
     * The IsMultipleRedeemable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsMultipleRedeemable;
    /**
     * The IsPrePrinted
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPrePrinted;
    /**
     * The LedgerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LedgerId;
    /**
     * The MaximumValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $MaximumValue;
    /**
     * The Media
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GiftVoucher_Media
     */
    public $Media;
    /**
     * The MinimumValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $MinimumValue;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The PricingOption
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PricingOption;
    /**
     * The ProjectIdentifierId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ProjectIdentifierId;
    /**
     * The RedemptionValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $RedemptionValue;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Type;
    /**
     * The ValidFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ValidFrom;
    /**
     * The ValidUntil
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ValidUntil;
    /**
     * The VisibleBySubordinates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $VisibleBySubordinates;
    /**
     * Constructor method for GiftVoucher.GiftVoucherDefinition
     * @uses GiftVoucher_GiftVoucherDefinition::setAclSchemeId()
     * @uses GiftVoucher_GiftVoucherDefinition::setAfterExpiryLedgerId()
     * @uses GiftVoucher_GiftVoucherDefinition::setAvailableForDisplayFrom()
     * @uses GiftVoucher_GiftVoucherDefinition::setAvailableForDisplayUntil()
     * @uses GiftVoucher_GiftVoucherDefinition::setAvailableForSaleFrom()
     * @uses GiftVoucher_GiftVoucherDefinition::setAvailableForSaleUntil()
     * @uses GiftVoucher_GiftVoucherDefinition::setBeneficiaryTicketsQuantity()
     * @uses GiftVoucher_GiftVoucherDefinition::setCrossOrgUnitsAclSchemeId()
     * @uses GiftVoucher_GiftVoucherDefinition::setDescription()
     * @uses GiftVoucher_GiftVoucherDefinition::setExpiresInDays()
     * @uses GiftVoucher_GiftVoucherDefinition::setGiftVoucherTypeId()
     * @uses GiftVoucher_GiftVoucherDefinition::setIsActive()
     * @uses GiftVoucher_GiftVoucherDefinition::setIsAvailableForDisplay()
     * @uses GiftVoucher_GiftVoucherDefinition::setIsAvailableForSale()
     * @uses GiftVoucher_GiftVoucherDefinition::setIsClientMessage()
     * @uses GiftVoucher_GiftVoucherDefinition::setIsMultipleRedeemable()
     * @uses GiftVoucher_GiftVoucherDefinition::setIsPrePrinted()
     * @uses GiftVoucher_GiftVoucherDefinition::setLedgerId()
     * @uses GiftVoucher_GiftVoucherDefinition::setMaximumValue()
     * @uses GiftVoucher_GiftVoucherDefinition::setMedia()
     * @uses GiftVoucher_GiftVoucherDefinition::setMinimumValue()
     * @uses GiftVoucher_GiftVoucherDefinition::setName()
     * @uses GiftVoucher_GiftVoucherDefinition::setOrganizationUnitId()
     * @uses GiftVoucher_GiftVoucherDefinition::setPricingOption()
     * @uses GiftVoucher_GiftVoucherDefinition::setProjectIdentifierId()
     * @uses GiftVoucher_GiftVoucherDefinition::setRedemptionValue()
     * @uses GiftVoucher_GiftVoucherDefinition::setType()
     * @uses GiftVoucher_GiftVoucherDefinition::setValidFrom()
     * @uses GiftVoucher_GiftVoucherDefinition::setValidUntil()
     * @uses GiftVoucher_GiftVoucherDefinition::setVisibleBySubordinates()
     * @param int $aclSchemeId
     * @param string $afterExpiryLedgerId
     * @param string $availableForDisplayFrom
     * @param string $availableForDisplayUntil
     * @param string $availableForSaleFrom
     * @param string $availableForSaleUntil
     * @param int $beneficiaryTicketsQuantity
     * @param int $crossOrgUnitsAclSchemeId
     * @param \patest\StructType\GlobalString $description
     * @param int $expiresInDays
     * @param string $giftVoucherTypeId
     * @param bool $isActive
     * @param bool $isAvailableForDisplay
     * @param bool $isAvailableForSale
     * @param bool $isClientMessage
     * @param bool $isMultipleRedeemable
     * @param bool $isPrePrinted
     * @param string $ledgerId
     * @param float $maximumValue
     * @param \patest\StructType\GiftVoucher_Media $media
     * @param float $minimumValue
     * @param \patest\StructType\GlobalString $name
     * @param string $organizationUnitId
     * @param string $pricingOption
     * @param string $projectIdentifierId
     * @param float $redemptionValue
     * @param string $type
     * @param string $validFrom
     * @param string $validUntil
     * @param bool $visibleBySubordinates
     */
    public function __construct($aclSchemeId = null, $afterExpiryLedgerId = null, $availableForDisplayFrom = null, $availableForDisplayUntil = null, $availableForSaleFrom = null, $availableForSaleUntil = null, $beneficiaryTicketsQuantity = null, $crossOrgUnitsAclSchemeId = null, \patest\StructType\GlobalString $description = null, $expiresInDays = null, $giftVoucherTypeId = null, $isActive = null, $isAvailableForDisplay = null, $isAvailableForSale = null, $isClientMessage = null, $isMultipleRedeemable = null, $isPrePrinted = null, $ledgerId = null, $maximumValue = null, \patest\StructType\GiftVoucher_Media $media = null, $minimumValue = null, \patest\StructType\GlobalString $name = null, $organizationUnitId = null, $pricingOption = null, $projectIdentifierId = null, $redemptionValue = null, $type = null, $validFrom = null, $validUntil = null, $visibleBySubordinates = null)
    {
        $this
            ->setAclSchemeId($aclSchemeId)
            ->setAfterExpiryLedgerId($afterExpiryLedgerId)
            ->setAvailableForDisplayFrom($availableForDisplayFrom)
            ->setAvailableForDisplayUntil($availableForDisplayUntil)
            ->setAvailableForSaleFrom($availableForSaleFrom)
            ->setAvailableForSaleUntil($availableForSaleUntil)
            ->setBeneficiaryTicketsQuantity($beneficiaryTicketsQuantity)
            ->setCrossOrgUnitsAclSchemeId($crossOrgUnitsAclSchemeId)
            ->setDescription($description)
            ->setExpiresInDays($expiresInDays)
            ->setGiftVoucherTypeId($giftVoucherTypeId)
            ->setIsActive($isActive)
            ->setIsAvailableForDisplay($isAvailableForDisplay)
            ->setIsAvailableForSale($isAvailableForSale)
            ->setIsClientMessage($isClientMessage)
            ->setIsMultipleRedeemable($isMultipleRedeemable)
            ->setIsPrePrinted($isPrePrinted)
            ->setLedgerId($ledgerId)
            ->setMaximumValue($maximumValue)
            ->setMedia($media)
            ->setMinimumValue($minimumValue)
            ->setName($name)
            ->setOrganizationUnitId($organizationUnitId)
            ->setPricingOption($pricingOption)
            ->setProjectIdentifierId($projectIdentifierId)
            ->setRedemptionValue($redemptionValue)
            ->setType($type)
            ->setValidFrom($validFrom)
            ->setValidUntil($validUntil)
            ->setVisibleBySubordinates($visibleBySubordinates);
    }
    /**
     * Get AclSchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAclSchemeId()
    {
        return isset($this->AclSchemeId) ? $this->AclSchemeId : null;
    }
    /**
     * Set AclSchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aclSchemeId
     * @return \patest\StructType\GiftVoucher_GiftVoucherDefinition
     */
    public function setAclSchemeId($aclSchemeId = null)
    {
        // validation for constraint: int
        if (!is_null($aclSchemeId) && !(is_int($aclSchemeId) || ctype_digit($aclSchemeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aclSchemeId, true), gettype($aclSchemeId)), __LINE__);
        }
        if (is_null($aclSchemeId) || (is_array($aclSchemeId) && empty($aclSchemeId))) {
            unset($this->AclSchemeId);
        } else {
            $this->AclSchemeId = $aclSchemeId;
        }
        return $this;
    }
    /**
     * Get AfterExpiryLedgerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAfterExpiryLedgerId()
    {
        return isset($this->AfterExpiryLedgerId) ? $this->AfterExpiryLedgerId : null;
    }
    /**
     * Set AfterExpiryLedgerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $afterExpiryLedgerId
     * @return \patest\StructType\GiftVoucher_GiftVoucherDefinition
     */
    public function setAfterExpiryLedgerId($afterExpiryLedgerId = null)
    {
        // validation for constraint: string
        if (!is_null($afterExpiryLedgerId) && !is_string($afterExpiryLedgerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($afterExpiryLedgerId, true), gettype($afterExpiryLedgerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($afterExpiryLedgerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $afterExpiryLedgerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($afterExpiryLedgerId, true)), __LINE__);
        }
        if (is_null($afterExpiryLedgerId) || (is_array($afterExpiryLedgerId) && empty($afterExpiryLedgerId))) {
            unset($this->AfterExpiryLedgerId);
        } else {
            $this->AfterExpiryLedgerId = $afterExpiryLedgerId;
        }
        return $this;
    }
    /**
     * Get AvailableForDisplayFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAvailableForDisplayFrom()
    {
        return isset($this->AvailableForDisplayFrom) ? $this->AvailableForDisplayFrom : null;
    }
    /**
     * Set AvailableForDisplayFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $availableForDisplayFrom
     * @return \patest\StructType\GiftVoucher_GiftVoucherDefinition
     */
    public function setAvailableForDisplayFrom($availableForDisplayFrom = null)
    {
        // validation for constraint: string
        if (!is_null($availableForDisplayFrom) && !is_string($availableForDisplayFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($availableForDisplayFrom, true), gettype($availableForDisplayFrom)), __LINE__);
        }
        if (is_null($availableForDisplayFrom) || (is_array($availableForDisplayFrom) && empty($availableForDisplayFrom))) {
            unset($this->AvailableForDisplayFrom);
        } else {
            $this->AvailableForDisplayFrom = $availableForDisplayFrom;
        }
        return $this;
    }
    /**
     * Get AvailableForDisplayUntil value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAvailableForDisplayUntil()
    {
        return isset($this->AvailableForDisplayUntil) ? $this->AvailableForDisplayUntil : null;
    }
    /**
     * Set AvailableForDisplayUntil value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $availableForDisplayUntil
     * @return \patest\StructType\GiftVoucher_GiftVoucherDefinition
     */
    public function setAvailableForDisplayUntil($availableForDisplayUntil = null)
    {
        // validation for constraint: string
        if (!is_null($availableForDisplayUntil) && !is_string($availableForDisplayUntil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($availableForDisplayUntil, true), gettype($availableForDisplayUntil)), __LINE__);
        }
        if (is_null($availableForDisplayUntil) || (is_array($availableForDisplayUntil) && empty($availableForDisplayUntil))) {
            unset($this->AvailableForDisplayUntil);
        } else {
            $this->AvailableForDisplayUntil = $availableForDisplayUntil;
        }
        return $this;
    }
    /**
     * Get AvailableForSaleFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAvailableForSaleFrom()
    {
        return isset($this->AvailableForSaleFrom) ? $this->AvailableForSaleFrom : null;
    }
    /**
     * Set AvailableForSaleFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $availableForSaleFrom
     * @return \patest\StructType\GiftVoucher_GiftVoucherDefinition
     */
    public function setAvailableForSaleFrom($availableForSaleFrom = null)
    {
        // validation for constraint: string
        if (!is_null($availableForSaleFrom) && !is_string($availableForSaleFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($availableForSaleFrom, true), gettype($availableForSaleFrom)), __LINE__);
        }
        if (is_null($availableForSaleFrom) || (is_array($availableForSaleFrom) && empty($availableForSaleFrom))) {
            unset($this->AvailableForSaleFrom);
        } else {
            $this->AvailableForSaleFrom = $availableForSaleFrom;
        }
        return $this;
    }
    /**
     * Get AvailableForSaleUntil value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAvailableForSaleUntil()
    {
        return isset($this->AvailableForSaleUntil) ? $this->AvailableForSaleUntil : null;
    }
    /**
     * Set AvailableForSaleUntil value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $availableForSaleUntil
     * @return \patest\StructType\GiftVoucher_GiftVoucherDefinition
     */
    public function setAvailableForSaleUntil($availableForSaleUntil = null)
    {
        // validation for constraint: string
        if (!is_null($availableForSaleUntil) && !is_string($availableForSaleUntil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($availableForSaleUntil, true), gettype($availableForSaleUntil)), __LINE__);
        }
        if (is_null($availableForSaleUntil) || (is_array($availableForSaleUntil) && empty($availableForSaleUntil))) {
            unset($this->AvailableForSaleUntil);
        } else {
            $this->AvailableForSaleUntil = $availableForSaleUntil;
        }
        return $this;
    }
    /**
     * Get BeneficiaryTicketsQuantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBeneficiaryTicketsQuantity()
    {
        return isset($this->BeneficiaryTicketsQuantity) ? $this->BeneficiaryTicketsQuantity : null;
    }
    /**
     * Set BeneficiaryTicketsQuantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $beneficiaryTicketsQuantity
     * @return \patest\StructType\GiftVoucher_GiftVoucherDefinition
     */
    public function setBeneficiaryTicketsQuantity($beneficiaryTicketsQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($beneficiaryTicketsQuantity) && !(is_int($beneficiaryTicketsQuantity) || ctype_digit($beneficiaryTicketsQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($beneficiaryTicketsQuantity, true), gettype($beneficiaryTicketsQuantity)), __LINE__);
        }
        if (is_null($beneficiaryTicketsQuantity) || (is_array($beneficiaryTicketsQuantity) && empty($beneficiaryTicketsQuantity))) {
            unset($this->BeneficiaryTicketsQuantity);
        } else {
            $this->BeneficiaryTicketsQuantity = $beneficiaryTicketsQuantity;
        }
        return $this;
    }
    /**
     * Get CrossOrgUnitsAclSchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCrossOrgUnitsAclSchemeId()
    {
        return isset($this->CrossOrgUnitsAclSchemeId) ? $this->CrossOrgUnitsAclSchemeId : null;
    }
    /**
     * Set CrossOrgUnitsAclSchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $crossOrgUnitsAclSchemeId
     * @return \patest\StructType\GiftVoucher_GiftVoucherDefinition
     */
    public function setCrossOrgUnitsAclSchemeId($crossOrgUnitsAclSchemeId = null)
    {
        // validation for constraint: int
        if (!is_null($crossOrgUnitsAclSchemeId) && !(is_int($crossOrgUnitsAclSchemeId) || ctype_digit($crossOrgUnitsAclSchemeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($crossOrgUnitsAclSchemeId, true), gettype($crossOrgUnitsAclSchemeId)), __LINE__);
        }
        if (is_null($crossOrgUnitsAclSchemeId) || (is_array($crossOrgUnitsAclSchemeId) && empty($crossOrgUnitsAclSchemeId))) {
            unset($this->CrossOrgUnitsAclSchemeId);
        } else {
            $this->CrossOrgUnitsAclSchemeId = $crossOrgUnitsAclSchemeId;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $description
     * @return \patest\StructType\GiftVoucher_GiftVoucherDefinition
     */
    public function setDescription(\patest\StructType\GlobalString $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get ExpiresInDays value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getExpiresInDays()
    {
        return isset($this->ExpiresInDays) ? $this->ExpiresInDays : null;
    }
    /**
     * Set ExpiresInDays value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $expiresInDays
     * @return \patest\StructType\GiftVoucher_GiftVoucherDefinition
     */
    public function setExpiresInDays($expiresInDays = null)
    {
        // validation for constraint: int
        if (!is_null($expiresInDays) && !(is_int($expiresInDays) || ctype_digit($expiresInDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($expiresInDays, true), gettype($expiresInDays)), __LINE__);
        }
        if (is_null($expiresInDays) || (is_array($expiresInDays) && empty($expiresInDays))) {
            unset($this->ExpiresInDays);
        } else {
            $this->ExpiresInDays = $expiresInDays;
        }
        return $this;
    }
    /**
     * Get GiftVoucherTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGiftVoucherTypeId()
    {
        return isset($this->GiftVoucherTypeId) ? $this->GiftVoucherTypeId : null;
    }
    /**
     * Set GiftVoucherTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $giftVoucherTypeId
     * @return \patest\StructType\GiftVoucher_GiftVoucherDefinition
     */
    public function setGiftVoucherTypeId($giftVoucherTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($giftVoucherTypeId) && !is_string($giftVoucherTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftVoucherTypeId, true), gettype($giftVoucherTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($giftVoucherTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $giftVoucherTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($giftVoucherTypeId, true)), __LINE__);
        }
        if (is_null($giftVoucherTypeId) || (is_array($giftVoucherTypeId) && empty($giftVoucherTypeId))) {
            unset($this->GiftVoucherTypeId);
        } else {
            $this->GiftVoucherTypeId = $giftVoucherTypeId;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\GiftVoucher_GiftVoucherDefinition
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get IsAvailableForDisplay value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAvailableForDisplay()
    {
        return isset($this->IsAvailableForDisplay) ? $this->IsAvailableForDisplay : null;
    }
    /**
     * Set IsAvailableForDisplay value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAvailableForDisplay
     * @return \patest\StructType\GiftVoucher_GiftVoucherDefinition
     */
    public function setIsAvailableForDisplay($isAvailableForDisplay = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAvailableForDisplay) && !is_bool($isAvailableForDisplay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAvailableForDisplay, true), gettype($isAvailableForDisplay)), __LINE__);
        }
        if (is_null($isAvailableForDisplay) || (is_array($isAvailableForDisplay) && empty($isAvailableForDisplay))) {
            unset($this->IsAvailableForDisplay);
        } else {
            $this->IsAvailableForDisplay = $isAvailableForDisplay;
        }
        return $this;
    }
    /**
     * Get IsAvailableForSale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAvailableForSale()
    {
        return isset($this->IsAvailableForSale) ? $this->IsAvailableForSale : null;
    }
    /**
     * Set IsAvailableForSale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAvailableForSale
     * @return \patest\StructType\GiftVoucher_GiftVoucherDefinition
     */
    public function setIsAvailableForSale($isAvailableForSale = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAvailableForSale) && !is_bool($isAvailableForSale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAvailableForSale, true), gettype($isAvailableForSale)), __LINE__);
        }
        if (is_null($isAvailableForSale) || (is_array($isAvailableForSale) && empty($isAvailableForSale))) {
            unset($this->IsAvailableForSale);
        } else {
            $this->IsAvailableForSale = $isAvailableForSale;
        }
        return $this;
    }
    /**
     * Get IsClientMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsClientMessage()
    {
        return isset($this->IsClientMessage) ? $this->IsClientMessage : null;
    }
    /**
     * Set IsClientMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isClientMessage
     * @return \patest\StructType\GiftVoucher_GiftVoucherDefinition
     */
    public function setIsClientMessage($isClientMessage = null)
    {
        // validation for constraint: boolean
        if (!is_null($isClientMessage) && !is_bool($isClientMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isClientMessage, true), gettype($isClientMessage)), __LINE__);
        }
        if (is_null($isClientMessage) || (is_array($isClientMessage) && empty($isClientMessage))) {
            unset($this->IsClientMessage);
        } else {
            $this->IsClientMessage = $isClientMessage;
        }
        return $this;
    }
    /**
     * Get IsMultipleRedeemable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsMultipleRedeemable()
    {
        return isset($this->IsMultipleRedeemable) ? $this->IsMultipleRedeemable : null;
    }
    /**
     * Set IsMultipleRedeemable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isMultipleRedeemable
     * @return \patest\StructType\GiftVoucher_GiftVoucherDefinition
     */
    public function setIsMultipleRedeemable($isMultipleRedeemable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMultipleRedeemable) && !is_bool($isMultipleRedeemable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isMultipleRedeemable, true), gettype($isMultipleRedeemable)), __LINE__);
        }
        if (is_null($isMultipleRedeemable) || (is_array($isMultipleRedeemable) && empty($isMultipleRedeemable))) {
            unset($this->IsMultipleRedeemable);
        } else {
            $this->IsMultipleRedeemable = $isMultipleRedeemable;
        }
        return $this;
    }
    /**
     * Get IsPrePrinted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPrePrinted()
    {
        return isset($this->IsPrePrinted) ? $this->IsPrePrinted : null;
    }
    /**
     * Set IsPrePrinted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPrePrinted
     * @return \patest\StructType\GiftVoucher_GiftVoucherDefinition
     */
    public function setIsPrePrinted($isPrePrinted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPrePrinted) && !is_bool($isPrePrinted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPrePrinted, true), gettype($isPrePrinted)), __LINE__);
        }
        if (is_null($isPrePrinted) || (is_array($isPrePrinted) && empty($isPrePrinted))) {
            unset($this->IsPrePrinted);
        } else {
            $this->IsPrePrinted = $isPrePrinted;
        }
        return $this;
    }
    /**
     * Get LedgerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLedgerId()
    {
        return isset($this->LedgerId) ? $this->LedgerId : null;
    }
    /**
     * Set LedgerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ledgerId
     * @return \patest\StructType\GiftVoucher_GiftVoucherDefinition
     */
    public function setLedgerId($ledgerId = null)
    {
        // validation for constraint: string
        if (!is_null($ledgerId) && !is_string($ledgerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ledgerId, true), gettype($ledgerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ledgerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ledgerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ledgerId, true)), __LINE__);
        }
        if (is_null($ledgerId) || (is_array($ledgerId) && empty($ledgerId))) {
            unset($this->LedgerId);
        } else {
            $this->LedgerId = $ledgerId;
        }
        return $this;
    }
    /**
     * Get MaximumValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getMaximumValue()
    {
        return isset($this->MaximumValue) ? $this->MaximumValue : null;
    }
    /**
     * Set MaximumValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $maximumValue
     * @return \patest\StructType\GiftVoucher_GiftVoucherDefinition
     */
    public function setMaximumValue($maximumValue = null)
    {
        // validation for constraint: float
        if (!is_null($maximumValue) && !(is_float($maximumValue) || is_numeric($maximumValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maximumValue, true), gettype($maximumValue)), __LINE__);
        }
        if (is_null($maximumValue) || (is_array($maximumValue) && empty($maximumValue))) {
            unset($this->MaximumValue);
        } else {
            $this->MaximumValue = $maximumValue;
        }
        return $this;
    }
    /**
     * Get Media value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GiftVoucher_Media|null
     */
    public function getMedia()
    {
        return isset($this->Media) ? $this->Media : null;
    }
    /**
     * Set Media value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GiftVoucher_Media $media
     * @return \patest\StructType\GiftVoucher_GiftVoucherDefinition
     */
    public function setMedia(\patest\StructType\GiftVoucher_Media $media = null)
    {
        if (is_null($media) || (is_array($media) && empty($media))) {
            unset($this->Media);
        } else {
            $this->Media = $media;
        }
        return $this;
    }
    /**
     * Get MinimumValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getMinimumValue()
    {
        return isset($this->MinimumValue) ? $this->MinimumValue : null;
    }
    /**
     * Set MinimumValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $minimumValue
     * @return \patest\StructType\GiftVoucher_GiftVoucherDefinition
     */
    public function setMinimumValue($minimumValue = null)
    {
        // validation for constraint: float
        if (!is_null($minimumValue) && !(is_float($minimumValue) || is_numeric($minimumValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($minimumValue, true), gettype($minimumValue)), __LINE__);
        }
        if (is_null($minimumValue) || (is_array($minimumValue) && empty($minimumValue))) {
            unset($this->MinimumValue);
        } else {
            $this->MinimumValue = $minimumValue;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\GiftVoucher_GiftVoucherDefinition
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\GiftVoucher_GiftVoucherDefinition
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get PricingOption value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPricingOption()
    {
        return isset($this->PricingOption) ? $this->PricingOption : null;
    }
    /**
     * Set PricingOption value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PricingOption::valueIsValid()
     * @uses \patest\EnumType\PricingOption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pricingOption
     * @return \patest\StructType\GiftVoucher_GiftVoucherDefinition
     */
    public function setPricingOption($pricingOption = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PricingOption::valueIsValid($pricingOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PricingOption', is_array($pricingOption) ? implode(', ', $pricingOption) : var_export($pricingOption, true), implode(', ', \patest\EnumType\PricingOption::getValidValues())), __LINE__);
        }
        if (is_null($pricingOption) || (is_array($pricingOption) && empty($pricingOption))) {
            unset($this->PricingOption);
        } else {
            $this->PricingOption = $pricingOption;
        }
        return $this;
    }
    /**
     * Get ProjectIdentifierId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProjectIdentifierId()
    {
        return isset($this->ProjectIdentifierId) ? $this->ProjectIdentifierId : null;
    }
    /**
     * Set ProjectIdentifierId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $projectIdentifierId
     * @return \patest\StructType\GiftVoucher_GiftVoucherDefinition
     */
    public function setProjectIdentifierId($projectIdentifierId = null)
    {
        // validation for constraint: string
        if (!is_null($projectIdentifierId) && !is_string($projectIdentifierId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($projectIdentifierId, true), gettype($projectIdentifierId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($projectIdentifierId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $projectIdentifierId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($projectIdentifierId, true)), __LINE__);
        }
        if (is_null($projectIdentifierId) || (is_array($projectIdentifierId) && empty($projectIdentifierId))) {
            unset($this->ProjectIdentifierId);
        } else {
            $this->ProjectIdentifierId = $projectIdentifierId;
        }
        return $this;
    }
    /**
     * Get RedemptionValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getRedemptionValue()
    {
        return isset($this->RedemptionValue) ? $this->RedemptionValue : null;
    }
    /**
     * Set RedemptionValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $redemptionValue
     * @return \patest\StructType\GiftVoucher_GiftVoucherDefinition
     */
    public function setRedemptionValue($redemptionValue = null)
    {
        // validation for constraint: float
        if (!is_null($redemptionValue) && !(is_float($redemptionValue) || is_numeric($redemptionValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($redemptionValue, true), gettype($redemptionValue)), __LINE__);
        }
        if (is_null($redemptionValue) || (is_array($redemptionValue) && empty($redemptionValue))) {
            unset($this->RedemptionValue);
        } else {
            $this->RedemptionValue = $redemptionValue;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\GiftVoucherType::valueIsValid()
     * @uses \patest\EnumType\GiftVoucherType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \patest\StructType\GiftVoucher_GiftVoucherDefinition
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\GiftVoucherType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\GiftVoucherType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \patest\EnumType\GiftVoucherType::getValidValues())), __LINE__);
        }
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
    /**
     * Get ValidFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValidFrom()
    {
        return isset($this->ValidFrom) ? $this->ValidFrom : null;
    }
    /**
     * Set ValidFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $validFrom
     * @return \patest\StructType\GiftVoucher_GiftVoucherDefinition
     */
    public function setValidFrom($validFrom = null)
    {
        // validation for constraint: string
        if (!is_null($validFrom) && !is_string($validFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validFrom, true), gettype($validFrom)), __LINE__);
        }
        if (is_null($validFrom) || (is_array($validFrom) && empty($validFrom))) {
            unset($this->ValidFrom);
        } else {
            $this->ValidFrom = $validFrom;
        }
        return $this;
    }
    /**
     * Get ValidUntil value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValidUntil()
    {
        return isset($this->ValidUntil) ? $this->ValidUntil : null;
    }
    /**
     * Set ValidUntil value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $validUntil
     * @return \patest\StructType\GiftVoucher_GiftVoucherDefinition
     */
    public function setValidUntil($validUntil = null)
    {
        // validation for constraint: string
        if (!is_null($validUntil) && !is_string($validUntil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validUntil, true), gettype($validUntil)), __LINE__);
        }
        if (is_null($validUntil) || (is_array($validUntil) && empty($validUntil))) {
            unset($this->ValidUntil);
        } else {
            $this->ValidUntil = $validUntil;
        }
        return $this;
    }
    /**
     * Get VisibleBySubordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getVisibleBySubordinates()
    {
        return isset($this->VisibleBySubordinates) ? $this->VisibleBySubordinates : null;
    }
    /**
     * Set VisibleBySubordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $visibleBySubordinates
     * @return \patest\StructType\GiftVoucher_GiftVoucherDefinition
     */
    public function setVisibleBySubordinates($visibleBySubordinates = null)
    {
        // validation for constraint: boolean
        if (!is_null($visibleBySubordinates) && !is_bool($visibleBySubordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visibleBySubordinates, true), gettype($visibleBySubordinates)), __LINE__);
        }
        if (is_null($visibleBySubordinates) || (is_array($visibleBySubordinates) && empty($visibleBySubordinates))) {
            unset($this->VisibleBySubordinates);
        } else {
            $this->VisibleBySubordinates = $visibleBySubordinates;
        }
        return $this;
    }
}
