<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GiftVoucher.CardLoadingExtended StructType
 * @subpackage Structs
 */
class GiftVoucher_CardLoadingExtended extends GiftVoucher_CardLoading
{
    /**
     * The AgencyAccountId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AgencyAccountId;
    /**
     * The AgencyName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AgencyName;
    /**
     * The CommitDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CommitDate;
    /**
     * The OwnerName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OwnerName;
    /**
     * The PurchaserClientId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PurchaserClientId;
    /**
     * The PurchaserName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PurchaserName;
    /**
     * The TransactionLocalId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionLocalId;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionNumber;
    /**
     * Constructor method for GiftVoucher.CardLoadingExtended
     * @uses GiftVoucher_CardLoadingExtended::setAgencyAccountId()
     * @uses GiftVoucher_CardLoadingExtended::setAgencyName()
     * @uses GiftVoucher_CardLoadingExtended::setCommitDate()
     * @uses GiftVoucher_CardLoadingExtended::setOwnerName()
     * @uses GiftVoucher_CardLoadingExtended::setPurchaserClientId()
     * @uses GiftVoucher_CardLoadingExtended::setPurchaserName()
     * @uses GiftVoucher_CardLoadingExtended::setTransactionLocalId()
     * @uses GiftVoucher_CardLoadingExtended::setTransactionNumber()
     * @param string $agencyAccountId
     * @param string $agencyName
     * @param string $commitDate
     * @param string $ownerName
     * @param string $purchaserClientId
     * @param string $purchaserName
     * @param int $transactionLocalId
     * @param int $transactionNumber
     */
    public function __construct($agencyAccountId = null, $agencyName = null, $commitDate = null, $ownerName = null, $purchaserClientId = null, $purchaserName = null, $transactionLocalId = null, $transactionNumber = null)
    {
        $this
            ->setAgencyAccountId($agencyAccountId)
            ->setAgencyName($agencyName)
            ->setCommitDate($commitDate)
            ->setOwnerName($ownerName)
            ->setPurchaserClientId($purchaserClientId)
            ->setPurchaserName($purchaserName)
            ->setTransactionLocalId($transactionLocalId)
            ->setTransactionNumber($transactionNumber);
    }
    /**
     * Get AgencyAccountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAgencyAccountId()
    {
        return isset($this->AgencyAccountId) ? $this->AgencyAccountId : null;
    }
    /**
     * Set AgencyAccountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $agencyAccountId
     * @return \patest\StructType\GiftVoucher_CardLoadingExtended
     */
    public function setAgencyAccountId($agencyAccountId = null)
    {
        // validation for constraint: string
        if (!is_null($agencyAccountId) && !is_string($agencyAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agencyAccountId, true), gettype($agencyAccountId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($agencyAccountId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $agencyAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($agencyAccountId, true)), __LINE__);
        }
        if (is_null($agencyAccountId) || (is_array($agencyAccountId) && empty($agencyAccountId))) {
            unset($this->AgencyAccountId);
        } else {
            $this->AgencyAccountId = $agencyAccountId;
        }
        return $this;
    }
    /**
     * Get AgencyName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAgencyName()
    {
        return isset($this->AgencyName) ? $this->AgencyName : null;
    }
    /**
     * Set AgencyName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $agencyName
     * @return \patest\StructType\GiftVoucher_CardLoadingExtended
     */
    public function setAgencyName($agencyName = null)
    {
        // validation for constraint: string
        if (!is_null($agencyName) && !is_string($agencyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agencyName, true), gettype($agencyName)), __LINE__);
        }
        if (is_null($agencyName) || (is_array($agencyName) && empty($agencyName))) {
            unset($this->AgencyName);
        } else {
            $this->AgencyName = $agencyName;
        }
        return $this;
    }
    /**
     * Get CommitDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCommitDate()
    {
        return isset($this->CommitDate) ? $this->CommitDate : null;
    }
    /**
     * Set CommitDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $commitDate
     * @return \patest\StructType\GiftVoucher_CardLoadingExtended
     */
    public function setCommitDate($commitDate = null)
    {
        // validation for constraint: string
        if (!is_null($commitDate) && !is_string($commitDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commitDate, true), gettype($commitDate)), __LINE__);
        }
        if (is_null($commitDate) || (is_array($commitDate) && empty($commitDate))) {
            unset($this->CommitDate);
        } else {
            $this->CommitDate = $commitDate;
        }
        return $this;
    }
    /**
     * Get OwnerName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerName()
    {
        return isset($this->OwnerName) ? $this->OwnerName : null;
    }
    /**
     * Set OwnerName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerName
     * @return \patest\StructType\GiftVoucher_CardLoadingExtended
     */
    public function setOwnerName($ownerName = null)
    {
        // validation for constraint: string
        if (!is_null($ownerName) && !is_string($ownerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerName, true), gettype($ownerName)), __LINE__);
        }
        if (is_null($ownerName) || (is_array($ownerName) && empty($ownerName))) {
            unset($this->OwnerName);
        } else {
            $this->OwnerName = $ownerName;
        }
        return $this;
    }
    /**
     * Get PurchaserClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPurchaserClientId()
    {
        return isset($this->PurchaserClientId) ? $this->PurchaserClientId : null;
    }
    /**
     * Set PurchaserClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $purchaserClientId
     * @return \patest\StructType\GiftVoucher_CardLoadingExtended
     */
    public function setPurchaserClientId($purchaserClientId = null)
    {
        // validation for constraint: string
        if (!is_null($purchaserClientId) && !is_string($purchaserClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchaserClientId, true), gettype($purchaserClientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($purchaserClientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $purchaserClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($purchaserClientId, true)), __LINE__);
        }
        if (is_null($purchaserClientId) || (is_array($purchaserClientId) && empty($purchaserClientId))) {
            unset($this->PurchaserClientId);
        } else {
            $this->PurchaserClientId = $purchaserClientId;
        }
        return $this;
    }
    /**
     * Get PurchaserName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPurchaserName()
    {
        return isset($this->PurchaserName) ? $this->PurchaserName : null;
    }
    /**
     * Set PurchaserName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $purchaserName
     * @return \patest\StructType\GiftVoucher_CardLoadingExtended
     */
    public function setPurchaserName($purchaserName = null)
    {
        // validation for constraint: string
        if (!is_null($purchaserName) && !is_string($purchaserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchaserName, true), gettype($purchaserName)), __LINE__);
        }
        if (is_null($purchaserName) || (is_array($purchaserName) && empty($purchaserName))) {
            unset($this->PurchaserName);
        } else {
            $this->PurchaserName = $purchaserName;
        }
        return $this;
    }
    /**
     * Get TransactionLocalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionLocalId()
    {
        return isset($this->TransactionLocalId) ? $this->TransactionLocalId : null;
    }
    /**
     * Set TransactionLocalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionLocalId
     * @return \patest\StructType\GiftVoucher_CardLoadingExtended
     */
    public function setTransactionLocalId($transactionLocalId = null)
    {
        // validation for constraint: int
        if (!is_null($transactionLocalId) && !(is_int($transactionLocalId) || ctype_digit($transactionLocalId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionLocalId, true), gettype($transactionLocalId)), __LINE__);
        }
        if (is_null($transactionLocalId) || (is_array($transactionLocalId) && empty($transactionLocalId))) {
            unset($this->TransactionLocalId);
        } else {
            $this->TransactionLocalId = $transactionLocalId;
        }
        return $this;
    }
    /**
     * Get TransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionNumber()
    {
        return isset($this->TransactionNumber) ? $this->TransactionNumber : null;
    }
    /**
     * Set TransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionNumber
     * @return \patest\StructType\GiftVoucher_CardLoadingExtended
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionNumber) && !(is_int($transactionNumber) || ctype_digit($transactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        if (is_null($transactionNumber) || (is_array($transactionNumber) && empty($transactionNumber))) {
            unset($this->TransactionNumber);
        } else {
            $this->TransactionNumber = $transactionNumber;
        }
        return $this;
    }
}
