<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GiftVoucher.AddGiftCardToBasketRequest StructType
 * @subpackage Structs
 */
class GiftVoucher_AddGiftCardToBasketRequest extends AnyEntity
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Amount;
    /**
     * The Balance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Balance;
    /**
     * The CardNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardNumber;
    /**
     * The CardTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CardTypeId;
    /**
     * The DonationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DonationDate;
    /**
     * The LoadingOption
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LoadingOption;
    /**
     * Constructor method for GiftVoucher.AddGiftCardToBasketRequest
     * @uses GiftVoucher_AddGiftCardToBasketRequest::setAmount()
     * @uses GiftVoucher_AddGiftCardToBasketRequest::setBalance()
     * @uses GiftVoucher_AddGiftCardToBasketRequest::setCardNumber()
     * @uses GiftVoucher_AddGiftCardToBasketRequest::setCardTypeId()
     * @uses GiftVoucher_AddGiftCardToBasketRequest::setDonationDate()
     * @uses GiftVoucher_AddGiftCardToBasketRequest::setLoadingOption()
     * @param float $amount
     * @param string $balance
     * @param string $cardNumber
     * @param string $cardTypeId
     * @param string $donationDate
     * @param string $loadingOption
     */
    public function __construct($amount = null, $balance = null, $cardNumber = null, $cardTypeId = null, $donationDate = null, $loadingOption = null)
    {
        $this
            ->setAmount($amount)
            ->setBalance($balance)
            ->setCardNumber($cardNumber)
            ->setCardTypeId($cardTypeId)
            ->setDonationDate($donationDate)
            ->setLoadingOption($loadingOption);
    }
    /**
     * Get Amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAmount()
    {
        return isset($this->Amount) ? $this->Amount : null;
    }
    /**
     * Set Amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $amount
     * @return \patest\StructType\GiftVoucher_AddGiftCardToBasketRequest
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        if (is_null($amount) || (is_array($amount) && empty($amount))) {
            unset($this->Amount);
        } else {
            $this->Amount = $amount;
        }
        return $this;
    }
    /**
     * Get Balance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBalance()
    {
        return isset($this->Balance) ? $this->Balance : null;
    }
    /**
     * Set Balance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $balance
     * @return \patest\StructType\GiftVoucher_AddGiftCardToBasketRequest
     */
    public function setBalance($balance = null)
    {
        // validation for constraint: string
        if (!is_null($balance) && !is_string($balance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($balance, true), gettype($balance)), __LINE__);
        }
        if (is_null($balance) || (is_array($balance) && empty($balance))) {
            unset($this->Balance);
        } else {
            $this->Balance = $balance;
        }
        return $this;
    }
    /**
     * Get CardNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardNumber()
    {
        return isset($this->CardNumber) ? $this->CardNumber : null;
    }
    /**
     * Set CardNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardNumber
     * @return \patest\StructType\GiftVoucher_AddGiftCardToBasketRequest
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumber) && !is_string($cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardNumber, true), gettype($cardNumber)), __LINE__);
        }
        if (is_null($cardNumber) || (is_array($cardNumber) && empty($cardNumber))) {
            unset($this->CardNumber);
        } else {
            $this->CardNumber = $cardNumber;
        }
        return $this;
    }
    /**
     * Get CardTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardTypeId()
    {
        return isset($this->CardTypeId) ? $this->CardTypeId : null;
    }
    /**
     * Set CardTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardTypeId
     * @return \patest\StructType\GiftVoucher_AddGiftCardToBasketRequest
     */
    public function setCardTypeId($cardTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($cardTypeId) && !is_string($cardTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardTypeId, true), gettype($cardTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($cardTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $cardTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($cardTypeId, true)), __LINE__);
        }
        if (is_null($cardTypeId) || (is_array($cardTypeId) && empty($cardTypeId))) {
            unset($this->CardTypeId);
        } else {
            $this->CardTypeId = $cardTypeId;
        }
        return $this;
    }
    /**
     * Get DonationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDonationDate()
    {
        return isset($this->DonationDate) ? $this->DonationDate : null;
    }
    /**
     * Set DonationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $donationDate
     * @return \patest\StructType\GiftVoucher_AddGiftCardToBasketRequest
     */
    public function setDonationDate($donationDate = null)
    {
        // validation for constraint: string
        if (!is_null($donationDate) && !is_string($donationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($donationDate, true), gettype($donationDate)), __LINE__);
        }
        if (is_null($donationDate) || (is_array($donationDate) && empty($donationDate))) {
            unset($this->DonationDate);
        } else {
            $this->DonationDate = $donationDate;
        }
        return $this;
    }
    /**
     * Get LoadingOption value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLoadingOption()
    {
        return isset($this->LoadingOption) ? $this->LoadingOption : null;
    }
    /**
     * Set LoadingOption value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $loadingOption
     * @return \patest\StructType\GiftVoucher_AddGiftCardToBasketRequest
     */
    public function setLoadingOption($loadingOption = null)
    {
        // validation for constraint: string
        if (!is_null($loadingOption) && !is_string($loadingOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loadingOption, true), gettype($loadingOption)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($loadingOption) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $loadingOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($loadingOption, true)), __LINE__);
        }
        if (is_null($loadingOption) || (is_array($loadingOption) && empty($loadingOption))) {
            unset($this->LoadingOption);
        } else {
            $this->LoadingOption = $loadingOption;
        }
        return $this;
    }
}
