<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GiftVoucher.AddCardLoadingToBasketRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GiftVoucher.AddCardLoadingToBasketRequest
 * @subpackage Structs
 */
class GiftVoucher_AddCardLoadingToBasketRequest extends AnyEntity
{
    /**
     * The CardNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardNumber;
    /**
     * The CardProgramId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CardProgramId;
    /**
     * The CardTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CardTypeId;
    /**
     * The ProgramElementId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ProgramElementId;
    /**
     * The RequestedQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $RequestedQuantity;
    /**
     * Constructor method for GiftVoucher.AddCardLoadingToBasketRequest
     * @uses GiftVoucher_AddCardLoadingToBasketRequest::setCardNumber()
     * @uses GiftVoucher_AddCardLoadingToBasketRequest::setCardProgramId()
     * @uses GiftVoucher_AddCardLoadingToBasketRequest::setCardTypeId()
     * @uses GiftVoucher_AddCardLoadingToBasketRequest::setProgramElementId()
     * @uses GiftVoucher_AddCardLoadingToBasketRequest::setRequestedQuantity()
     * @param string $cardNumber
     * @param string $cardProgramId
     * @param string $cardTypeId
     * @param string $programElementId
     * @param float $requestedQuantity
     */
    public function __construct($cardNumber = null, $cardProgramId = null, $cardTypeId = null, $programElementId = null, $requestedQuantity = null)
    {
        $this
            ->setCardNumber($cardNumber)
            ->setCardProgramId($cardProgramId)
            ->setCardTypeId($cardTypeId)
            ->setProgramElementId($programElementId)
            ->setRequestedQuantity($requestedQuantity);
    }
    /**
     * Get CardNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardNumber()
    {
        return isset($this->CardNumber) ? $this->CardNumber : null;
    }
    /**
     * Set CardNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardNumber
     * @return \patest\StructType\GiftVoucher_AddCardLoadingToBasketRequest
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumber) && !is_string($cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardNumber, true), gettype($cardNumber)), __LINE__);
        }
        if (is_null($cardNumber) || (is_array($cardNumber) && empty($cardNumber))) {
            unset($this->CardNumber);
        } else {
            $this->CardNumber = $cardNumber;
        }
        return $this;
    }
    /**
     * Get CardProgramId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardProgramId()
    {
        return isset($this->CardProgramId) ? $this->CardProgramId : null;
    }
    /**
     * Set CardProgramId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardProgramId
     * @return \patest\StructType\GiftVoucher_AddCardLoadingToBasketRequest
     */
    public function setCardProgramId($cardProgramId = null)
    {
        // validation for constraint: string
        if (!is_null($cardProgramId) && !is_string($cardProgramId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardProgramId, true), gettype($cardProgramId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($cardProgramId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $cardProgramId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($cardProgramId, true)), __LINE__);
        }
        if (is_null($cardProgramId) || (is_array($cardProgramId) && empty($cardProgramId))) {
            unset($this->CardProgramId);
        } else {
            $this->CardProgramId = $cardProgramId;
        }
        return $this;
    }
    /**
     * Get CardTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardTypeId()
    {
        return isset($this->CardTypeId) ? $this->CardTypeId : null;
    }
    /**
     * Set CardTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardTypeId
     * @return \patest\StructType\GiftVoucher_AddCardLoadingToBasketRequest
     */
    public function setCardTypeId($cardTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($cardTypeId) && !is_string($cardTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardTypeId, true), gettype($cardTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($cardTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $cardTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($cardTypeId, true)), __LINE__);
        }
        if (is_null($cardTypeId) || (is_array($cardTypeId) && empty($cardTypeId))) {
            unset($this->CardTypeId);
        } else {
            $this->CardTypeId = $cardTypeId;
        }
        return $this;
    }
    /**
     * Get ProgramElementId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProgramElementId()
    {
        return isset($this->ProgramElementId) ? $this->ProgramElementId : null;
    }
    /**
     * Set ProgramElementId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $programElementId
     * @return \patest\StructType\GiftVoucher_AddCardLoadingToBasketRequest
     */
    public function setProgramElementId($programElementId = null)
    {
        // validation for constraint: string
        if (!is_null($programElementId) && !is_string($programElementId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($programElementId, true), gettype($programElementId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($programElementId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $programElementId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($programElementId, true)), __LINE__);
        }
        if (is_null($programElementId) || (is_array($programElementId) && empty($programElementId))) {
            unset($this->ProgramElementId);
        } else {
            $this->ProgramElementId = $programElementId;
        }
        return $this;
    }
    /**
     * Get RequestedQuantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getRequestedQuantity()
    {
        return isset($this->RequestedQuantity) ? $this->RequestedQuantity : null;
    }
    /**
     * Set RequestedQuantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $requestedQuantity
     * @return \patest\StructType\GiftVoucher_AddCardLoadingToBasketRequest
     */
    public function setRequestedQuantity($requestedQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($requestedQuantity) && !(is_float($requestedQuantity) || is_numeric($requestedQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($requestedQuantity, true), gettype($requestedQuantity)), __LINE__);
        }
        if (is_null($requestedQuantity) || (is_array($requestedQuantity) && empty($requestedQuantity))) {
            unset($this->RequestedQuantity);
        } else {
            $this->RequestedQuantity = $requestedQuantity;
        }
        return $this;
    }
}
