<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GiftVoucherProductItem StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GiftVoucherProductItem
 * @subpackage Structs
 */
class GiftVoucherProductItem extends AbstractProductItem
{
    /**
     * The CurrentRedemptionValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $CurrentRedemptionValue;
    /**
     * The CurrentStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CurrentStatus;
    /**
     * The CurrentValidFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrentValidFrom;
    /**
     * The CurrentValidUntil
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrentValidUntil;
    /**
     * The GiftVoucherDefinitionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GiftVoucherDefinitionId;
    /**
     * The GiftVoucherNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GiftVoucherNumber;
    /**
     * The GiftVoucherTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GiftVoucherTypeId;
    /**
     * The IsPrePrinted
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsPrePrinted;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The PricingOption
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PricingOption;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Type;
    /**
     * The EffectiveRedemptionValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $EffectiveRedemptionValue;
    /**
     * The EffectiveStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EffectiveStatus;
    /**
     * Constructor method for GiftVoucherProductItem
     * @uses GiftVoucherProductItem::setCurrentRedemptionValue()
     * @uses GiftVoucherProductItem::setCurrentStatus()
     * @uses GiftVoucherProductItem::setCurrentValidFrom()
     * @uses GiftVoucherProductItem::setCurrentValidUntil()
     * @uses GiftVoucherProductItem::setGiftVoucherDefinitionId()
     * @uses GiftVoucherProductItem::setGiftVoucherNumber()
     * @uses GiftVoucherProductItem::setGiftVoucherTypeId()
     * @uses GiftVoucherProductItem::setIsPrePrinted()
     * @uses GiftVoucherProductItem::setName()
     * @uses GiftVoucherProductItem::setPricingOption()
     * @uses GiftVoucherProductItem::setType()
     * @uses GiftVoucherProductItem::setEffectiveRedemptionValue()
     * @uses GiftVoucherProductItem::setEffectiveStatus()
     * @param float $currentRedemptionValue
     * @param string $currentStatus
     * @param string $currentValidFrom
     * @param string $currentValidUntil
     * @param string $giftVoucherDefinitionId
     * @param string $giftVoucherNumber
     * @param string $giftVoucherTypeId
     * @param bool $isPrePrinted
     * @param string $name
     * @param string $pricingOption
     * @param string $type
     * @param float $effectiveRedemptionValue
     * @param string $effectiveStatus
     */
    public function __construct($currentRedemptionValue = null, $currentStatus = null, $currentValidFrom = null, $currentValidUntil = null, $giftVoucherDefinitionId = null, $giftVoucherNumber = null, $giftVoucherTypeId = null, $isPrePrinted = null, $name = null, $pricingOption = null, $type = null, $effectiveRedemptionValue = null, $effectiveStatus = null)
    {
        $this
            ->setCurrentRedemptionValue($currentRedemptionValue)
            ->setCurrentStatus($currentStatus)
            ->setCurrentValidFrom($currentValidFrom)
            ->setCurrentValidUntil($currentValidUntil)
            ->setGiftVoucherDefinitionId($giftVoucherDefinitionId)
            ->setGiftVoucherNumber($giftVoucherNumber)
            ->setGiftVoucherTypeId($giftVoucherTypeId)
            ->setIsPrePrinted($isPrePrinted)
            ->setName($name)
            ->setPricingOption($pricingOption)
            ->setType($type)
            ->setEffectiveRedemptionValue($effectiveRedemptionValue)
            ->setEffectiveStatus($effectiveStatus);
    }
    /**
     * Get CurrentRedemptionValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCurrentRedemptionValue()
    {
        return isset($this->CurrentRedemptionValue) ? $this->CurrentRedemptionValue : null;
    }
    /**
     * Set CurrentRedemptionValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $currentRedemptionValue
     * @return \patest\StructType\GiftVoucherProductItem
     */
    public function setCurrentRedemptionValue($currentRedemptionValue = null)
    {
        // validation for constraint: float
        if (!is_null($currentRedemptionValue) && !(is_float($currentRedemptionValue) || is_numeric($currentRedemptionValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($currentRedemptionValue, true), gettype($currentRedemptionValue)), __LINE__);
        }
        if (is_null($currentRedemptionValue) || (is_array($currentRedemptionValue) && empty($currentRedemptionValue))) {
            unset($this->CurrentRedemptionValue);
        } else {
            $this->CurrentRedemptionValue = $currentRedemptionValue;
        }
        return $this;
    }
    /**
     * Get CurrentStatus value
     * @return string|null
     */
    public function getCurrentStatus()
    {
        return $this->CurrentStatus;
    }
    /**
     * Set CurrentStatus value
     * @uses \patest\EnumType\GiftVoucherStatus::valueIsValid()
     * @uses \patest\EnumType\GiftVoucherStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $currentStatus
     * @return \patest\StructType\GiftVoucherProductItem
     */
    public function setCurrentStatus($currentStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\GiftVoucherStatus::valueIsValid($currentStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\GiftVoucherStatus', is_array($currentStatus) ? implode(', ', $currentStatus) : var_export($currentStatus, true), implode(', ', \patest\EnumType\GiftVoucherStatus::getValidValues())), __LINE__);
        }
        $this->CurrentStatus = $currentStatus;
        return $this;
    }
    /**
     * Get CurrentValidFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrentValidFrom()
    {
        return isset($this->CurrentValidFrom) ? $this->CurrentValidFrom : null;
    }
    /**
     * Set CurrentValidFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currentValidFrom
     * @return \patest\StructType\GiftVoucherProductItem
     */
    public function setCurrentValidFrom($currentValidFrom = null)
    {
        // validation for constraint: string
        if (!is_null($currentValidFrom) && !is_string($currentValidFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currentValidFrom, true), gettype($currentValidFrom)), __LINE__);
        }
        if (is_null($currentValidFrom) || (is_array($currentValidFrom) && empty($currentValidFrom))) {
            unset($this->CurrentValidFrom);
        } else {
            $this->CurrentValidFrom = $currentValidFrom;
        }
        return $this;
    }
    /**
     * Get CurrentValidUntil value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrentValidUntil()
    {
        return isset($this->CurrentValidUntil) ? $this->CurrentValidUntil : null;
    }
    /**
     * Set CurrentValidUntil value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currentValidUntil
     * @return \patest\StructType\GiftVoucherProductItem
     */
    public function setCurrentValidUntil($currentValidUntil = null)
    {
        // validation for constraint: string
        if (!is_null($currentValidUntil) && !is_string($currentValidUntil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currentValidUntil, true), gettype($currentValidUntil)), __LINE__);
        }
        if (is_null($currentValidUntil) || (is_array($currentValidUntil) && empty($currentValidUntil))) {
            unset($this->CurrentValidUntil);
        } else {
            $this->CurrentValidUntil = $currentValidUntil;
        }
        return $this;
    }
    /**
     * Get GiftVoucherDefinitionId value
     * @return string|null
     */
    public function getGiftVoucherDefinitionId()
    {
        return $this->GiftVoucherDefinitionId;
    }
    /**
     * Set GiftVoucherDefinitionId value
     * @param string $giftVoucherDefinitionId
     * @return \patest\StructType\GiftVoucherProductItem
     */
    public function setGiftVoucherDefinitionId($giftVoucherDefinitionId = null)
    {
        // validation for constraint: string
        if (!is_null($giftVoucherDefinitionId) && !is_string($giftVoucherDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftVoucherDefinitionId, true), gettype($giftVoucherDefinitionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($giftVoucherDefinitionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $giftVoucherDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($giftVoucherDefinitionId, true)), __LINE__);
        }
        $this->GiftVoucherDefinitionId = $giftVoucherDefinitionId;
        return $this;
    }
    /**
     * Get GiftVoucherNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGiftVoucherNumber()
    {
        return isset($this->GiftVoucherNumber) ? $this->GiftVoucherNumber : null;
    }
    /**
     * Set GiftVoucherNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $giftVoucherNumber
     * @return \patest\StructType\GiftVoucherProductItem
     */
    public function setGiftVoucherNumber($giftVoucherNumber = null)
    {
        // validation for constraint: string
        if (!is_null($giftVoucherNumber) && !is_string($giftVoucherNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftVoucherNumber, true), gettype($giftVoucherNumber)), __LINE__);
        }
        if (is_null($giftVoucherNumber) || (is_array($giftVoucherNumber) && empty($giftVoucherNumber))) {
            unset($this->GiftVoucherNumber);
        } else {
            $this->GiftVoucherNumber = $giftVoucherNumber;
        }
        return $this;
    }
    /**
     * Get GiftVoucherTypeId value
     * @return string|null
     */
    public function getGiftVoucherTypeId()
    {
        return $this->GiftVoucherTypeId;
    }
    /**
     * Set GiftVoucherTypeId value
     * @param string $giftVoucherTypeId
     * @return \patest\StructType\GiftVoucherProductItem
     */
    public function setGiftVoucherTypeId($giftVoucherTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($giftVoucherTypeId) && !is_string($giftVoucherTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftVoucherTypeId, true), gettype($giftVoucherTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($giftVoucherTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $giftVoucherTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($giftVoucherTypeId, true)), __LINE__);
        }
        $this->GiftVoucherTypeId = $giftVoucherTypeId;
        return $this;
    }
    /**
     * Get IsPrePrinted value
     * @return bool|null
     */
    public function getIsPrePrinted()
    {
        return $this->IsPrePrinted;
    }
    /**
     * Set IsPrePrinted value
     * @param bool $isPrePrinted
     * @return \patest\StructType\GiftVoucherProductItem
     */
    public function setIsPrePrinted($isPrePrinted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPrePrinted) && !is_bool($isPrePrinted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPrePrinted, true), gettype($isPrePrinted)), __LINE__);
        }
        $this->IsPrePrinted = $isPrePrinted;
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\GiftVoucherProductItem
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get PricingOption value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPricingOption()
    {
        return isset($this->PricingOption) ? $this->PricingOption : null;
    }
    /**
     * Set PricingOption value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PricingOption::valueIsValid()
     * @uses \patest\EnumType\PricingOption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pricingOption
     * @return \patest\StructType\GiftVoucherProductItem
     */
    public function setPricingOption($pricingOption = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PricingOption::valueIsValid($pricingOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PricingOption', is_array($pricingOption) ? implode(', ', $pricingOption) : var_export($pricingOption, true), implode(', ', \patest\EnumType\PricingOption::getValidValues())), __LINE__);
        }
        if (is_null($pricingOption) || (is_array($pricingOption) && empty($pricingOption))) {
            unset($this->PricingOption);
        } else {
            $this->PricingOption = $pricingOption;
        }
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \patest\EnumType\GiftVoucherType::valueIsValid()
     * @uses \patest\EnumType\GiftVoucherType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \patest\StructType\GiftVoucherProductItem
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\GiftVoucherType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\GiftVoucherType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \patest\EnumType\GiftVoucherType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get EffectiveRedemptionValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getEffectiveRedemptionValue()
    {
        return isset($this->EffectiveRedemptionValue) ? $this->EffectiveRedemptionValue : null;
    }
    /**
     * Set EffectiveRedemptionValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $effectiveRedemptionValue
     * @return \patest\StructType\GiftVoucherProductItem
     */
    public function setEffectiveRedemptionValue($effectiveRedemptionValue = null)
    {
        // validation for constraint: float
        if (!is_null($effectiveRedemptionValue) && !(is_float($effectiveRedemptionValue) || is_numeric($effectiveRedemptionValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($effectiveRedemptionValue, true), gettype($effectiveRedemptionValue)), __LINE__);
        }
        if (is_null($effectiveRedemptionValue) || (is_array($effectiveRedemptionValue) && empty($effectiveRedemptionValue))) {
            unset($this->EffectiveRedemptionValue);
        } else {
            $this->EffectiveRedemptionValue = $effectiveRedemptionValue;
        }
        return $this;
    }
    /**
     * Get EffectiveStatus value
     * @return string|null
     */
    public function getEffectiveStatus()
    {
        return $this->EffectiveStatus;
    }
    /**
     * Set EffectiveStatus value
     * @uses \patest\EnumType\GiftVoucherStatus::valueIsValid()
     * @uses \patest\EnumType\GiftVoucherStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $effectiveStatus
     * @return \patest\StructType\GiftVoucherProductItem
     */
    public function setEffectiveStatus($effectiveStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\GiftVoucherStatus::valueIsValid($effectiveStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\GiftVoucherStatus', is_array($effectiveStatus) ? implode(', ', $effectiveStatus) : var_export($effectiveStatus, true), implode(', ', \patest\EnumType\GiftVoucherStatus::getValidValues())), __LINE__);
        }
        $this->EffectiveStatus = $effectiveStatus;
        return $this;
    }
}
