<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GiftVoucherData StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GiftVoucherData
 * @subpackage Structs
 */
class GiftVoucherData extends SearchResultDataChunk
{
    /**
     * The GiftVoucherDefinitionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GiftVoucherDefinitionId;
    /**
     * The GiftVoucherId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GiftVoucherId;
    /**
     * The GiftVoucherItemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GiftVoucherItemId;
    /**
     * The GiftVoucherName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GiftVoucherName;
    /**
     * The GiftVoucherNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GiftVoucherNumber;
    /**
     * The Printed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Printed;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * Constructor method for GiftVoucherData
     * @uses GiftVoucherData::setGiftVoucherDefinitionId()
     * @uses GiftVoucherData::setGiftVoucherId()
     * @uses GiftVoucherData::setGiftVoucherItemId()
     * @uses GiftVoucherData::setGiftVoucherName()
     * @uses GiftVoucherData::setGiftVoucherNumber()
     * @uses GiftVoucherData::setPrinted()
     * @uses GiftVoucherData::setStatus()
     * @uses GiftVoucherData::setTransactionGuid()
     * @param string $giftVoucherDefinitionId
     * @param string $giftVoucherId
     * @param string $giftVoucherItemId
     * @param string $giftVoucherName
     * @param string $giftVoucherNumber
     * @param bool $printed
     * @param string $status
     * @param string $transactionGuid
     */
    public function __construct($giftVoucherDefinitionId = null, $giftVoucherId = null, $giftVoucherItemId = null, $giftVoucherName = null, $giftVoucherNumber = null, $printed = null, $status = null, $transactionGuid = null)
    {
        $this
            ->setGiftVoucherDefinitionId($giftVoucherDefinitionId)
            ->setGiftVoucherId($giftVoucherId)
            ->setGiftVoucherItemId($giftVoucherItemId)
            ->setGiftVoucherName($giftVoucherName)
            ->setGiftVoucherNumber($giftVoucherNumber)
            ->setPrinted($printed)
            ->setStatus($status)
            ->setTransactionGuid($transactionGuid);
    }
    /**
     * Get GiftVoucherDefinitionId value
     * @return string|null
     */
    public function getGiftVoucherDefinitionId()
    {
        return $this->GiftVoucherDefinitionId;
    }
    /**
     * Set GiftVoucherDefinitionId value
     * @param string $giftVoucherDefinitionId
     * @return \patest\StructType\GiftVoucherData
     */
    public function setGiftVoucherDefinitionId($giftVoucherDefinitionId = null)
    {
        // validation for constraint: string
        if (!is_null($giftVoucherDefinitionId) && !is_string($giftVoucherDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftVoucherDefinitionId, true), gettype($giftVoucherDefinitionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($giftVoucherDefinitionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $giftVoucherDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($giftVoucherDefinitionId, true)), __LINE__);
        }
        $this->GiftVoucherDefinitionId = $giftVoucherDefinitionId;
        return $this;
    }
    /**
     * Get GiftVoucherId value
     * @return string|null
     */
    public function getGiftVoucherId()
    {
        return $this->GiftVoucherId;
    }
    /**
     * Set GiftVoucherId value
     * @param string $giftVoucherId
     * @return \patest\StructType\GiftVoucherData
     */
    public function setGiftVoucherId($giftVoucherId = null)
    {
        // validation for constraint: string
        if (!is_null($giftVoucherId) && !is_string($giftVoucherId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftVoucherId, true), gettype($giftVoucherId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($giftVoucherId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $giftVoucherId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($giftVoucherId, true)), __LINE__);
        }
        $this->GiftVoucherId = $giftVoucherId;
        return $this;
    }
    /**
     * Get GiftVoucherItemId value
     * @return string|null
     */
    public function getGiftVoucherItemId()
    {
        return $this->GiftVoucherItemId;
    }
    /**
     * Set GiftVoucherItemId value
     * @param string $giftVoucherItemId
     * @return \patest\StructType\GiftVoucherData
     */
    public function setGiftVoucherItemId($giftVoucherItemId = null)
    {
        // validation for constraint: string
        if (!is_null($giftVoucherItemId) && !is_string($giftVoucherItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftVoucherItemId, true), gettype($giftVoucherItemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($giftVoucherItemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $giftVoucherItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($giftVoucherItemId, true)), __LINE__);
        }
        $this->GiftVoucherItemId = $giftVoucherItemId;
        return $this;
    }
    /**
     * Get GiftVoucherName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGiftVoucherName()
    {
        return isset($this->GiftVoucherName) ? $this->GiftVoucherName : null;
    }
    /**
     * Set GiftVoucherName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $giftVoucherName
     * @return \patest\StructType\GiftVoucherData
     */
    public function setGiftVoucherName($giftVoucherName = null)
    {
        // validation for constraint: string
        if (!is_null($giftVoucherName) && !is_string($giftVoucherName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftVoucherName, true), gettype($giftVoucherName)), __LINE__);
        }
        if (is_null($giftVoucherName) || (is_array($giftVoucherName) && empty($giftVoucherName))) {
            unset($this->GiftVoucherName);
        } else {
            $this->GiftVoucherName = $giftVoucherName;
        }
        return $this;
    }
    /**
     * Get GiftVoucherNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGiftVoucherNumber()
    {
        return isset($this->GiftVoucherNumber) ? $this->GiftVoucherNumber : null;
    }
    /**
     * Set GiftVoucherNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $giftVoucherNumber
     * @return \patest\StructType\GiftVoucherData
     */
    public function setGiftVoucherNumber($giftVoucherNumber = null)
    {
        // validation for constraint: string
        if (!is_null($giftVoucherNumber) && !is_string($giftVoucherNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftVoucherNumber, true), gettype($giftVoucherNumber)), __LINE__);
        }
        if (is_null($giftVoucherNumber) || (is_array($giftVoucherNumber) && empty($giftVoucherNumber))) {
            unset($this->GiftVoucherNumber);
        } else {
            $this->GiftVoucherNumber = $giftVoucherNumber;
        }
        return $this;
    }
    /**
     * Get Printed value
     * @return bool|null
     */
    public function getPrinted()
    {
        return $this->Printed;
    }
    /**
     * Set Printed value
     * @param bool $printed
     * @return \patest\StructType\GiftVoucherData
     */
    public function setPrinted($printed = null)
    {
        // validation for constraint: boolean
        if (!is_null($printed) && !is_bool($printed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($printed, true), gettype($printed)), __LINE__);
        }
        $this->Printed = $printed;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \patest\EnumType\GiftVoucherStatus::valueIsValid()
     * @uses \patest\EnumType\GiftVoucherStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \patest\StructType\GiftVoucherData
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\GiftVoucherStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\GiftVoucherStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \patest\EnumType\GiftVoucherStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get TransactionGuid value
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return $this->TransactionGuid;
    }
    /**
     * Set TransactionGuid value
     * @param string $transactionGuid
     * @return \patest\StructType\GiftVoucherData
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        $this->TransactionGuid = $transactionGuid;
        return $this;
    }
}
