<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GiftCardDetail StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GiftCardDetail
 * @subpackage Structs
 */
class GiftCardDetail extends AbstractStructBase
{
    /**
     * The AuthorizationCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AuthorizationCode;
    /**
     * The Balance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Balance;
    /**
     * The CardNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardNumber;
    /**
     * The CardProgramId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CardProgramId;
    /**
     * The CardTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CardTypeId;
    /**
     * The ProgramKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProgramKey;
    /**
     * Constructor method for GiftCardDetail
     * @uses GiftCardDetail::setAuthorizationCode()
     * @uses GiftCardDetail::setBalance()
     * @uses GiftCardDetail::setCardNumber()
     * @uses GiftCardDetail::setCardProgramId()
     * @uses GiftCardDetail::setCardTypeId()
     * @uses GiftCardDetail::setProgramKey()
     * @param string $authorizationCode
     * @param float $balance
     * @param string $cardNumber
     * @param string $cardProgramId
     * @param string $cardTypeId
     * @param string $programKey
     */
    public function __construct($authorizationCode = null, $balance = null, $cardNumber = null, $cardProgramId = null, $cardTypeId = null, $programKey = null)
    {
        $this
            ->setAuthorizationCode($authorizationCode)
            ->setBalance($balance)
            ->setCardNumber($cardNumber)
            ->setCardProgramId($cardProgramId)
            ->setCardTypeId($cardTypeId)
            ->setProgramKey($programKey);
    }
    /**
     * Get AuthorizationCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuthorizationCode()
    {
        return isset($this->AuthorizationCode) ? $this->AuthorizationCode : null;
    }
    /**
     * Set AuthorizationCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $authorizationCode
     * @return \patest\StructType\GiftCardDetail
     */
    public function setAuthorizationCode($authorizationCode = null)
    {
        // validation for constraint: string
        if (!is_null($authorizationCode) && !is_string($authorizationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authorizationCode, true), gettype($authorizationCode)), __LINE__);
        }
        if (is_null($authorizationCode) || (is_array($authorizationCode) && empty($authorizationCode))) {
            unset($this->AuthorizationCode);
        } else {
            $this->AuthorizationCode = $authorizationCode;
        }
        return $this;
    }
    /**
     * Get Balance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getBalance()
    {
        return isset($this->Balance) ? $this->Balance : null;
    }
    /**
     * Set Balance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $balance
     * @return \patest\StructType\GiftCardDetail
     */
    public function setBalance($balance = null)
    {
        // validation for constraint: float
        if (!is_null($balance) && !(is_float($balance) || is_numeric($balance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($balance, true), gettype($balance)), __LINE__);
        }
        if (is_null($balance) || (is_array($balance) && empty($balance))) {
            unset($this->Balance);
        } else {
            $this->Balance = $balance;
        }
        return $this;
    }
    /**
     * Get CardNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardNumber()
    {
        return isset($this->CardNumber) ? $this->CardNumber : null;
    }
    /**
     * Set CardNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardNumber
     * @return \patest\StructType\GiftCardDetail
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumber) && !is_string($cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardNumber, true), gettype($cardNumber)), __LINE__);
        }
        if (is_null($cardNumber) || (is_array($cardNumber) && empty($cardNumber))) {
            unset($this->CardNumber);
        } else {
            $this->CardNumber = $cardNumber;
        }
        return $this;
    }
    /**
     * Get CardProgramId value
     * @return string|null
     */
    public function getCardProgramId()
    {
        return $this->CardProgramId;
    }
    /**
     * Set CardProgramId value
     * @param string $cardProgramId
     * @return \patest\StructType\GiftCardDetail
     */
    public function setCardProgramId($cardProgramId = null)
    {
        // validation for constraint: string
        if (!is_null($cardProgramId) && !is_string($cardProgramId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardProgramId, true), gettype($cardProgramId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($cardProgramId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $cardProgramId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($cardProgramId, true)), __LINE__);
        }
        $this->CardProgramId = $cardProgramId;
        return $this;
    }
    /**
     * Get CardTypeId value
     * @return string|null
     */
    public function getCardTypeId()
    {
        return $this->CardTypeId;
    }
    /**
     * Set CardTypeId value
     * @param string $cardTypeId
     * @return \patest\StructType\GiftCardDetail
     */
    public function setCardTypeId($cardTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($cardTypeId) && !is_string($cardTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardTypeId, true), gettype($cardTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($cardTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $cardTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($cardTypeId, true)), __LINE__);
        }
        $this->CardTypeId = $cardTypeId;
        return $this;
    }
    /**
     * Get ProgramKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProgramKey()
    {
        return isset($this->ProgramKey) ? $this->ProgramKey : null;
    }
    /**
     * Set ProgramKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $programKey
     * @return \patest\StructType\GiftCardDetail
     */
    public function setProgramKey($programKey = null)
    {
        // validation for constraint: string
        if (!is_null($programKey) && !is_string($programKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($programKey, true), gettype($programKey)), __LINE__);
        }
        if (is_null($programKey) || (is_array($programKey) && empty($programKey))) {
            unset($this->ProgramKey);
        } else {
            $this->ProgramKey = $programKey;
        }
        return $this;
    }
}
