<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetUserApplicationPreferenceRequest-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetUserApplicationPreferenceRequest-Request
 * @subpackage Structs
 */
class GetUserApplicationPreferenceRequest_Request extends ExtensibleDataContract
{
    /**
     * The Application
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Application;
    /**
     * The Key
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Key;
    /**
     * Constructor method for GetUserApplicationPreferenceRequest-Request
     * @uses GetUserApplicationPreferenceRequest_Request::setApplication()
     * @uses GetUserApplicationPreferenceRequest_Request::setKey()
     * @param string $application
     * @param string $key
     */
    public function __construct($application = null, $key = null)
    {
        $this
            ->setApplication($application)
            ->setKey($key);
    }
    /**
     * Get Application value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplication()
    {
        return isset($this->Application) ? $this->Application : null;
    }
    /**
     * Set Application value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $application
     * @return \patest\StructType\GetUserApplicationPreferenceRequest_Request
     */
    public function setApplication($application = null)
    {
        // validation for constraint: string
        if (!is_null($application) && !is_string($application)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($application, true), gettype($application)), __LINE__);
        }
        if (is_null($application) || (is_array($application) && empty($application))) {
            unset($this->Application);
        } else {
            $this->Application = $application;
        }
        return $this;
    }
    /**
     * Get Key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKey()
    {
        return isset($this->Key) ? $this->Key : null;
    }
    /**
     * Set Key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $key
     * @return \patest\StructType\GetUserApplicationPreferenceRequest_Request
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($key, true), gettype($key)), __LINE__);
        }
        if (is_null($key) || (is_array($key) && empty($key))) {
            unset($this->Key);
        } else {
            $this->Key = $key;
        }
        return $this;
    }
}
