<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetUppConfigurationResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetUppConfigurationResponse
 * @subpackage Structs
 */
class GetUppConfigurationResponse extends AbstractStructBase
{
    /**
     * The AD_ApiKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AD_ApiKey;
    /**
     * The AD_ClientKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AD_ClientKey;
    /**
     * The AD_LivePrefix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AD_LivePrefix;
    /**
     * The AD_MerchantAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AD_MerchantAccount;
    /**
     * The AD_PrefixForPaymentReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AD_PrefixForPaymentReference;
    /**
     * The AD_Username
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AD_Username;
    /**
     * The AlternatedPaymentTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AlternatedPaymentTypes;
    /**
     * The AvsMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AvsMode;
    /**
     * The CYS_Key
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CYS_Key;
    /**
     * The CYS_Organization
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CYS_Organization;
    /**
     * The CcNumberFormat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CcNumberFormat;
    /**
     * The CvvMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CvvMode;
    /**
     * The DefaultCountryCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DefaultCountryCode;
    /**
     * The DisplayEmail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DisplayEmail;
    /**
     * The DisplayPhoneNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DisplayPhoneNumber;
    /**
     * The EnablePayByLink
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $EnablePayByLink;
    /**
     * The IsMoto
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsMoto;
    /**
     * The IsTest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsTest;
    /**
     * The PayPal_MerchantId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PayPal_MerchantId;
    /**
     * The PayPal_NotificationEndpoint
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PayPal_NotificationEndpoint;
    /**
     * The PayPal_PayLaterEnabled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $PayPal_PayLaterEnabled;
    /**
     * The PayPal_PrivateKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PayPal_PrivateKey;
    /**
     * The PayPal_PublicKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PayPal_PublicKey;
    /**
     * The PaymentType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PaymentType;
    /**
     * The S4_ClientGuid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $S4_ClientGuid;
    /**
     * The ST_ConnectAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ST_ConnectAccount;
    /**
     * The ST_IntegrationMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ST_IntegrationMode;
    /**
     * The Scenario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Scenario;
    /**
     * The WP_ApiId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WP_ApiId;
    /**
     * The WP_ApiKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WP_ApiKey;
    /**
     * The WP_Login
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WP_Login;
    /**
     * The WP_NotificationEndpoint
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WP_NotificationEndpoint;
    /**
     * The WP_OrgUnitId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WP_OrgUnitId;
    /**
     * The WP_Recurring_Login
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WP_Recurring_Login;
    /**
     * Constructor method for GetUppConfigurationResponse
     * @uses GetUppConfigurationResponse::setAD_ApiKey()
     * @uses GetUppConfigurationResponse::setAD_ClientKey()
     * @uses GetUppConfigurationResponse::setAD_LivePrefix()
     * @uses GetUppConfigurationResponse::setAD_MerchantAccount()
     * @uses GetUppConfigurationResponse::setAD_PrefixForPaymentReference()
     * @uses GetUppConfigurationResponse::setAD_Username()
     * @uses GetUppConfigurationResponse::setAlternatedPaymentTypes()
     * @uses GetUppConfigurationResponse::setAvsMode()
     * @uses GetUppConfigurationResponse::setCYS_Key()
     * @uses GetUppConfigurationResponse::setCYS_Organization()
     * @uses GetUppConfigurationResponse::setCcNumberFormat()
     * @uses GetUppConfigurationResponse::setCvvMode()
     * @uses GetUppConfigurationResponse::setDefaultCountryCode()
     * @uses GetUppConfigurationResponse::setDisplayEmail()
     * @uses GetUppConfigurationResponse::setDisplayPhoneNumber()
     * @uses GetUppConfigurationResponse::setEnablePayByLink()
     * @uses GetUppConfigurationResponse::setIsMoto()
     * @uses GetUppConfigurationResponse::setIsTest()
     * @uses GetUppConfigurationResponse::setPayPal_MerchantId()
     * @uses GetUppConfigurationResponse::setPayPal_NotificationEndpoint()
     * @uses GetUppConfigurationResponse::setPayPal_PayLaterEnabled()
     * @uses GetUppConfigurationResponse::setPayPal_PrivateKey()
     * @uses GetUppConfigurationResponse::setPayPal_PublicKey()
     * @uses GetUppConfigurationResponse::setPaymentType()
     * @uses GetUppConfigurationResponse::setS4_ClientGuid()
     * @uses GetUppConfigurationResponse::setST_ConnectAccount()
     * @uses GetUppConfigurationResponse::setST_IntegrationMode()
     * @uses GetUppConfigurationResponse::setScenario()
     * @uses GetUppConfigurationResponse::setWP_ApiId()
     * @uses GetUppConfigurationResponse::setWP_ApiKey()
     * @uses GetUppConfigurationResponse::setWP_Login()
     * @uses GetUppConfigurationResponse::setWP_NotificationEndpoint()
     * @uses GetUppConfigurationResponse::setWP_OrgUnitId()
     * @uses GetUppConfigurationResponse::setWP_Recurring_Login()
     * @param string $aD_ApiKey
     * @param string $aD_ClientKey
     * @param string $aD_LivePrefix
     * @param string $aD_MerchantAccount
     * @param string $aD_PrefixForPaymentReference
     * @param string $aD_Username
     * @param string $alternatedPaymentTypes
     * @param string $avsMode
     * @param string $cYS_Key
     * @param string $cYS_Organization
     * @param string $ccNumberFormat
     * @param string $cvvMode
     * @param string $defaultCountryCode
     * @param bool $displayEmail
     * @param bool $displayPhoneNumber
     * @param bool $enablePayByLink
     * @param bool $isMoto
     * @param bool $isTest
     * @param string $payPal_MerchantId
     * @param string $payPal_NotificationEndpoint
     * @param bool $payPal_PayLaterEnabled
     * @param string $payPal_PrivateKey
     * @param string $payPal_PublicKey
     * @param string $paymentType
     * @param string $s4_ClientGuid
     * @param string $sT_ConnectAccount
     * @param string $sT_IntegrationMode
     * @param string $scenario
     * @param string $wP_ApiId
     * @param string $wP_ApiKey
     * @param string $wP_Login
     * @param string $wP_NotificationEndpoint
     * @param string $wP_OrgUnitId
     * @param string $wP_Recurring_Login
     */
    public function __construct($aD_ApiKey = null, $aD_ClientKey = null, $aD_LivePrefix = null, $aD_MerchantAccount = null, $aD_PrefixForPaymentReference = null, $aD_Username = null, $alternatedPaymentTypes = null, $avsMode = null, $cYS_Key = null, $cYS_Organization = null, $ccNumberFormat = null, $cvvMode = null, $defaultCountryCode = null, $displayEmail = null, $displayPhoneNumber = null, $enablePayByLink = null, $isMoto = null, $isTest = null, $payPal_MerchantId = null, $payPal_NotificationEndpoint = null, $payPal_PayLaterEnabled = null, $payPal_PrivateKey = null, $payPal_PublicKey = null, $paymentType = null, $s4_ClientGuid = null, $sT_ConnectAccount = null, $sT_IntegrationMode = null, $scenario = null, $wP_ApiId = null, $wP_ApiKey = null, $wP_Login = null, $wP_NotificationEndpoint = null, $wP_OrgUnitId = null, $wP_Recurring_Login = null)
    {
        $this
            ->setAD_ApiKey($aD_ApiKey)
            ->setAD_ClientKey($aD_ClientKey)
            ->setAD_LivePrefix($aD_LivePrefix)
            ->setAD_MerchantAccount($aD_MerchantAccount)
            ->setAD_PrefixForPaymentReference($aD_PrefixForPaymentReference)
            ->setAD_Username($aD_Username)
            ->setAlternatedPaymentTypes($alternatedPaymentTypes)
            ->setAvsMode($avsMode)
            ->setCYS_Key($cYS_Key)
            ->setCYS_Organization($cYS_Organization)
            ->setCcNumberFormat($ccNumberFormat)
            ->setCvvMode($cvvMode)
            ->setDefaultCountryCode($defaultCountryCode)
            ->setDisplayEmail($displayEmail)
            ->setDisplayPhoneNumber($displayPhoneNumber)
            ->setEnablePayByLink($enablePayByLink)
            ->setIsMoto($isMoto)
            ->setIsTest($isTest)
            ->setPayPal_MerchantId($payPal_MerchantId)
            ->setPayPal_NotificationEndpoint($payPal_NotificationEndpoint)
            ->setPayPal_PayLaterEnabled($payPal_PayLaterEnabled)
            ->setPayPal_PrivateKey($payPal_PrivateKey)
            ->setPayPal_PublicKey($payPal_PublicKey)
            ->setPaymentType($paymentType)
            ->setS4_ClientGuid($s4_ClientGuid)
            ->setST_ConnectAccount($sT_ConnectAccount)
            ->setST_IntegrationMode($sT_IntegrationMode)
            ->setScenario($scenario)
            ->setWP_ApiId($wP_ApiId)
            ->setWP_ApiKey($wP_ApiKey)
            ->setWP_Login($wP_Login)
            ->setWP_NotificationEndpoint($wP_NotificationEndpoint)
            ->setWP_OrgUnitId($wP_OrgUnitId)
            ->setWP_Recurring_Login($wP_Recurring_Login);
    }
    /**
     * Get AD_ApiKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAD_ApiKey()
    {
        return isset($this->AD_ApiKey) ? $this->AD_ApiKey : null;
    }
    /**
     * Set AD_ApiKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aD_ApiKey
     * @return \patest\StructType\GetUppConfigurationResponse
     */
    public function setAD_ApiKey($aD_ApiKey = null)
    {
        // validation for constraint: string
        if (!is_null($aD_ApiKey) && !is_string($aD_ApiKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aD_ApiKey, true), gettype($aD_ApiKey)), __LINE__);
        }
        if (is_null($aD_ApiKey) || (is_array($aD_ApiKey) && empty($aD_ApiKey))) {
            unset($this->AD_ApiKey);
        } else {
            $this->AD_ApiKey = $aD_ApiKey;
        }
        return $this;
    }
    /**
     * Get AD_ClientKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAD_ClientKey()
    {
        return isset($this->AD_ClientKey) ? $this->AD_ClientKey : null;
    }
    /**
     * Set AD_ClientKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aD_ClientKey
     * @return \patest\StructType\GetUppConfigurationResponse
     */
    public function setAD_ClientKey($aD_ClientKey = null)
    {
        // validation for constraint: string
        if (!is_null($aD_ClientKey) && !is_string($aD_ClientKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aD_ClientKey, true), gettype($aD_ClientKey)), __LINE__);
        }
        if (is_null($aD_ClientKey) || (is_array($aD_ClientKey) && empty($aD_ClientKey))) {
            unset($this->AD_ClientKey);
        } else {
            $this->AD_ClientKey = $aD_ClientKey;
        }
        return $this;
    }
    /**
     * Get AD_LivePrefix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAD_LivePrefix()
    {
        return isset($this->AD_LivePrefix) ? $this->AD_LivePrefix : null;
    }
    /**
     * Set AD_LivePrefix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aD_LivePrefix
     * @return \patest\StructType\GetUppConfigurationResponse
     */
    public function setAD_LivePrefix($aD_LivePrefix = null)
    {
        // validation for constraint: string
        if (!is_null($aD_LivePrefix) && !is_string($aD_LivePrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aD_LivePrefix, true), gettype($aD_LivePrefix)), __LINE__);
        }
        if (is_null($aD_LivePrefix) || (is_array($aD_LivePrefix) && empty($aD_LivePrefix))) {
            unset($this->AD_LivePrefix);
        } else {
            $this->AD_LivePrefix = $aD_LivePrefix;
        }
        return $this;
    }
    /**
     * Get AD_MerchantAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAD_MerchantAccount()
    {
        return isset($this->AD_MerchantAccount) ? $this->AD_MerchantAccount : null;
    }
    /**
     * Set AD_MerchantAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aD_MerchantAccount
     * @return \patest\StructType\GetUppConfigurationResponse
     */
    public function setAD_MerchantAccount($aD_MerchantAccount = null)
    {
        // validation for constraint: string
        if (!is_null($aD_MerchantAccount) && !is_string($aD_MerchantAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aD_MerchantAccount, true), gettype($aD_MerchantAccount)), __LINE__);
        }
        if (is_null($aD_MerchantAccount) || (is_array($aD_MerchantAccount) && empty($aD_MerchantAccount))) {
            unset($this->AD_MerchantAccount);
        } else {
            $this->AD_MerchantAccount = $aD_MerchantAccount;
        }
        return $this;
    }
    /**
     * Get AD_PrefixForPaymentReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAD_PrefixForPaymentReference()
    {
        return isset($this->AD_PrefixForPaymentReference) ? $this->AD_PrefixForPaymentReference : null;
    }
    /**
     * Set AD_PrefixForPaymentReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aD_PrefixForPaymentReference
     * @return \patest\StructType\GetUppConfigurationResponse
     */
    public function setAD_PrefixForPaymentReference($aD_PrefixForPaymentReference = null)
    {
        // validation for constraint: string
        if (!is_null($aD_PrefixForPaymentReference) && !is_string($aD_PrefixForPaymentReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aD_PrefixForPaymentReference, true), gettype($aD_PrefixForPaymentReference)), __LINE__);
        }
        if (is_null($aD_PrefixForPaymentReference) || (is_array($aD_PrefixForPaymentReference) && empty($aD_PrefixForPaymentReference))) {
            unset($this->AD_PrefixForPaymentReference);
        } else {
            $this->AD_PrefixForPaymentReference = $aD_PrefixForPaymentReference;
        }
        return $this;
    }
    /**
     * Get AD_Username value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAD_Username()
    {
        return isset($this->AD_Username) ? $this->AD_Username : null;
    }
    /**
     * Set AD_Username value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aD_Username
     * @return \patest\StructType\GetUppConfigurationResponse
     */
    public function setAD_Username($aD_Username = null)
    {
        // validation for constraint: string
        if (!is_null($aD_Username) && !is_string($aD_Username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aD_Username, true), gettype($aD_Username)), __LINE__);
        }
        if (is_null($aD_Username) || (is_array($aD_Username) && empty($aD_Username))) {
            unset($this->AD_Username);
        } else {
            $this->AD_Username = $aD_Username;
        }
        return $this;
    }
    /**
     * Get AlternatedPaymentTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAlternatedPaymentTypes()
    {
        return isset($this->AlternatedPaymentTypes) ? $this->AlternatedPaymentTypes : null;
    }
    /**
     * Set AlternatedPaymentTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $alternatedPaymentTypes
     * @return \patest\StructType\GetUppConfigurationResponse
     */
    public function setAlternatedPaymentTypes($alternatedPaymentTypes = null)
    {
        // validation for constraint: string
        if (!is_null($alternatedPaymentTypes) && !is_string($alternatedPaymentTypes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alternatedPaymentTypes, true), gettype($alternatedPaymentTypes)), __LINE__);
        }
        if (is_null($alternatedPaymentTypes) || (is_array($alternatedPaymentTypes) && empty($alternatedPaymentTypes))) {
            unset($this->AlternatedPaymentTypes);
        } else {
            $this->AlternatedPaymentTypes = $alternatedPaymentTypes;
        }
        return $this;
    }
    /**
     * Get AvsMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAvsMode()
    {
        return isset($this->AvsMode) ? $this->AvsMode : null;
    }
    /**
     * Set AvsMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\AvsMode::valueIsValid()
     * @uses \patest\EnumType\AvsMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $avsMode
     * @return \patest\StructType\GetUppConfigurationResponse
     */
    public function setAvsMode($avsMode = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\AvsMode::valueIsValid($avsMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\AvsMode', is_array($avsMode) ? implode(', ', $avsMode) : var_export($avsMode, true), implode(', ', \patest\EnumType\AvsMode::getValidValues())), __LINE__);
        }
        if (is_null($avsMode) || (is_array($avsMode) && empty($avsMode))) {
            unset($this->AvsMode);
        } else {
            $this->AvsMode = $avsMode;
        }
        return $this;
    }
    /**
     * Get CYS_Key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCYS_Key()
    {
        return isset($this->CYS_Key) ? $this->CYS_Key : null;
    }
    /**
     * Set CYS_Key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cYS_Key
     * @return \patest\StructType\GetUppConfigurationResponse
     */
    public function setCYS_Key($cYS_Key = null)
    {
        // validation for constraint: string
        if (!is_null($cYS_Key) && !is_string($cYS_Key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cYS_Key, true), gettype($cYS_Key)), __LINE__);
        }
        if (is_null($cYS_Key) || (is_array($cYS_Key) && empty($cYS_Key))) {
            unset($this->CYS_Key);
        } else {
            $this->CYS_Key = $cYS_Key;
        }
        return $this;
    }
    /**
     * Get CYS_Organization value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCYS_Organization()
    {
        return isset($this->CYS_Organization) ? $this->CYS_Organization : null;
    }
    /**
     * Set CYS_Organization value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cYS_Organization
     * @return \patest\StructType\GetUppConfigurationResponse
     */
    public function setCYS_Organization($cYS_Organization = null)
    {
        // validation for constraint: string
        if (!is_null($cYS_Organization) && !is_string($cYS_Organization)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cYS_Organization, true), gettype($cYS_Organization)), __LINE__);
        }
        if (is_null($cYS_Organization) || (is_array($cYS_Organization) && empty($cYS_Organization))) {
            unset($this->CYS_Organization);
        } else {
            $this->CYS_Organization = $cYS_Organization;
        }
        return $this;
    }
    /**
     * Get CcNumberFormat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCcNumberFormat()
    {
        return isset($this->CcNumberFormat) ? $this->CcNumberFormat : null;
    }
    /**
     * Set CcNumberFormat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ccNumberFormat
     * @return \patest\StructType\GetUppConfigurationResponse
     */
    public function setCcNumberFormat($ccNumberFormat = null)
    {
        // validation for constraint: string
        if (!is_null($ccNumberFormat) && !is_string($ccNumberFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ccNumberFormat, true), gettype($ccNumberFormat)), __LINE__);
        }
        if (is_null($ccNumberFormat) || (is_array($ccNumberFormat) && empty($ccNumberFormat))) {
            unset($this->CcNumberFormat);
        } else {
            $this->CcNumberFormat = $ccNumberFormat;
        }
        return $this;
    }
    /**
     * Get CvvMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCvvMode()
    {
        return isset($this->CvvMode) ? $this->CvvMode : null;
    }
    /**
     * Set CvvMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\CvvMode::valueIsValid()
     * @uses \patest\EnumType\CvvMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cvvMode
     * @return \patest\StructType\GetUppConfigurationResponse
     */
    public function setCvvMode($cvvMode = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\CvvMode::valueIsValid($cvvMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\CvvMode', is_array($cvvMode) ? implode(', ', $cvvMode) : var_export($cvvMode, true), implode(', ', \patest\EnumType\CvvMode::getValidValues())), __LINE__);
        }
        if (is_null($cvvMode) || (is_array($cvvMode) && empty($cvvMode))) {
            unset($this->CvvMode);
        } else {
            $this->CvvMode = $cvvMode;
        }
        return $this;
    }
    /**
     * Get DefaultCountryCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultCountryCode()
    {
        return isset($this->DefaultCountryCode) ? $this->DefaultCountryCode : null;
    }
    /**
     * Set DefaultCountryCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $defaultCountryCode
     * @return \patest\StructType\GetUppConfigurationResponse
     */
    public function setDefaultCountryCode($defaultCountryCode = null)
    {
        // validation for constraint: string
        if (!is_null($defaultCountryCode) && !is_string($defaultCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultCountryCode, true), gettype($defaultCountryCode)), __LINE__);
        }
        if (is_null($defaultCountryCode) || (is_array($defaultCountryCode) && empty($defaultCountryCode))) {
            unset($this->DefaultCountryCode);
        } else {
            $this->DefaultCountryCode = $defaultCountryCode;
        }
        return $this;
    }
    /**
     * Get DisplayEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDisplayEmail()
    {
        return isset($this->DisplayEmail) ? $this->DisplayEmail : null;
    }
    /**
     * Set DisplayEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $displayEmail
     * @return \patest\StructType\GetUppConfigurationResponse
     */
    public function setDisplayEmail($displayEmail = null)
    {
        // validation for constraint: boolean
        if (!is_null($displayEmail) && !is_bool($displayEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($displayEmail, true), gettype($displayEmail)), __LINE__);
        }
        if (is_null($displayEmail) || (is_array($displayEmail) && empty($displayEmail))) {
            unset($this->DisplayEmail);
        } else {
            $this->DisplayEmail = $displayEmail;
        }
        return $this;
    }
    /**
     * Get DisplayPhoneNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDisplayPhoneNumber()
    {
        return isset($this->DisplayPhoneNumber) ? $this->DisplayPhoneNumber : null;
    }
    /**
     * Set DisplayPhoneNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $displayPhoneNumber
     * @return \patest\StructType\GetUppConfigurationResponse
     */
    public function setDisplayPhoneNumber($displayPhoneNumber = null)
    {
        // validation for constraint: boolean
        if (!is_null($displayPhoneNumber) && !is_bool($displayPhoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($displayPhoneNumber, true), gettype($displayPhoneNumber)), __LINE__);
        }
        if (is_null($displayPhoneNumber) || (is_array($displayPhoneNumber) && empty($displayPhoneNumber))) {
            unset($this->DisplayPhoneNumber);
        } else {
            $this->DisplayPhoneNumber = $displayPhoneNumber;
        }
        return $this;
    }
    /**
     * Get EnablePayByLink value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getEnablePayByLink()
    {
        return isset($this->EnablePayByLink) ? $this->EnablePayByLink : null;
    }
    /**
     * Set EnablePayByLink value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $enablePayByLink
     * @return \patest\StructType\GetUppConfigurationResponse
     */
    public function setEnablePayByLink($enablePayByLink = null)
    {
        // validation for constraint: boolean
        if (!is_null($enablePayByLink) && !is_bool($enablePayByLink)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enablePayByLink, true), gettype($enablePayByLink)), __LINE__);
        }
        if (is_null($enablePayByLink) || (is_array($enablePayByLink) && empty($enablePayByLink))) {
            unset($this->EnablePayByLink);
        } else {
            $this->EnablePayByLink = $enablePayByLink;
        }
        return $this;
    }
    /**
     * Get IsMoto value
     * @return bool|null
     */
    public function getIsMoto()
    {
        return $this->IsMoto;
    }
    /**
     * Set IsMoto value
     * @param bool $isMoto
     * @return \patest\StructType\GetUppConfigurationResponse
     */
    public function setIsMoto($isMoto = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMoto) && !is_bool($isMoto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isMoto, true), gettype($isMoto)), __LINE__);
        }
        $this->IsMoto = $isMoto;
        return $this;
    }
    /**
     * Get IsTest value
     * @return bool|null
     */
    public function getIsTest()
    {
        return $this->IsTest;
    }
    /**
     * Set IsTest value
     * @param bool $isTest
     * @return \patest\StructType\GetUppConfigurationResponse
     */
    public function setIsTest($isTest = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTest) && !is_bool($isTest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTest, true), gettype($isTest)), __LINE__);
        }
        $this->IsTest = $isTest;
        return $this;
    }
    /**
     * Get PayPal_MerchantId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayPal_MerchantId()
    {
        return isset($this->PayPal_MerchantId) ? $this->PayPal_MerchantId : null;
    }
    /**
     * Set PayPal_MerchantId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payPal_MerchantId
     * @return \patest\StructType\GetUppConfigurationResponse
     */
    public function setPayPal_MerchantId($payPal_MerchantId = null)
    {
        // validation for constraint: string
        if (!is_null($payPal_MerchantId) && !is_string($payPal_MerchantId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payPal_MerchantId, true), gettype($payPal_MerchantId)), __LINE__);
        }
        if (is_null($payPal_MerchantId) || (is_array($payPal_MerchantId) && empty($payPal_MerchantId))) {
            unset($this->PayPal_MerchantId);
        } else {
            $this->PayPal_MerchantId = $payPal_MerchantId;
        }
        return $this;
    }
    /**
     * Get PayPal_NotificationEndpoint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayPal_NotificationEndpoint()
    {
        return isset($this->PayPal_NotificationEndpoint) ? $this->PayPal_NotificationEndpoint : null;
    }
    /**
     * Set PayPal_NotificationEndpoint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payPal_NotificationEndpoint
     * @return \patest\StructType\GetUppConfigurationResponse
     */
    public function setPayPal_NotificationEndpoint($payPal_NotificationEndpoint = null)
    {
        // validation for constraint: string
        if (!is_null($payPal_NotificationEndpoint) && !is_string($payPal_NotificationEndpoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payPal_NotificationEndpoint, true), gettype($payPal_NotificationEndpoint)), __LINE__);
        }
        if (is_null($payPal_NotificationEndpoint) || (is_array($payPal_NotificationEndpoint) && empty($payPal_NotificationEndpoint))) {
            unset($this->PayPal_NotificationEndpoint);
        } else {
            $this->PayPal_NotificationEndpoint = $payPal_NotificationEndpoint;
        }
        return $this;
    }
    /**
     * Get PayPal_PayLaterEnabled value
     * @return bool|null
     */
    public function getPayPal_PayLaterEnabled()
    {
        return $this->PayPal_PayLaterEnabled;
    }
    /**
     * Set PayPal_PayLaterEnabled value
     * @param bool $payPal_PayLaterEnabled
     * @return \patest\StructType\GetUppConfigurationResponse
     */
    public function setPayPal_PayLaterEnabled($payPal_PayLaterEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($payPal_PayLaterEnabled) && !is_bool($payPal_PayLaterEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($payPal_PayLaterEnabled, true), gettype($payPal_PayLaterEnabled)), __LINE__);
        }
        $this->PayPal_PayLaterEnabled = $payPal_PayLaterEnabled;
        return $this;
    }
    /**
     * Get PayPal_PrivateKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayPal_PrivateKey()
    {
        return isset($this->PayPal_PrivateKey) ? $this->PayPal_PrivateKey : null;
    }
    /**
     * Set PayPal_PrivateKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payPal_PrivateKey
     * @return \patest\StructType\GetUppConfigurationResponse
     */
    public function setPayPal_PrivateKey($payPal_PrivateKey = null)
    {
        // validation for constraint: string
        if (!is_null($payPal_PrivateKey) && !is_string($payPal_PrivateKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payPal_PrivateKey, true), gettype($payPal_PrivateKey)), __LINE__);
        }
        if (is_null($payPal_PrivateKey) || (is_array($payPal_PrivateKey) && empty($payPal_PrivateKey))) {
            unset($this->PayPal_PrivateKey);
        } else {
            $this->PayPal_PrivateKey = $payPal_PrivateKey;
        }
        return $this;
    }
    /**
     * Get PayPal_PublicKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayPal_PublicKey()
    {
        return isset($this->PayPal_PublicKey) ? $this->PayPal_PublicKey : null;
    }
    /**
     * Set PayPal_PublicKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payPal_PublicKey
     * @return \patest\StructType\GetUppConfigurationResponse
     */
    public function setPayPal_PublicKey($payPal_PublicKey = null)
    {
        // validation for constraint: string
        if (!is_null($payPal_PublicKey) && !is_string($payPal_PublicKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payPal_PublicKey, true), gettype($payPal_PublicKey)), __LINE__);
        }
        if (is_null($payPal_PublicKey) || (is_array($payPal_PublicKey) && empty($payPal_PublicKey))) {
            unset($this->PayPal_PublicKey);
        } else {
            $this->PayPal_PublicKey = $payPal_PublicKey;
        }
        return $this;
    }
    /**
     * Get PaymentType value
     * @return string|null
     */
    public function getPaymentType()
    {
        return $this->PaymentType;
    }
    /**
     * Set PaymentType value
     * @uses \patest\EnumType\PaymentType::valueIsValid()
     * @uses \patest\EnumType\PaymentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentType
     * @return \patest\StructType\GetUppConfigurationResponse
     */
    public function setPaymentType($paymentType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PaymentType::valueIsValid($paymentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentType', is_array($paymentType) ? implode(', ', $paymentType) : var_export($paymentType, true), implode(', ', \patest\EnumType\PaymentType::getValidValues())), __LINE__);
        }
        $this->PaymentType = $paymentType;
        return $this;
    }
    /**
     * Get S4_ClientGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getS4_ClientGuid()
    {
        return isset($this->S4_ClientGuid) ? $this->S4_ClientGuid : null;
    }
    /**
     * Set S4_ClientGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $s4_ClientGuid
     * @return \patest\StructType\GetUppConfigurationResponse
     */
    public function setS4_ClientGuid($s4_ClientGuid = null)
    {
        // validation for constraint: string
        if (!is_null($s4_ClientGuid) && !is_string($s4_ClientGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($s4_ClientGuid, true), gettype($s4_ClientGuid)), __LINE__);
        }
        if (is_null($s4_ClientGuid) || (is_array($s4_ClientGuid) && empty($s4_ClientGuid))) {
            unset($this->S4_ClientGuid);
        } else {
            $this->S4_ClientGuid = $s4_ClientGuid;
        }
        return $this;
    }
    /**
     * Get ST_ConnectAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getST_ConnectAccount()
    {
        return isset($this->ST_ConnectAccount) ? $this->ST_ConnectAccount : null;
    }
    /**
     * Set ST_ConnectAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sT_ConnectAccount
     * @return \patest\StructType\GetUppConfigurationResponse
     */
    public function setST_ConnectAccount($sT_ConnectAccount = null)
    {
        // validation for constraint: string
        if (!is_null($sT_ConnectAccount) && !is_string($sT_ConnectAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sT_ConnectAccount, true), gettype($sT_ConnectAccount)), __LINE__);
        }
        if (is_null($sT_ConnectAccount) || (is_array($sT_ConnectAccount) && empty($sT_ConnectAccount))) {
            unset($this->ST_ConnectAccount);
        } else {
            $this->ST_ConnectAccount = $sT_ConnectAccount;
        }
        return $this;
    }
    /**
     * Get ST_IntegrationMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getST_IntegrationMode()
    {
        return isset($this->ST_IntegrationMode) ? $this->ST_IntegrationMode : null;
    }
    /**
     * Set ST_IntegrationMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\StripeIntegrationMode::valueIsValid()
     * @uses \patest\EnumType\StripeIntegrationMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sT_IntegrationMode
     * @return \patest\StructType\GetUppConfigurationResponse
     */
    public function setST_IntegrationMode($sT_IntegrationMode = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\StripeIntegrationMode::valueIsValid($sT_IntegrationMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\StripeIntegrationMode', is_array($sT_IntegrationMode) ? implode(', ', $sT_IntegrationMode) : var_export($sT_IntegrationMode, true), implode(', ', \patest\EnumType\StripeIntegrationMode::getValidValues())), __LINE__);
        }
        if (is_null($sT_IntegrationMode) || (is_array($sT_IntegrationMode) && empty($sT_IntegrationMode))) {
            unset($this->ST_IntegrationMode);
        } else {
            $this->ST_IntegrationMode = $sT_IntegrationMode;
        }
        return $this;
    }
    /**
     * Get Scenario value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getScenario()
    {
        return isset($this->Scenario) ? $this->Scenario : null;
    }
    /**
     * Set Scenario value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $scenario
     * @return \patest\StructType\GetUppConfigurationResponse
     */
    public function setScenario($scenario = null)
    {
        // validation for constraint: string
        if (!is_null($scenario) && !is_string($scenario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scenario, true), gettype($scenario)), __LINE__);
        }
        if (is_null($scenario) || (is_array($scenario) && empty($scenario))) {
            unset($this->Scenario);
        } else {
            $this->Scenario = $scenario;
        }
        return $this;
    }
    /**
     * Get WP_ApiId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWP_ApiId()
    {
        return isset($this->WP_ApiId) ? $this->WP_ApiId : null;
    }
    /**
     * Set WP_ApiId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $wP_ApiId
     * @return \patest\StructType\GetUppConfigurationResponse
     */
    public function setWP_ApiId($wP_ApiId = null)
    {
        // validation for constraint: string
        if (!is_null($wP_ApiId) && !is_string($wP_ApiId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wP_ApiId, true), gettype($wP_ApiId)), __LINE__);
        }
        if (is_null($wP_ApiId) || (is_array($wP_ApiId) && empty($wP_ApiId))) {
            unset($this->WP_ApiId);
        } else {
            $this->WP_ApiId = $wP_ApiId;
        }
        return $this;
    }
    /**
     * Get WP_ApiKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWP_ApiKey()
    {
        return isset($this->WP_ApiKey) ? $this->WP_ApiKey : null;
    }
    /**
     * Set WP_ApiKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $wP_ApiKey
     * @return \patest\StructType\GetUppConfigurationResponse
     */
    public function setWP_ApiKey($wP_ApiKey = null)
    {
        // validation for constraint: string
        if (!is_null($wP_ApiKey) && !is_string($wP_ApiKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wP_ApiKey, true), gettype($wP_ApiKey)), __LINE__);
        }
        if (is_null($wP_ApiKey) || (is_array($wP_ApiKey) && empty($wP_ApiKey))) {
            unset($this->WP_ApiKey);
        } else {
            $this->WP_ApiKey = $wP_ApiKey;
        }
        return $this;
    }
    /**
     * Get WP_Login value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWP_Login()
    {
        return isset($this->WP_Login) ? $this->WP_Login : null;
    }
    /**
     * Set WP_Login value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $wP_Login
     * @return \patest\StructType\GetUppConfigurationResponse
     */
    public function setWP_Login($wP_Login = null)
    {
        // validation for constraint: string
        if (!is_null($wP_Login) && !is_string($wP_Login)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wP_Login, true), gettype($wP_Login)), __LINE__);
        }
        if (is_null($wP_Login) || (is_array($wP_Login) && empty($wP_Login))) {
            unset($this->WP_Login);
        } else {
            $this->WP_Login = $wP_Login;
        }
        return $this;
    }
    /**
     * Get WP_NotificationEndpoint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWP_NotificationEndpoint()
    {
        return isset($this->WP_NotificationEndpoint) ? $this->WP_NotificationEndpoint : null;
    }
    /**
     * Set WP_NotificationEndpoint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $wP_NotificationEndpoint
     * @return \patest\StructType\GetUppConfigurationResponse
     */
    public function setWP_NotificationEndpoint($wP_NotificationEndpoint = null)
    {
        // validation for constraint: string
        if (!is_null($wP_NotificationEndpoint) && !is_string($wP_NotificationEndpoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wP_NotificationEndpoint, true), gettype($wP_NotificationEndpoint)), __LINE__);
        }
        if (is_null($wP_NotificationEndpoint) || (is_array($wP_NotificationEndpoint) && empty($wP_NotificationEndpoint))) {
            unset($this->WP_NotificationEndpoint);
        } else {
            $this->WP_NotificationEndpoint = $wP_NotificationEndpoint;
        }
        return $this;
    }
    /**
     * Get WP_OrgUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWP_OrgUnitId()
    {
        return isset($this->WP_OrgUnitId) ? $this->WP_OrgUnitId : null;
    }
    /**
     * Set WP_OrgUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $wP_OrgUnitId
     * @return \patest\StructType\GetUppConfigurationResponse
     */
    public function setWP_OrgUnitId($wP_OrgUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($wP_OrgUnitId) && !is_string($wP_OrgUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wP_OrgUnitId, true), gettype($wP_OrgUnitId)), __LINE__);
        }
        if (is_null($wP_OrgUnitId) || (is_array($wP_OrgUnitId) && empty($wP_OrgUnitId))) {
            unset($this->WP_OrgUnitId);
        } else {
            $this->WP_OrgUnitId = $wP_OrgUnitId;
        }
        return $this;
    }
    /**
     * Get WP_Recurring_Login value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWP_Recurring_Login()
    {
        return isset($this->WP_Recurring_Login) ? $this->WP_Recurring_Login : null;
    }
    /**
     * Set WP_Recurring_Login value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $wP_Recurring_Login
     * @return \patest\StructType\GetUppConfigurationResponse
     */
    public function setWP_Recurring_Login($wP_Recurring_Login = null)
    {
        // validation for constraint: string
        if (!is_null($wP_Recurring_Login) && !is_string($wP_Recurring_Login)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wP_Recurring_Login, true), gettype($wP_Recurring_Login)), __LINE__);
        }
        if (is_null($wP_Recurring_Login) || (is_array($wP_Recurring_Login) && empty($wP_Recurring_Login))) {
            unset($this->WP_Recurring_Login);
        } else {
            $this->WP_Recurring_Login = $wP_Recurring_Login;
        }
        return $this;
    }
}
