<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetTransactionPrintingMethodsRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetTransactionPrintingMethodsRequest
 * @subpackage Structs
 */
class GetTransactionPrintingMethodsRequest extends AbstractStructBase
{
    /**
     * The ItemIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfint
     */
    public $ItemIds;
    /**
     * The TransactionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionId;
    /**
     * Constructor method for GetTransactionPrintingMethodsRequest
     * @uses GetTransactionPrintingMethodsRequest::setItemIds()
     * @uses GetTransactionPrintingMethodsRequest::setTransactionId()
     * @param \patest\ArrayType\ArrayOfint $itemIds
     * @param string $transactionId
     */
    public function __construct(\patest\ArrayType\ArrayOfint $itemIds = null, $transactionId = null)
    {
        $this
            ->setItemIds($itemIds)
            ->setTransactionId($transactionId);
    }
    /**
     * Get ItemIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfint|null
     */
    public function getItemIds()
    {
        return isset($this->ItemIds) ? $this->ItemIds : null;
    }
    /**
     * Set ItemIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfint $itemIds
     * @return \patest\StructType\GetTransactionPrintingMethodsRequest
     */
    public function setItemIds(\patest\ArrayType\ArrayOfint $itemIds = null)
    {
        if (is_null($itemIds) || (is_array($itemIds) && empty($itemIds))) {
            unset($this->ItemIds);
        } else {
            $this->ItemIds = $itemIds;
        }
        return $this;
    }
    /**
     * Get TransactionId value
     * @return string|null
     */
    public function getTransactionId()
    {
        return $this->TransactionId;
    }
    /**
     * Set TransactionId value
     * @param string $transactionId
     * @return \patest\StructType\GetTransactionPrintingMethodsRequest
     */
    public function setTransactionId($transactionId = null)
    {
        // validation for constraint: string
        if (!is_null($transactionId) && !is_string($transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionId, true), gettype($transactionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionId, true)), __LINE__);
        }
        $this->TransactionId = $transactionId;
        return $this;
    }
}
