<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetTourShowsList-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetTourShowsList-Request
 * @subpackage Structs
 */
class GetTourShowsList_Request extends ExtensibleDataContract
{
    /**
     * The AssociatedDateFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AssociatedDateFrom;
    /**
     * The AssociatedDateTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AssociatedDateTo;
    /**
     * The CouponIdentity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\CouponIdentity
     */
    public $CouponIdentity;
    /**
     * The FilterByShowTypeIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $FilterByShowTypeIds;
    /**
     * The FromDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FromDate;
    /**
     * The GenreId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GenreId;
    /**
     * The HallId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $HallId;
    /**
     * The IncludeClosedForSale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeClosedForSale;
    /**
     * The IncludeDisplayableFutureSales
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeDisplayableFutureSales;
    /**
     * The IsGroupTour
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsGroupTour;
    /**
     * The IsSupportingMarketDrivenResalePolicy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsSupportingMarketDrivenResalePolicy;
    /**
     * The MaxResultCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxResultCount;
    /**
     * The RecommendedOnly
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RecommendedOnly;
    /**
     * The ShowTypesIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $ShowTypesIds;
    /**
     * The ToDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ToDate;
    /**
     * The VenueId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $VenueId;
    /**
     * Constructor method for GetTourShowsList-Request
     * @uses GetTourShowsList_Request::setAssociatedDateFrom()
     * @uses GetTourShowsList_Request::setAssociatedDateTo()
     * @uses GetTourShowsList_Request::setCouponIdentity()
     * @uses GetTourShowsList_Request::setFilterByShowTypeIds()
     * @uses GetTourShowsList_Request::setFromDate()
     * @uses GetTourShowsList_Request::setGenreId()
     * @uses GetTourShowsList_Request::setHallId()
     * @uses GetTourShowsList_Request::setIncludeClosedForSale()
     * @uses GetTourShowsList_Request::setIncludeDisplayableFutureSales()
     * @uses GetTourShowsList_Request::setIsGroupTour()
     * @uses GetTourShowsList_Request::setIsSupportingMarketDrivenResalePolicy()
     * @uses GetTourShowsList_Request::setMaxResultCount()
     * @uses GetTourShowsList_Request::setRecommendedOnly()
     * @uses GetTourShowsList_Request::setShowTypesIds()
     * @uses GetTourShowsList_Request::setToDate()
     * @uses GetTourShowsList_Request::setVenueId()
     * @param string $associatedDateFrom
     * @param string $associatedDateTo
     * @param \patest\StructType\CouponIdentity $couponIdentity
     * @param bool $filterByShowTypeIds
     * @param string $fromDate
     * @param string $genreId
     * @param string $hallId
     * @param bool $includeClosedForSale
     * @param bool $includeDisplayableFutureSales
     * @param bool $isGroupTour
     * @param bool $isSupportingMarketDrivenResalePolicy
     * @param int $maxResultCount
     * @param string $recommendedOnly
     * @param \patest\ArrayType\ArrayOfguid $showTypesIds
     * @param string $toDate
     * @param string $venueId
     */
    public function __construct($associatedDateFrom = null, $associatedDateTo = null, \patest\StructType\CouponIdentity $couponIdentity = null, $filterByShowTypeIds = null, $fromDate = null, $genreId = null, $hallId = null, $includeClosedForSale = null, $includeDisplayableFutureSales = null, $isGroupTour = null, $isSupportingMarketDrivenResalePolicy = null, $maxResultCount = null, $recommendedOnly = null, \patest\ArrayType\ArrayOfguid $showTypesIds = null, $toDate = null, $venueId = null)
    {
        $this
            ->setAssociatedDateFrom($associatedDateFrom)
            ->setAssociatedDateTo($associatedDateTo)
            ->setCouponIdentity($couponIdentity)
            ->setFilterByShowTypeIds($filterByShowTypeIds)
            ->setFromDate($fromDate)
            ->setGenreId($genreId)
            ->setHallId($hallId)
            ->setIncludeClosedForSale($includeClosedForSale)
            ->setIncludeDisplayableFutureSales($includeDisplayableFutureSales)
            ->setIsGroupTour($isGroupTour)
            ->setIsSupportingMarketDrivenResalePolicy($isSupportingMarketDrivenResalePolicy)
            ->setMaxResultCount($maxResultCount)
            ->setRecommendedOnly($recommendedOnly)
            ->setShowTypesIds($showTypesIds)
            ->setToDate($toDate)
            ->setVenueId($venueId);
    }
    /**
     * Get AssociatedDateFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAssociatedDateFrom()
    {
        return isset($this->AssociatedDateFrom) ? $this->AssociatedDateFrom : null;
    }
    /**
     * Set AssociatedDateFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $associatedDateFrom
     * @return \patest\StructType\GetTourShowsList_Request
     */
    public function setAssociatedDateFrom($associatedDateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($associatedDateFrom) && !is_string($associatedDateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($associatedDateFrom, true), gettype($associatedDateFrom)), __LINE__);
        }
        if (is_null($associatedDateFrom) || (is_array($associatedDateFrom) && empty($associatedDateFrom))) {
            unset($this->AssociatedDateFrom);
        } else {
            $this->AssociatedDateFrom = $associatedDateFrom;
        }
        return $this;
    }
    /**
     * Get AssociatedDateTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAssociatedDateTo()
    {
        return isset($this->AssociatedDateTo) ? $this->AssociatedDateTo : null;
    }
    /**
     * Set AssociatedDateTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $associatedDateTo
     * @return \patest\StructType\GetTourShowsList_Request
     */
    public function setAssociatedDateTo($associatedDateTo = null)
    {
        // validation for constraint: string
        if (!is_null($associatedDateTo) && !is_string($associatedDateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($associatedDateTo, true), gettype($associatedDateTo)), __LINE__);
        }
        if (is_null($associatedDateTo) || (is_array($associatedDateTo) && empty($associatedDateTo))) {
            unset($this->AssociatedDateTo);
        } else {
            $this->AssociatedDateTo = $associatedDateTo;
        }
        return $this;
    }
    /**
     * Get CouponIdentity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\CouponIdentity|null
     */
    public function getCouponIdentity()
    {
        return isset($this->CouponIdentity) ? $this->CouponIdentity : null;
    }
    /**
     * Set CouponIdentity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\CouponIdentity $couponIdentity
     * @return \patest\StructType\GetTourShowsList_Request
     */
    public function setCouponIdentity(\patest\StructType\CouponIdentity $couponIdentity = null)
    {
        if (is_null($couponIdentity) || (is_array($couponIdentity) && empty($couponIdentity))) {
            unset($this->CouponIdentity);
        } else {
            $this->CouponIdentity = $couponIdentity;
        }
        return $this;
    }
    /**
     * Get FilterByShowTypeIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getFilterByShowTypeIds()
    {
        return isset($this->FilterByShowTypeIds) ? $this->FilterByShowTypeIds : null;
    }
    /**
     * Set FilterByShowTypeIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $filterByShowTypeIds
     * @return \patest\StructType\GetTourShowsList_Request
     */
    public function setFilterByShowTypeIds($filterByShowTypeIds = null)
    {
        // validation for constraint: boolean
        if (!is_null($filterByShowTypeIds) && !is_bool($filterByShowTypeIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($filterByShowTypeIds, true), gettype($filterByShowTypeIds)), __LINE__);
        }
        if (is_null($filterByShowTypeIds) || (is_array($filterByShowTypeIds) && empty($filterByShowTypeIds))) {
            unset($this->FilterByShowTypeIds);
        } else {
            $this->FilterByShowTypeIds = $filterByShowTypeIds;
        }
        return $this;
    }
    /**
     * Get FromDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromDate()
    {
        return isset($this->FromDate) ? $this->FromDate : null;
    }
    /**
     * Set FromDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromDate
     * @return \patest\StructType\GetTourShowsList_Request
     */
    public function setFromDate($fromDate = null)
    {
        // validation for constraint: string
        if (!is_null($fromDate) && !is_string($fromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromDate, true), gettype($fromDate)), __LINE__);
        }
        if (is_null($fromDate) || (is_array($fromDate) && empty($fromDate))) {
            unset($this->FromDate);
        } else {
            $this->FromDate = $fromDate;
        }
        return $this;
    }
    /**
     * Get GenreId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGenreId()
    {
        return isset($this->GenreId) ? $this->GenreId : null;
    }
    /**
     * Set GenreId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $genreId
     * @return \patest\StructType\GetTourShowsList_Request
     */
    public function setGenreId($genreId = null)
    {
        // validation for constraint: string
        if (!is_null($genreId) && !is_string($genreId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($genreId, true), gettype($genreId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($genreId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $genreId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($genreId, true)), __LINE__);
        }
        if (is_null($genreId) || (is_array($genreId) && empty($genreId))) {
            unset($this->GenreId);
        } else {
            $this->GenreId = $genreId;
        }
        return $this;
    }
    /**
     * Get HallId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallId()
    {
        return isset($this->HallId) ? $this->HallId : null;
    }
    /**
     * Set HallId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hallId
     * @return \patest\StructType\GetTourShowsList_Request
     */
    public function setHallId($hallId = null)
    {
        // validation for constraint: string
        if (!is_null($hallId) && !is_string($hallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallId, true), gettype($hallId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($hallId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $hallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($hallId, true)), __LINE__);
        }
        if (is_null($hallId) || (is_array($hallId) && empty($hallId))) {
            unset($this->HallId);
        } else {
            $this->HallId = $hallId;
        }
        return $this;
    }
    /**
     * Get IncludeClosedForSale value
     * @return bool|null
     */
    public function getIncludeClosedForSale()
    {
        return $this->IncludeClosedForSale;
    }
    /**
     * Set IncludeClosedForSale value
     * @param bool $includeClosedForSale
     * @return \patest\StructType\GetTourShowsList_Request
     */
    public function setIncludeClosedForSale($includeClosedForSale = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeClosedForSale) && !is_bool($includeClosedForSale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeClosedForSale, true), gettype($includeClosedForSale)), __LINE__);
        }
        $this->IncludeClosedForSale = $includeClosedForSale;
        return $this;
    }
    /**
     * Get IncludeDisplayableFutureSales value
     * @return bool|null
     */
    public function getIncludeDisplayableFutureSales()
    {
        return $this->IncludeDisplayableFutureSales;
    }
    /**
     * Set IncludeDisplayableFutureSales value
     * @param bool $includeDisplayableFutureSales
     * @return \patest\StructType\GetTourShowsList_Request
     */
    public function setIncludeDisplayableFutureSales($includeDisplayableFutureSales = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeDisplayableFutureSales) && !is_bool($includeDisplayableFutureSales)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeDisplayableFutureSales, true), gettype($includeDisplayableFutureSales)), __LINE__);
        }
        $this->IncludeDisplayableFutureSales = $includeDisplayableFutureSales;
        return $this;
    }
    /**
     * Get IsGroupTour value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsGroupTour()
    {
        return isset($this->IsGroupTour) ? $this->IsGroupTour : null;
    }
    /**
     * Set IsGroupTour value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isGroupTour
     * @return \patest\StructType\GetTourShowsList_Request
     */
    public function setIsGroupTour($isGroupTour = null)
    {
        // validation for constraint: boolean
        if (!is_null($isGroupTour) && !is_bool($isGroupTour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isGroupTour, true), gettype($isGroupTour)), __LINE__);
        }
        if (is_null($isGroupTour) || (is_array($isGroupTour) && empty($isGroupTour))) {
            unset($this->IsGroupTour);
        } else {
            $this->IsGroupTour = $isGroupTour;
        }
        return $this;
    }
    /**
     * Get IsSupportingMarketDrivenResalePolicy value
     * @return bool|null
     */
    public function getIsSupportingMarketDrivenResalePolicy()
    {
        return $this->IsSupportingMarketDrivenResalePolicy;
    }
    /**
     * Set IsSupportingMarketDrivenResalePolicy value
     * @param bool $isSupportingMarketDrivenResalePolicy
     * @return \patest\StructType\GetTourShowsList_Request
     */
    public function setIsSupportingMarketDrivenResalePolicy($isSupportingMarketDrivenResalePolicy = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSupportingMarketDrivenResalePolicy) && !is_bool($isSupportingMarketDrivenResalePolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSupportingMarketDrivenResalePolicy, true), gettype($isSupportingMarketDrivenResalePolicy)), __LINE__);
        }
        $this->IsSupportingMarketDrivenResalePolicy = $isSupportingMarketDrivenResalePolicy;
        return $this;
    }
    /**
     * Get MaxResultCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxResultCount()
    {
        return isset($this->MaxResultCount) ? $this->MaxResultCount : null;
    }
    /**
     * Set MaxResultCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxResultCount
     * @return \patest\StructType\GetTourShowsList_Request
     */
    public function setMaxResultCount($maxResultCount = null)
    {
        // validation for constraint: int
        if (!is_null($maxResultCount) && !(is_int($maxResultCount) || ctype_digit($maxResultCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxResultCount, true), gettype($maxResultCount)), __LINE__);
        }
        if (is_null($maxResultCount) || (is_array($maxResultCount) && empty($maxResultCount))) {
            unset($this->MaxResultCount);
        } else {
            $this->MaxResultCount = $maxResultCount;
        }
        return $this;
    }
    /**
     * Get RecommendedOnly value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRecommendedOnly()
    {
        return isset($this->RecommendedOnly) ? $this->RecommendedOnly : null;
    }
    /**
     * Set RecommendedOnly value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ShowRecommendationScope::valueIsValid()
     * @uses \patest\EnumType\ShowRecommendationScope::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $recommendedOnly
     * @return \patest\StructType\GetTourShowsList_Request
     */
    public function setRecommendedOnly($recommendedOnly = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ShowRecommendationScope::valueIsValid($recommendedOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ShowRecommendationScope', is_array($recommendedOnly) ? implode(', ', $recommendedOnly) : var_export($recommendedOnly, true), implode(', ', \patest\EnumType\ShowRecommendationScope::getValidValues())), __LINE__);
        }
        if (is_null($recommendedOnly) || (is_array($recommendedOnly) && empty($recommendedOnly))) {
            unset($this->RecommendedOnly);
        } else {
            $this->RecommendedOnly = $recommendedOnly;
        }
        return $this;
    }
    /**
     * Get ShowTypesIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getShowTypesIds()
    {
        return isset($this->ShowTypesIds) ? $this->ShowTypesIds : null;
    }
    /**
     * Set ShowTypesIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $showTypesIds
     * @return \patest\StructType\GetTourShowsList_Request
     */
    public function setShowTypesIds(\patest\ArrayType\ArrayOfguid $showTypesIds = null)
    {
        if (is_null($showTypesIds) || (is_array($showTypesIds) && empty($showTypesIds))) {
            unset($this->ShowTypesIds);
        } else {
            $this->ShowTypesIds = $showTypesIds;
        }
        return $this;
    }
    /**
     * Get ToDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToDate()
    {
        return isset($this->ToDate) ? $this->ToDate : null;
    }
    /**
     * Set ToDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $toDate
     * @return \patest\StructType\GetTourShowsList_Request
     */
    public function setToDate($toDate = null)
    {
        // validation for constraint: string
        if (!is_null($toDate) && !is_string($toDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toDate, true), gettype($toDate)), __LINE__);
        }
        if (is_null($toDate) || (is_array($toDate) && empty($toDate))) {
            unset($this->ToDate);
        } else {
            $this->ToDate = $toDate;
        }
        return $this;
    }
    /**
     * Get VenueId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVenueId()
    {
        return isset($this->VenueId) ? $this->VenueId : null;
    }
    /**
     * Set VenueId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $venueId
     * @return \patest\StructType\GetTourShowsList_Request
     */
    public function setVenueId($venueId = null)
    {
        // validation for constraint: string
        if (!is_null($venueId) && !is_string($venueId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($venueId, true), gettype($venueId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($venueId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $venueId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($venueId, true)), __LINE__);
        }
        if (is_null($venueId) || (is_array($venueId) && empty($venueId))) {
            unset($this->VenueId);
        } else {
            $this->VenueId = $venueId;
        }
        return $this;
    }
}
