<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetTicketsToManageResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetTicketsToManageResponse
 * @subpackage Structs
 */
class GetTicketsToManageResponse extends AbstractStructBase
{
    /**
     * The IsThereMoreData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsThereMoreData;
    /**
     * The Tickets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfClientTicketDetails
     */
    public $Tickets;
    /**
     * Constructor method for GetTicketsToManageResponse
     * @uses GetTicketsToManageResponse::setIsThereMoreData()
     * @uses GetTicketsToManageResponse::setTickets()
     * @param bool $isThereMoreData
     * @param \patest\ArrayType\ArrayOfClientTicketDetails $tickets
     */
    public function __construct($isThereMoreData = null, \patest\ArrayType\ArrayOfClientTicketDetails $tickets = null)
    {
        $this
            ->setIsThereMoreData($isThereMoreData)
            ->setTickets($tickets);
    }
    /**
     * Get IsThereMoreData value
     * @return bool|null
     */
    public function getIsThereMoreData()
    {
        return $this->IsThereMoreData;
    }
    /**
     * Set IsThereMoreData value
     * @param bool $isThereMoreData
     * @return \patest\StructType\GetTicketsToManageResponse
     */
    public function setIsThereMoreData($isThereMoreData = null)
    {
        // validation for constraint: boolean
        if (!is_null($isThereMoreData) && !is_bool($isThereMoreData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isThereMoreData, true), gettype($isThereMoreData)), __LINE__);
        }
        $this->IsThereMoreData = $isThereMoreData;
        return $this;
    }
    /**
     * Get Tickets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfClientTicketDetails|null
     */
    public function getTickets()
    {
        return isset($this->Tickets) ? $this->Tickets : null;
    }
    /**
     * Set Tickets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfClientTicketDetails $tickets
     * @return \patest\StructType\GetTicketsToManageResponse
     */
    public function setTickets(\patest\ArrayType\ArrayOfClientTicketDetails $tickets = null)
    {
        if (is_null($tickets) || (is_array($tickets) && empty($tickets))) {
            unset($this->Tickets);
        } else {
            $this->Tickets = $tickets;
        }
        return $this;
    }
}
