<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * GetTicketViewAssociationsByApplicationObjectIdentifierRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetTicketViewAssociationsByApplicationObjectIdentifierRequest
 * @subpackage Structs
 */
class GetTicketViewAssociationsByApplicationObjectIdentifierRequest extends AbstractStructBase
{
    /**
     * The ApplicationLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ApplicationLevel;
    /**
     * The ApplicationObjectIdentifier
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ApplicationObjectIdentifier;
    /**
     * Constructor method for
     * GetTicketViewAssociationsByApplicationObjectIdentifierRequest
     * @uses GetTicketViewAssociationsByApplicationObjectIdentifierRequest::setApplicationLevel()
     * @uses GetTicketViewAssociationsByApplicationObjectIdentifierRequest::setApplicationObjectIdentifier()
     * @param string $applicationLevel
     * @param string $applicationObjectIdentifier
     */
    public function __construct($applicationLevel = null, $applicationObjectIdentifier = null)
    {
        $this
            ->setApplicationLevel($applicationLevel)
            ->setApplicationObjectIdentifier($applicationObjectIdentifier);
    }
    /**
     * Get ApplicationLevel value
     * @return string|null
     */
    public function getApplicationLevel()
    {
        return $this->ApplicationLevel;
    }
    /**
     * Set ApplicationLevel value
     * @uses \patest\EnumType\TicketConfigurationApplicationLevel::valueIsValid()
     * @uses \patest\EnumType\TicketConfigurationApplicationLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $applicationLevel
     * @return \patest\StructType\GetTicketViewAssociationsByApplicationObjectIdentifierRequest
     */
    public function setApplicationLevel($applicationLevel = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TicketConfigurationApplicationLevel::valueIsValid($applicationLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TicketConfigurationApplicationLevel', is_array($applicationLevel) ? implode(', ', $applicationLevel) : var_export($applicationLevel, true), implode(', ', \patest\EnumType\TicketConfigurationApplicationLevel::getValidValues())), __LINE__);
        }
        $this->ApplicationLevel = $applicationLevel;
        return $this;
    }
    /**
     * Get ApplicationObjectIdentifier value
     * @return string|null
     */
    public function getApplicationObjectIdentifier()
    {
        return $this->ApplicationObjectIdentifier;
    }
    /**
     * Set ApplicationObjectIdentifier value
     * @param string $applicationObjectIdentifier
     * @return \patest\StructType\GetTicketViewAssociationsByApplicationObjectIdentifierRequest
     */
    public function setApplicationObjectIdentifier($applicationObjectIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($applicationObjectIdentifier) && !is_string($applicationObjectIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationObjectIdentifier, true), gettype($applicationObjectIdentifier)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($applicationObjectIdentifier) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $applicationObjectIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($applicationObjectIdentifier, true)), __LINE__);
        }
        $this->ApplicationObjectIdentifier = $applicationObjectIdentifier;
        return $this;
    }
}
