<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetTicketViewAssociation-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetTicketViewAssociation-Request
 * @subpackage Structs
 */
class GetTicketViewAssociation_Request extends ExtensibleDataContract
{
    /**
     * The AssociationId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AssociationId;
    /**
     * Constructor method for GetTicketViewAssociation-Request
     * @uses GetTicketViewAssociation_Request::setAssociationId()
     * @param string $associationId
     */
    public function __construct($associationId = null)
    {
        $this
            ->setAssociationId($associationId);
    }
    /**
     * Get AssociationId value
     * @return string|null
     */
    public function getAssociationId()
    {
        return $this->AssociationId;
    }
    /**
     * Set AssociationId value
     * @param string $associationId
     * @return \patest\StructType\GetTicketViewAssociation_Request
     */
    public function setAssociationId($associationId = null)
    {
        // validation for constraint: string
        if (!is_null($associationId) && !is_string($associationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($associationId, true), gettype($associationId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($associationId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $associationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($associationId, true)), __LINE__);
        }
        $this->AssociationId = $associationId;
        return $this;
    }
}
