<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetTaggedProductsResponse-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetTaggedProductsResponse-Request
 * @subpackage Structs
 */
class GetTaggedProductsResponse_Request extends ExtensibleDataContract
{
    /**
     * The Products
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfMerchandise_Product
     */
    public $Products;
    /**
     * Constructor method for GetTaggedProductsResponse-Request
     * @uses GetTaggedProductsResponse_Request::setProducts()
     * @param \patest\ArrayType\ArrayOfMerchandise_Product $products
     */
    public function __construct(\patest\ArrayType\ArrayOfMerchandise_Product $products = null)
    {
        $this
            ->setProducts($products);
    }
    /**
     * Get Products value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfMerchandise_Product|null
     */
    public function getProducts()
    {
        return isset($this->Products) ? $this->Products : null;
    }
    /**
     * Set Products value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfMerchandise_Product $products
     * @return \patest\StructType\GetTaggedProductsResponse_Request
     */
    public function setProducts(\patest\ArrayType\ArrayOfMerchandise_Product $products = null)
    {
        if (is_null($products) || (is_array($products) && empty($products))) {
            unset($this->Products);
        } else {
            $this->Products = $products;
        }
        return $this;
    }
}
