<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetSeatHistoryAndInformation-Response StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetSeatHistoryAndInformation-Response
 * @subpackage Structs
 */
class GetSeatHistoryAndInformation_Response extends ExtensibleDataContract
{
    /**
     * The CurrentStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SeatInformation
     */
    public $CurrentStatus;
    /**
     * The History
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfAnyEntity
     */
    public $History;
    /**
     * Constructor method for GetSeatHistoryAndInformation-Response
     * @uses GetSeatHistoryAndInformation_Response::setCurrentStatus()
     * @uses GetSeatHistoryAndInformation_Response::setHistory()
     * @param \patest\StructType\SeatInformation $currentStatus
     * @param \patest\StructType\RecordSetOfAnyEntity $history
     */
    public function __construct(\patest\StructType\SeatInformation $currentStatus = null, \patest\StructType\RecordSetOfAnyEntity $history = null)
    {
        $this
            ->setCurrentStatus($currentStatus)
            ->setHistory($history);
    }
    /**
     * Get CurrentStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SeatInformation|null
     */
    public function getCurrentStatus()
    {
        return isset($this->CurrentStatus) ? $this->CurrentStatus : null;
    }
    /**
     * Set CurrentStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SeatInformation $currentStatus
     * @return \patest\StructType\GetSeatHistoryAndInformation_Response
     */
    public function setCurrentStatus(\patest\StructType\SeatInformation $currentStatus = null)
    {
        if (is_null($currentStatus) || (is_array($currentStatus) && empty($currentStatus))) {
            unset($this->CurrentStatus);
        } else {
            $this->CurrentStatus = $currentStatus;
        }
        return $this;
    }
    /**
     * Get History value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfAnyEntity|null
     */
    public function getHistory()
    {
        return isset($this->History) ? $this->History : null;
    }
    /**
     * Set History value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfAnyEntity $history
     * @return \patest\StructType\GetSeatHistoryAndInformation_Response
     */
    public function setHistory(\patest\StructType\RecordSetOfAnyEntity $history = null)
    {
        if (is_null($history) || (is_array($history) && empty($history))) {
            unset($this->History);
        } else {
            $this->History = $history;
        }
        return $this;
    }
}
