<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetSchemeDescription-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetSchemeDescription-Request
 * @subpackage Structs
 */
class GetSchemeDescription_Request extends ExtensibleDataContract
{
    /**
     * The SchemeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SchemeId;
    /**
     * Constructor method for GetSchemeDescription-Request
     * @uses GetSchemeDescription_Request::setSchemeId()
     * @param string $schemeId
     */
    public function __construct($schemeId = null)
    {
        $this
            ->setSchemeId($schemeId);
    }
    /**
     * Get SchemeId value
     * @return string|null
     */
    public function getSchemeId()
    {
        return $this->SchemeId;
    }
    /**
     * Set SchemeId value
     * @param string $schemeId
     * @return \patest\StructType\GetSchemeDescription_Request
     */
    public function setSchemeId($schemeId = null)
    {
        // validation for constraint: string
        if (!is_null($schemeId) && !is_string($schemeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schemeId, true), gettype($schemeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($schemeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $schemeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($schemeId, true)), __LINE__);
        }
        $this->SchemeId = $schemeId;
        return $this;
    }
}
