<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetRuleSystemDescriptionRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetRuleSystemDescriptionRequest
 * @subpackage Structs
 */
class GetRuleSystemDescriptionRequest extends ExtensibleDataContract
{
    /**
     * The ContextEntityId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContextEntityId;
    /**
     * The ContextEntityName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContextEntityName;
    /**
     * The IncludeSpecificValues
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfKeyValueOfstringArrayOfstringty7Ep6D1
     */
    public $IncludeSpecificValues;
    /**
     * The IncludeValues
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeValues;
    /**
     * The RuleSystemName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RuleSystemName;
    /**
     * The ValueGetterIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfstring
     */
    public $ValueGetterIds;
    /**
     * The LargeLookupThreshold
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $LargeLookupThreshold;
    /**
     * Constructor method for GetRuleSystemDescriptionRequest
     * @uses GetRuleSystemDescriptionRequest::setContextEntityId()
     * @uses GetRuleSystemDescriptionRequest::setContextEntityName()
     * @uses GetRuleSystemDescriptionRequest::setIncludeSpecificValues()
     * @uses GetRuleSystemDescriptionRequest::setIncludeValues()
     * @uses GetRuleSystemDescriptionRequest::setRuleSystemName()
     * @uses GetRuleSystemDescriptionRequest::setValueGetterIds()
     * @uses GetRuleSystemDescriptionRequest::setLargeLookupThreshold()
     * @param string $contextEntityId
     * @param string $contextEntityName
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringArrayOfstringty7Ep6D1 $includeSpecificValues
     * @param bool $includeValues
     * @param string $ruleSystemName
     * @param \patest\ArrayType\ArrayOfstring $valueGetterIds
     * @param int $largeLookupThreshold
     */
    public function __construct($contextEntityId = null, $contextEntityName = null, \patest\ArrayType\ArrayOfKeyValueOfstringArrayOfstringty7Ep6D1 $includeSpecificValues = null, $includeValues = null, $ruleSystemName = null, \patest\ArrayType\ArrayOfstring $valueGetterIds = null, $largeLookupThreshold = null)
    {
        $this
            ->setContextEntityId($contextEntityId)
            ->setContextEntityName($contextEntityName)
            ->setIncludeSpecificValues($includeSpecificValues)
            ->setIncludeValues($includeValues)
            ->setRuleSystemName($ruleSystemName)
            ->setValueGetterIds($valueGetterIds)
            ->setLargeLookupThreshold($largeLookupThreshold);
    }
    /**
     * Get ContextEntityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContextEntityId()
    {
        return isset($this->ContextEntityId) ? $this->ContextEntityId : null;
    }
    /**
     * Set ContextEntityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contextEntityId
     * @return \patest\StructType\GetRuleSystemDescriptionRequest
     */
    public function setContextEntityId($contextEntityId = null)
    {
        // validation for constraint: string
        if (!is_null($contextEntityId) && !is_string($contextEntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contextEntityId, true), gettype($contextEntityId)), __LINE__);
        }
        if (is_null($contextEntityId) || (is_array($contextEntityId) && empty($contextEntityId))) {
            unset($this->ContextEntityId);
        } else {
            $this->ContextEntityId = $contextEntityId;
        }
        return $this;
    }
    /**
     * Get ContextEntityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContextEntityName()
    {
        return isset($this->ContextEntityName) ? $this->ContextEntityName : null;
    }
    /**
     * Set ContextEntityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contextEntityName
     * @return \patest\StructType\GetRuleSystemDescriptionRequest
     */
    public function setContextEntityName($contextEntityName = null)
    {
        // validation for constraint: string
        if (!is_null($contextEntityName) && !is_string($contextEntityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contextEntityName, true), gettype($contextEntityName)), __LINE__);
        }
        if (is_null($contextEntityName) || (is_array($contextEntityName) && empty($contextEntityName))) {
            unset($this->ContextEntityName);
        } else {
            $this->ContextEntityName = $contextEntityName;
        }
        return $this;
    }
    /**
     * Get IncludeSpecificValues value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfKeyValueOfstringArrayOfstringty7Ep6D1|null
     */
    public function getIncludeSpecificValues()
    {
        return isset($this->IncludeSpecificValues) ? $this->IncludeSpecificValues : null;
    }
    /**
     * Set IncludeSpecificValues value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringArrayOfstringty7Ep6D1 $includeSpecificValues
     * @return \patest\StructType\GetRuleSystemDescriptionRequest
     */
    public function setIncludeSpecificValues(\patest\ArrayType\ArrayOfKeyValueOfstringArrayOfstringty7Ep6D1 $includeSpecificValues = null)
    {
        if (is_null($includeSpecificValues) || (is_array($includeSpecificValues) && empty($includeSpecificValues))) {
            unset($this->IncludeSpecificValues);
        } else {
            $this->IncludeSpecificValues = $includeSpecificValues;
        }
        return $this;
    }
    /**
     * Get IncludeValues value
     * @return bool|null
     */
    public function getIncludeValues()
    {
        return $this->IncludeValues;
    }
    /**
     * Set IncludeValues value
     * @param bool $includeValues
     * @return \patest\StructType\GetRuleSystemDescriptionRequest
     */
    public function setIncludeValues($includeValues = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeValues) && !is_bool($includeValues)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeValues, true), gettype($includeValues)), __LINE__);
        }
        $this->IncludeValues = $includeValues;
        return $this;
    }
    /**
     * Get RuleSystemName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRuleSystemName()
    {
        return isset($this->RuleSystemName) ? $this->RuleSystemName : null;
    }
    /**
     * Set RuleSystemName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ruleSystemName
     * @return \patest\StructType\GetRuleSystemDescriptionRequest
     */
    public function setRuleSystemName($ruleSystemName = null)
    {
        // validation for constraint: string
        if (!is_null($ruleSystemName) && !is_string($ruleSystemName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ruleSystemName, true), gettype($ruleSystemName)), __LINE__);
        }
        if (is_null($ruleSystemName) || (is_array($ruleSystemName) && empty($ruleSystemName))) {
            unset($this->RuleSystemName);
        } else {
            $this->RuleSystemName = $ruleSystemName;
        }
        return $this;
    }
    /**
     * Get ValueGetterIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfstring|null
     */
    public function getValueGetterIds()
    {
        return isset($this->ValueGetterIds) ? $this->ValueGetterIds : null;
    }
    /**
     * Set ValueGetterIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfstring $valueGetterIds
     * @return \patest\StructType\GetRuleSystemDescriptionRequest
     */
    public function setValueGetterIds(\patest\ArrayType\ArrayOfstring $valueGetterIds = null)
    {
        if (is_null($valueGetterIds) || (is_array($valueGetterIds) && empty($valueGetterIds))) {
            unset($this->ValueGetterIds);
        } else {
            $this->ValueGetterIds = $valueGetterIds;
        }
        return $this;
    }
    /**
     * Get LargeLookupThreshold value
     * @return int|null
     */
    public function getLargeLookupThreshold()
    {
        return $this->LargeLookupThreshold;
    }
    /**
     * Set LargeLookupThreshold value
     * @param int $largeLookupThreshold
     * @return \patest\StructType\GetRuleSystemDescriptionRequest
     */
    public function setLargeLookupThreshold($largeLookupThreshold = null)
    {
        // validation for constraint: int
        if (!is_null($largeLookupThreshold) && !(is_int($largeLookupThreshold) || ctype_digit($largeLookupThreshold))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($largeLookupThreshold, true), gettype($largeLookupThreshold)), __LINE__);
        }
        $this->LargeLookupThreshold = $largeLookupThreshold;
        return $this;
    }
}
