<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetRelatedClientsRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetRelatedClientsRequest
 * @subpackage Structs
 */
class GetRelatedClientsRequest extends AbstractStructBase
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The IncludeTemporaryRelations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeTemporaryRelations;
    /**
     * Constructor method for GetRelatedClientsRequest
     * @uses GetRelatedClientsRequest::setClientId()
     * @uses GetRelatedClientsRequest::setIncludeTemporaryRelations()
     * @param string $clientId
     * @param bool $includeTemporaryRelations
     */
    public function __construct($clientId = null, $includeTemporaryRelations = null)
    {
        $this
            ->setClientId($clientId)
            ->setIncludeTemporaryRelations($includeTemporaryRelations);
    }
    /**
     * Get ClientId value
     * @return string|null
     */
    public function getClientId()
    {
        return $this->ClientId;
    }
    /**
     * Set ClientId value
     * @param string $clientId
     * @return \patest\StructType\GetRelatedClientsRequest
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        $this->ClientId = $clientId;
        return $this;
    }
    /**
     * Get IncludeTemporaryRelations value
     * @return bool|null
     */
    public function getIncludeTemporaryRelations()
    {
        return $this->IncludeTemporaryRelations;
    }
    /**
     * Set IncludeTemporaryRelations value
     * @param bool $includeTemporaryRelations
     * @return \patest\StructType\GetRelatedClientsRequest
     */
    public function setIncludeTemporaryRelations($includeTemporaryRelations = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeTemporaryRelations) && !is_bool($includeTemporaryRelations)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeTemporaryRelations, true), gettype($includeTemporaryRelations)), __LINE__);
        }
        $this->IncludeTemporaryRelations = $includeTemporaryRelations;
        return $this;
    }
}
