<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetPresaleExtraData-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetPresaleExtraData-Request
 * @subpackage Structs
 */
class GetPresaleExtraData_Request extends ExtensibleDataContract
{
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The IncludeEventUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeEventUrl;
    /**
     * Constructor method for GetPresaleExtraData-Request
     * @uses GetPresaleExtraData_Request::setEventId()
     * @uses GetPresaleExtraData_Request::setIncludeEventUrl()
     * @param string $eventId
     * @param bool $includeEventUrl
     */
    public function __construct($eventId = null, $includeEventUrl = null)
    {
        $this
            ->setEventId($eventId)
            ->setIncludeEventUrl($includeEventUrl);
    }
    /**
     * Get EventId value
     * @return string|null
     */
    public function getEventId()
    {
        return $this->EventId;
    }
    /**
     * Set EventId value
     * @param string $eventId
     * @return \patest\StructType\GetPresaleExtraData_Request
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        $this->EventId = $eventId;
        return $this;
    }
    /**
     * Get IncludeEventUrl value
     * @return bool|null
     */
    public function getIncludeEventUrl()
    {
        return $this->IncludeEventUrl;
    }
    /**
     * Set IncludeEventUrl value
     * @param bool $includeEventUrl
     * @return \patest\StructType\GetPresaleExtraData_Request
     */
    public function setIncludeEventUrl($includeEventUrl = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeEventUrl) && !is_bool($includeEventUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeEventUrl, true), gettype($includeEventUrl)), __LINE__);
        }
        $this->IncludeEventUrl = $includeEventUrl;
        return $this;
    }
}
