<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetMergedPdfDocumentsAsStreamRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetMergedPdfDocumentsAsStreamRequest
 * @subpackage Structs
 */
class GetMergedPdfDocumentsAsStreamRequest extends AbstractStructBase
{
    /**
     * The IsReprint
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsReprint;
    /**
     * The LookInArchiveOnly
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $LookInArchiveOnly;
    /**
     * The ReferenceEntityName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReferenceEntityName;
    /**
     * The ReferenceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ReferenceId;
    /**
     * The SalePointId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SalePointId;
    /**
     * The Scenario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Scenario;
    /**
     * The SpoolGroupId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SpoolGroupId;
    /**
     * The TimeInterval
     * Meta information extracted from the WSDL
     * - base: xs:duration
     * - maxInclusive: P10675199DT2H48M5.4775807S
     * - minInclusive: -P10675199DT2H48M5.4775808S
     * - minOccurs: 0
     * - nillable: true
     * - pattern: \-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?
     * - type: tns:duration
     * @var string
     */
    public $TimeInterval;
    /**
     * The UserId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $UserId;
    /**
     * Constructor method for GetMergedPdfDocumentsAsStreamRequest
     * @uses GetMergedPdfDocumentsAsStreamRequest::setIsReprint()
     * @uses GetMergedPdfDocumentsAsStreamRequest::setLookInArchiveOnly()
     * @uses GetMergedPdfDocumentsAsStreamRequest::setReferenceEntityName()
     * @uses GetMergedPdfDocumentsAsStreamRequest::setReferenceId()
     * @uses GetMergedPdfDocumentsAsStreamRequest::setSalePointId()
     * @uses GetMergedPdfDocumentsAsStreamRequest::setScenario()
     * @uses GetMergedPdfDocumentsAsStreamRequest::setSpoolGroupId()
     * @uses GetMergedPdfDocumentsAsStreamRequest::setTimeInterval()
     * @uses GetMergedPdfDocumentsAsStreamRequest::setUserId()
     * @param bool $isReprint
     * @param bool $lookInArchiveOnly
     * @param string $referenceEntityName
     * @param string $referenceId
     * @param string $salePointId
     * @param string $scenario
     * @param string $spoolGroupId
     * @param string $timeInterval
     * @param string $userId
     */
    public function __construct($isReprint = null, $lookInArchiveOnly = null, $referenceEntityName = null, $referenceId = null, $salePointId = null, $scenario = null, $spoolGroupId = null, $timeInterval = null, $userId = null)
    {
        $this
            ->setIsReprint($isReprint)
            ->setLookInArchiveOnly($lookInArchiveOnly)
            ->setReferenceEntityName($referenceEntityName)
            ->setReferenceId($referenceId)
            ->setSalePointId($salePointId)
            ->setScenario($scenario)
            ->setSpoolGroupId($spoolGroupId)
            ->setTimeInterval($timeInterval)
            ->setUserId($userId);
    }
    /**
     * Get IsReprint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsReprint()
    {
        return isset($this->IsReprint) ? $this->IsReprint : null;
    }
    /**
     * Set IsReprint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isReprint
     * @return \patest\StructType\GetMergedPdfDocumentsAsStreamRequest
     */
    public function setIsReprint($isReprint = null)
    {
        // validation for constraint: boolean
        if (!is_null($isReprint) && !is_bool($isReprint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isReprint, true), gettype($isReprint)), __LINE__);
        }
        if (is_null($isReprint) || (is_array($isReprint) && empty($isReprint))) {
            unset($this->IsReprint);
        } else {
            $this->IsReprint = $isReprint;
        }
        return $this;
    }
    /**
     * Get LookInArchiveOnly value
     * @return bool|null
     */
    public function getLookInArchiveOnly()
    {
        return $this->LookInArchiveOnly;
    }
    /**
     * Set LookInArchiveOnly value
     * @param bool $lookInArchiveOnly
     * @return \patest\StructType\GetMergedPdfDocumentsAsStreamRequest
     */
    public function setLookInArchiveOnly($lookInArchiveOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($lookInArchiveOnly) && !is_bool($lookInArchiveOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($lookInArchiveOnly, true), gettype($lookInArchiveOnly)), __LINE__);
        }
        $this->LookInArchiveOnly = $lookInArchiveOnly;
        return $this;
    }
    /**
     * Get ReferenceEntityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReferenceEntityName()
    {
        return isset($this->ReferenceEntityName) ? $this->ReferenceEntityName : null;
    }
    /**
     * Set ReferenceEntityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $referenceEntityName
     * @return \patest\StructType\GetMergedPdfDocumentsAsStreamRequest
     */
    public function setReferenceEntityName($referenceEntityName = null)
    {
        // validation for constraint: string
        if (!is_null($referenceEntityName) && !is_string($referenceEntityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceEntityName, true), gettype($referenceEntityName)), __LINE__);
        }
        if (is_null($referenceEntityName) || (is_array($referenceEntityName) && empty($referenceEntityName))) {
            unset($this->ReferenceEntityName);
        } else {
            $this->ReferenceEntityName = $referenceEntityName;
        }
        return $this;
    }
    /**
     * Get ReferenceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReferenceId()
    {
        return isset($this->ReferenceId) ? $this->ReferenceId : null;
    }
    /**
     * Set ReferenceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $referenceId
     * @return \patest\StructType\GetMergedPdfDocumentsAsStreamRequest
     */
    public function setReferenceId($referenceId = null)
    {
        // validation for constraint: string
        if (!is_null($referenceId) && !is_string($referenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceId, true), gettype($referenceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($referenceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $referenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($referenceId, true)), __LINE__);
        }
        if (is_null($referenceId) || (is_array($referenceId) && empty($referenceId))) {
            unset($this->ReferenceId);
        } else {
            $this->ReferenceId = $referenceId;
        }
        return $this;
    }
    /**
     * Get SalePointId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalePointId()
    {
        return isset($this->SalePointId) ? $this->SalePointId : null;
    }
    /**
     * Set SalePointId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salePointId
     * @return \patest\StructType\GetMergedPdfDocumentsAsStreamRequest
     */
    public function setSalePointId($salePointId = null)
    {
        // validation for constraint: string
        if (!is_null($salePointId) && !is_string($salePointId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salePointId, true), gettype($salePointId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($salePointId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $salePointId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($salePointId, true)), __LINE__);
        }
        if (is_null($salePointId) || (is_array($salePointId) && empty($salePointId))) {
            unset($this->SalePointId);
        } else {
            $this->SalePointId = $salePointId;
        }
        return $this;
    }
    /**
     * Get Scenario value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getScenario()
    {
        return isset($this->Scenario) ? $this->Scenario : null;
    }
    /**
     * Set Scenario value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $scenario
     * @return \patest\StructType\GetMergedPdfDocumentsAsStreamRequest
     */
    public function setScenario($scenario = null)
    {
        // validation for constraint: string
        if (!is_null($scenario) && !is_string($scenario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scenario, true), gettype($scenario)), __LINE__);
        }
        if (is_null($scenario) || (is_array($scenario) && empty($scenario))) {
            unset($this->Scenario);
        } else {
            $this->Scenario = $scenario;
        }
        return $this;
    }
    /**
     * Get SpoolGroupId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpoolGroupId()
    {
        return isset($this->SpoolGroupId) ? $this->SpoolGroupId : null;
    }
    /**
     * Set SpoolGroupId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $spoolGroupId
     * @return \patest\StructType\GetMergedPdfDocumentsAsStreamRequest
     */
    public function setSpoolGroupId($spoolGroupId = null)
    {
        // validation for constraint: string
        if (!is_null($spoolGroupId) && !is_string($spoolGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spoolGroupId, true), gettype($spoolGroupId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($spoolGroupId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $spoolGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($spoolGroupId, true)), __LINE__);
        }
        if (is_null($spoolGroupId) || (is_array($spoolGroupId) && empty($spoolGroupId))) {
            unset($this->SpoolGroupId);
        } else {
            $this->SpoolGroupId = $spoolGroupId;
        }
        return $this;
    }
    /**
     * Get TimeInterval value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTimeInterval()
    {
        return isset($this->TimeInterval) ? $this->TimeInterval : null;
    }
    /**
     * Set TimeInterval value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $timeInterval
     * @return \patest\StructType\GetMergedPdfDocumentsAsStreamRequest
     */
    public function setTimeInterval($timeInterval = null)
    {
        // validation for constraint: string
        if (!is_null($timeInterval) && !is_string($timeInterval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeInterval, true), gettype($timeInterval)), __LINE__);
        }
        // validation for constraint: maxInclusive(P10675199DT2H48M5.4775807S)
        if (!is_null($timeInterval) && false === mb_strpos($timeInterval, '-') && ($time = (string) time()) && \DateTime::createFromFormat('U', $time)->add(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', str_replace('-', '', $timeInterval)))) > \DateTime::createFromFormat('U', $time)->add(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', 'P10675199DT2H48M5.4775807S')))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be chronologically less than or equal to P10675199DT2H48M5.4775807S', var_export($timeInterval, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-P10675199DT2H48M5.4775808S)
        if (!is_null($timeInterval) && false !== mb_strpos($timeInterval, '-') && ($time = (string) time()) && \DateTime::createFromFormat('U', $time)->sub(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', str_replace('-', '', $timeInterval)))) < \DateTime::createFromFormat('U', $time)->sub(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', 'P10675199DT2H48M5.4775808S')))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be chronologically greater than or equal to -P10675199DT2H48M5.4775808S', var_export($timeInterval, true)), __LINE__);
        }
        // validation for constraint: pattern(\-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?)
        if (!is_null($timeInterval) && !preg_match('/\\-?P(\\d*D)?(T(\\d*H)?(\\d*M)?(\\d*(\\.\\d*)?S)?)?/', $timeInterval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?', var_export($timeInterval, true)), __LINE__);
        }
        if (is_null($timeInterval) || (is_array($timeInterval) && empty($timeInterval))) {
            unset($this->TimeInterval);
        } else {
            $this->TimeInterval = $timeInterval;
        }
        return $this;
    }
    /**
     * Get UserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserId()
    {
        return isset($this->UserId) ? $this->UserId : null;
    }
    /**
     * Set UserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userId
     * @return \patest\StructType\GetMergedPdfDocumentsAsStreamRequest
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($userId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($userId, true)), __LINE__);
        }
        if (is_null($userId) || (is_array($userId) && empty($userId))) {
            unset($this->UserId);
        } else {
            $this->UserId = $userId;
        }
        return $this;
    }
}
