<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetLinkedClientsRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetLinkedClientsRequest
 * @subpackage Structs
 */
class GetLinkedClientsRequest extends AbstractStructBase
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The CrmIdFilter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CrmIdFilter;
    /**
     * The IncludeClientImages
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeClientImages;
    /**
     * The IncludeTemporaryRelations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeTemporaryRelations;
    /**
     * The LastCRMId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastCRMId;
    /**
     * The MaxPageSize
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MaxPageSize;
    /**
     * The NameFilter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NameFilter;
    /**
     * The OrderBy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrderBy;
    /**
     * Constructor method for GetLinkedClientsRequest
     * @uses GetLinkedClientsRequest::setClientId()
     * @uses GetLinkedClientsRequest::setCrmIdFilter()
     * @uses GetLinkedClientsRequest::setIncludeClientImages()
     * @uses GetLinkedClientsRequest::setIncludeTemporaryRelations()
     * @uses GetLinkedClientsRequest::setLastCRMId()
     * @uses GetLinkedClientsRequest::setMaxPageSize()
     * @uses GetLinkedClientsRequest::setNameFilter()
     * @uses GetLinkedClientsRequest::setOrderBy()
     * @param string $clientId
     * @param string $crmIdFilter
     * @param bool $includeClientImages
     * @param bool $includeTemporaryRelations
     * @param string $lastCRMId
     * @param int $maxPageSize
     * @param string $nameFilter
     * @param string $orderBy
     */
    public function __construct($clientId = null, $crmIdFilter = null, $includeClientImages = null, $includeTemporaryRelations = null, $lastCRMId = null, $maxPageSize = null, $nameFilter = null, $orderBy = null)
    {
        $this
            ->setClientId($clientId)
            ->setCrmIdFilter($crmIdFilter)
            ->setIncludeClientImages($includeClientImages)
            ->setIncludeTemporaryRelations($includeTemporaryRelations)
            ->setLastCRMId($lastCRMId)
            ->setMaxPageSize($maxPageSize)
            ->setNameFilter($nameFilter)
            ->setOrderBy($orderBy);
    }
    /**
     * Get ClientId value
     * @return string|null
     */
    public function getClientId()
    {
        return $this->ClientId;
    }
    /**
     * Set ClientId value
     * @param string $clientId
     * @return \patest\StructType\GetLinkedClientsRequest
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        $this->ClientId = $clientId;
        return $this;
    }
    /**
     * Get CrmIdFilter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCrmIdFilter()
    {
        return isset($this->CrmIdFilter) ? $this->CrmIdFilter : null;
    }
    /**
     * Set CrmIdFilter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $crmIdFilter
     * @return \patest\StructType\GetLinkedClientsRequest
     */
    public function setCrmIdFilter($crmIdFilter = null)
    {
        // validation for constraint: string
        if (!is_null($crmIdFilter) && !is_string($crmIdFilter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($crmIdFilter, true), gettype($crmIdFilter)), __LINE__);
        }
        if (is_null($crmIdFilter) || (is_array($crmIdFilter) && empty($crmIdFilter))) {
            unset($this->CrmIdFilter);
        } else {
            $this->CrmIdFilter = $crmIdFilter;
        }
        return $this;
    }
    /**
     * Get IncludeClientImages value
     * @return bool|null
     */
    public function getIncludeClientImages()
    {
        return $this->IncludeClientImages;
    }
    /**
     * Set IncludeClientImages value
     * @param bool $includeClientImages
     * @return \patest\StructType\GetLinkedClientsRequest
     */
    public function setIncludeClientImages($includeClientImages = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeClientImages) && !is_bool($includeClientImages)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeClientImages, true), gettype($includeClientImages)), __LINE__);
        }
        $this->IncludeClientImages = $includeClientImages;
        return $this;
    }
    /**
     * Get IncludeTemporaryRelations value
     * @return bool|null
     */
    public function getIncludeTemporaryRelations()
    {
        return $this->IncludeTemporaryRelations;
    }
    /**
     * Set IncludeTemporaryRelations value
     * @param bool $includeTemporaryRelations
     * @return \patest\StructType\GetLinkedClientsRequest
     */
    public function setIncludeTemporaryRelations($includeTemporaryRelations = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeTemporaryRelations) && !is_bool($includeTemporaryRelations)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeTemporaryRelations, true), gettype($includeTemporaryRelations)), __LINE__);
        }
        $this->IncludeTemporaryRelations = $includeTemporaryRelations;
        return $this;
    }
    /**
     * Get LastCRMId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastCRMId()
    {
        return isset($this->LastCRMId) ? $this->LastCRMId : null;
    }
    /**
     * Set LastCRMId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastCRMId
     * @return \patest\StructType\GetLinkedClientsRequest
     */
    public function setLastCRMId($lastCRMId = null)
    {
        // validation for constraint: string
        if (!is_null($lastCRMId) && !is_string($lastCRMId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastCRMId, true), gettype($lastCRMId)), __LINE__);
        }
        if (is_null($lastCRMId) || (is_array($lastCRMId) && empty($lastCRMId))) {
            unset($this->LastCRMId);
        } else {
            $this->LastCRMId = $lastCRMId;
        }
        return $this;
    }
    /**
     * Get MaxPageSize value
     * @return int|null
     */
    public function getMaxPageSize()
    {
        return $this->MaxPageSize;
    }
    /**
     * Set MaxPageSize value
     * @param int $maxPageSize
     * @return \patest\StructType\GetLinkedClientsRequest
     */
    public function setMaxPageSize($maxPageSize = null)
    {
        // validation for constraint: int
        if (!is_null($maxPageSize) && !(is_int($maxPageSize) || ctype_digit($maxPageSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxPageSize, true), gettype($maxPageSize)), __LINE__);
        }
        $this->MaxPageSize = $maxPageSize;
        return $this;
    }
    /**
     * Get NameFilter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNameFilter()
    {
        return isset($this->NameFilter) ? $this->NameFilter : null;
    }
    /**
     * Set NameFilter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nameFilter
     * @return \patest\StructType\GetLinkedClientsRequest
     */
    public function setNameFilter($nameFilter = null)
    {
        // validation for constraint: string
        if (!is_null($nameFilter) && !is_string($nameFilter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nameFilter, true), gettype($nameFilter)), __LINE__);
        }
        if (is_null($nameFilter) || (is_array($nameFilter) && empty($nameFilter))) {
            unset($this->NameFilter);
        } else {
            $this->NameFilter = $nameFilter;
        }
        return $this;
    }
    /**
     * Get OrderBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderBy()
    {
        return isset($this->OrderBy) ? $this->OrderBy : null;
    }
    /**
     * Set OrderBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderBy
     * @return \patest\StructType\GetLinkedClientsRequest
     */
    public function setOrderBy($orderBy = null)
    {
        // validation for constraint: string
        if (!is_null($orderBy) && !is_string($orderBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderBy, true), gettype($orderBy)), __LINE__);
        }
        if (is_null($orderBy) || (is_array($orderBy) && empty($orderBy))) {
            unset($this->OrderBy);
        } else {
            $this->OrderBy = $orderBy;
        }
        return $this;
    }
}
