<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetGenresByShowId-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetGenresByShowId-Request
 * @subpackage Structs
 */
class GetGenresByShowId_Request extends ExtensibleDataContract
{
    /**
     * The ShowId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ShowId;
    /**
     * Constructor method for GetGenresByShowId-Request
     * @uses GetGenresByShowId_Request::setShowId()
     * @param string $showId
     */
    public function __construct($showId = null)
    {
        $this
            ->setShowId($showId);
    }
    /**
     * Get ShowId value
     * @return string|null
     */
    public function getShowId()
    {
        return $this->ShowId;
    }
    /**
     * Set ShowId value
     * @param string $showId
     * @return \patest\StructType\GetGenresByShowId_Request
     */
    public function setShowId($showId = null)
    {
        // validation for constraint: string
        if (!is_null($showId) && !is_string($showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showId, true), gettype($showId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($showId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($showId, true)), __LINE__);
        }
        $this->ShowId = $showId;
        return $this;
    }
}
