<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetExtendedTicketInfoRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetExtendedTicketInfoRequest
 * @subpackage Structs
 */
class GetExtendedTicketInfoRequest extends AbstractStructBase
{
    /**
     * The ExtendedFields
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string[]
     */
    public $ExtendedFields;
    /**
     * The TicketIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $TicketIds;
    /**
     * Constructor method for GetExtendedTicketInfoRequest
     * @uses GetExtendedTicketInfoRequest::setExtendedFields()
     * @uses GetExtendedTicketInfoRequest::setTicketIds()
     * @param string[] $extendedFields
     * @param \patest\ArrayType\ArrayOfguid $ticketIds
     */
    public function __construct(array $extendedFields = array(), \patest\ArrayType\ArrayOfguid $ticketIds = null)
    {
        $this
            ->setExtendedFields($extendedFields)
            ->setTicketIds($ticketIds);
    }
    /**
     * Get ExtendedFields value
     * @return string[]|null
     */
    public function getExtendedFields()
    {
        return $this->ExtendedFields;
    }
    /**
     * This method is responsible for validating the values passed to the setExtendedFields method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExtendedFields method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExtendedFieldsForArrayConstraintsFromSetExtendedFields(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getExtendedTicketInfoRequestExtendedFieldsItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\ExtendedFields::valueIsValid($getExtendedTicketInfoRequestExtendedFieldsItem)) {
                $invalidValues[] = is_object($getExtendedTicketInfoRequestExtendedFieldsItem) ? get_class($getExtendedTicketInfoRequestExtendedFieldsItem) : sprintf('%s(%s)', gettype($getExtendedTicketInfoRequestExtendedFieldsItem), var_export($getExtendedTicketInfoRequestExtendedFieldsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ExtendedFields', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\ExtendedFields::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ExtendedFields value
     * @uses \patest\EnumType\ExtendedFields::valueIsValid()
     * @uses \patest\EnumType\ExtendedFields::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $extendedFields
     * @return \patest\StructType\GetExtendedTicketInfoRequest
     */
    public function setExtendedFields(array $extendedFields = array())
    {
        // validation for constraint: list
        if ('' !== ($extendedFieldsArrayErrorMessage = self::validateExtendedFieldsForArrayConstraintsFromSetExtendedFields($extendedFields))) {
            throw new \InvalidArgumentException($extendedFieldsArrayErrorMessage, __LINE__);
        }
        $this->ExtendedFields = is_array($extendedFields) ? implode(' ', $extendedFields) : null;
        return $this;
    }
    /**
     * Get TicketIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getTicketIds()
    {
        return isset($this->TicketIds) ? $this->TicketIds : null;
    }
    /**
     * Set TicketIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $ticketIds
     * @return \patest\StructType\GetExtendedTicketInfoRequest
     */
    public function setTicketIds(\patest\ArrayType\ArrayOfguid $ticketIds = null)
    {
        if (is_null($ticketIds) || (is_array($ticketIds) && empty($ticketIds))) {
            unset($this->TicketIds);
        } else {
            $this->TicketIds = $ticketIds;
        }
        return $this;
    }
}
