<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetEventReservations-Response StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetEventReservations-Response
 * @subpackage Structs
 */
class GetEventReservations_Response extends ExtensibleDataContract
{
    /**
     * The Reservations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfReservedTicket
     */
    public $Reservations;
    /**
     * Constructor method for GetEventReservations-Response
     * @uses GetEventReservations_Response::setReservations()
     * @param \patest\ArrayType\ArrayOfReservedTicket $reservations
     */
    public function __construct(\patest\ArrayType\ArrayOfReservedTicket $reservations = null)
    {
        $this
            ->setReservations($reservations);
    }
    /**
     * Get Reservations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfReservedTicket|null
     */
    public function getReservations()
    {
        return isset($this->Reservations) ? $this->Reservations : null;
    }
    /**
     * Set Reservations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfReservedTicket $reservations
     * @return \patest\StructType\GetEventReservations_Response
     */
    public function setReservations(\patest\ArrayType\ArrayOfReservedTicket $reservations = null)
    {
        if (is_null($reservations) || (is_array($reservations) && empty($reservations))) {
            unset($this->Reservations);
        } else {
            $this->Reservations = $reservations;
        }
        return $this;
    }
}
