<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetEventPriceLevelsAndAvailability-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetEventPriceLevelsAndAvailability-Request
 * @subpackage Structs
 */
class GetEventPriceLevelsAndAvailability_Request extends ExtensibleDataContract
{
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The OnlyHospitality
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $OnlyHospitality;
    /**
     * Constructor method for GetEventPriceLevelsAndAvailability-Request
     * @uses GetEventPriceLevelsAndAvailability_Request::setEventId()
     * @uses GetEventPriceLevelsAndAvailability_Request::setOnlyHospitality()
     * @param string $eventId
     * @param bool $onlyHospitality
     */
    public function __construct($eventId = null, $onlyHospitality = null)
    {
        $this
            ->setEventId($eventId)
            ->setOnlyHospitality($onlyHospitality);
    }
    /**
     * Get EventId value
     * @return string|null
     */
    public function getEventId()
    {
        return $this->EventId;
    }
    /**
     * Set EventId value
     * @param string $eventId
     * @return \patest\StructType\GetEventPriceLevelsAndAvailability_Request
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        $this->EventId = $eventId;
        return $this;
    }
    /**
     * Get OnlyHospitality value
     * @return bool|null
     */
    public function getOnlyHospitality()
    {
        return $this->OnlyHospitality;
    }
    /**
     * Set OnlyHospitality value
     * @param bool $onlyHospitality
     * @return \patest\StructType\GetEventPriceLevelsAndAvailability_Request
     */
    public function setOnlyHospitality($onlyHospitality = null)
    {
        // validation for constraint: boolean
        if (!is_null($onlyHospitality) && !is_bool($onlyHospitality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($onlyHospitality, true), gettype($onlyHospitality)), __LINE__);
        }
        $this->OnlyHospitality = $onlyHospitality;
        return $this;
    }
}
