<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetEventInfoFromSgoRequest-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetEventInfoFromSgoRequest-Request
 * @subpackage Structs
 */
class GetEventInfoFromSgoRequest_Request extends ExtensibleDataContract
{
    /**
     * The EventIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $EventIds;
    /**
     * The IsTryToLogEventStatusToDataDog
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsTryToLogEventStatusToDataDog;
    /**
     * Constructor method for GetEventInfoFromSgoRequest-Request
     * @uses GetEventInfoFromSgoRequest_Request::setEventIds()
     * @uses GetEventInfoFromSgoRequest_Request::setIsTryToLogEventStatusToDataDog()
     * @param \patest\ArrayType\ArrayOfguid $eventIds
     * @param bool $isTryToLogEventStatusToDataDog
     */
    public function __construct(\patest\ArrayType\ArrayOfguid $eventIds = null, $isTryToLogEventStatusToDataDog = null)
    {
        $this
            ->setEventIds($eventIds)
            ->setIsTryToLogEventStatusToDataDog($isTryToLogEventStatusToDataDog);
    }
    /**
     * Get EventIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getEventIds()
    {
        return isset($this->EventIds) ? $this->EventIds : null;
    }
    /**
     * Set EventIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $eventIds
     * @return \patest\StructType\GetEventInfoFromSgoRequest_Request
     */
    public function setEventIds(\patest\ArrayType\ArrayOfguid $eventIds = null)
    {
        if (is_null($eventIds) || (is_array($eventIds) && empty($eventIds))) {
            unset($this->EventIds);
        } else {
            $this->EventIds = $eventIds;
        }
        return $this;
    }
    /**
     * Get IsTryToLogEventStatusToDataDog value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsTryToLogEventStatusToDataDog()
    {
        return isset($this->IsTryToLogEventStatusToDataDog) ? $this->IsTryToLogEventStatusToDataDog : null;
    }
    /**
     * Set IsTryToLogEventStatusToDataDog value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isTryToLogEventStatusToDataDog
     * @return \patest\StructType\GetEventInfoFromSgoRequest_Request
     */
    public function setIsTryToLogEventStatusToDataDog($isTryToLogEventStatusToDataDog = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTryToLogEventStatusToDataDog) && !is_bool($isTryToLogEventStatusToDataDog)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTryToLogEventStatusToDataDog, true), gettype($isTryToLogEventStatusToDataDog)), __LINE__);
        }
        if (is_null($isTryToLogEventStatusToDataDog) || (is_array($isTryToLogEventStatusToDataDog) && empty($isTryToLogEventStatusToDataDog))) {
            unset($this->IsTryToLogEventStatusToDataDog);
        } else {
            $this->IsTryToLogEventStatusToDataDog = $isTryToLogEventStatusToDataDog;
        }
        return $this;
    }
}
