<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetEventDescription-Response StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetEventDescription-Response
 * @subpackage Structs
 */
class GetEventDescription_Response extends ExtensibleDataContract
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\EventDescription
     */
    public $Description;
    /**
     * The IsUnavailableForSpecifiedCoupon
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsUnavailableForSpecifiedCoupon;
    /**
     * Constructor method for GetEventDescription-Response
     * @uses GetEventDescription_Response::setDescription()
     * @uses GetEventDescription_Response::setIsUnavailableForSpecifiedCoupon()
     * @param \patest\StructType\EventDescription $description
     * @param bool $isUnavailableForSpecifiedCoupon
     */
    public function __construct(\patest\StructType\EventDescription $description = null, $isUnavailableForSpecifiedCoupon = null)
    {
        $this
            ->setDescription($description)
            ->setIsUnavailableForSpecifiedCoupon($isUnavailableForSpecifiedCoupon);
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\EventDescription|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\EventDescription $description
     * @return \patest\StructType\GetEventDescription_Response
     */
    public function setDescription(\patest\StructType\EventDescription $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get IsUnavailableForSpecifiedCoupon value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsUnavailableForSpecifiedCoupon()
    {
        return isset($this->IsUnavailableForSpecifiedCoupon) ? $this->IsUnavailableForSpecifiedCoupon : null;
    }
    /**
     * Set IsUnavailableForSpecifiedCoupon value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isUnavailableForSpecifiedCoupon
     * @return \patest\StructType\GetEventDescription_Response
     */
    public function setIsUnavailableForSpecifiedCoupon($isUnavailableForSpecifiedCoupon = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUnavailableForSpecifiedCoupon) && !is_bool($isUnavailableForSpecifiedCoupon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isUnavailableForSpecifiedCoupon, true), gettype($isUnavailableForSpecifiedCoupon)), __LINE__);
        }
        if (is_null($isUnavailableForSpecifiedCoupon) || (is_array($isUnavailableForSpecifiedCoupon) && empty($isUnavailableForSpecifiedCoupon))) {
            unset($this->IsUnavailableForSpecifiedCoupon);
        } else {
            $this->IsUnavailableForSpecifiedCoupon = $isUnavailableForSpecifiedCoupon;
        }
        return $this;
    }
}
