<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetEtlMonitoringDataResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetEtlMonitoringDataResponse
 * @subpackage Structs
 */
class GetEtlMonitoringDataResponse extends AbstractStructBase
{
    /**
     * The CanRunFullEtl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $CanRunFullEtl;
    /**
     * The CanRunIncrementalEtl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $CanRunIncrementalEtl;
    /**
     * The EtlProcess
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\EtlProcessStatus
     */
    public $EtlProcess;
    /**
     * The JobStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\JobStatus
     */
    public $JobStatus;
    /**
     * The Runs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfEtlRunSummary
     */
    public $Runs;
    /**
     * The Warnings
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfstring
     */
    public $Warnings;
    /**
     * Constructor method for GetEtlMonitoringDataResponse
     * @uses GetEtlMonitoringDataResponse::setCanRunFullEtl()
     * @uses GetEtlMonitoringDataResponse::setCanRunIncrementalEtl()
     * @uses GetEtlMonitoringDataResponse::setEtlProcess()
     * @uses GetEtlMonitoringDataResponse::setJobStatus()
     * @uses GetEtlMonitoringDataResponse::setRuns()
     * @uses GetEtlMonitoringDataResponse::setWarnings()
     * @param bool $canRunFullEtl
     * @param bool $canRunIncrementalEtl
     * @param \patest\StructType\EtlProcessStatus $etlProcess
     * @param \patest\StructType\JobStatus $jobStatus
     * @param \patest\ArrayType\ArrayOfEtlRunSummary $runs
     * @param \patest\ArrayType\ArrayOfstring $warnings
     */
    public function __construct($canRunFullEtl = null, $canRunIncrementalEtl = null, \patest\StructType\EtlProcessStatus $etlProcess = null, \patest\StructType\JobStatus $jobStatus = null, \patest\ArrayType\ArrayOfEtlRunSummary $runs = null, \patest\ArrayType\ArrayOfstring $warnings = null)
    {
        $this
            ->setCanRunFullEtl($canRunFullEtl)
            ->setCanRunIncrementalEtl($canRunIncrementalEtl)
            ->setEtlProcess($etlProcess)
            ->setJobStatus($jobStatus)
            ->setRuns($runs)
            ->setWarnings($warnings);
    }
    /**
     * Get CanRunFullEtl value
     * @return bool|null
     */
    public function getCanRunFullEtl()
    {
        return $this->CanRunFullEtl;
    }
    /**
     * Set CanRunFullEtl value
     * @param bool $canRunFullEtl
     * @return \patest\StructType\GetEtlMonitoringDataResponse
     */
    public function setCanRunFullEtl($canRunFullEtl = null)
    {
        // validation for constraint: boolean
        if (!is_null($canRunFullEtl) && !is_bool($canRunFullEtl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canRunFullEtl, true), gettype($canRunFullEtl)), __LINE__);
        }
        $this->CanRunFullEtl = $canRunFullEtl;
        return $this;
    }
    /**
     * Get CanRunIncrementalEtl value
     * @return bool|null
     */
    public function getCanRunIncrementalEtl()
    {
        return $this->CanRunIncrementalEtl;
    }
    /**
     * Set CanRunIncrementalEtl value
     * @param bool $canRunIncrementalEtl
     * @return \patest\StructType\GetEtlMonitoringDataResponse
     */
    public function setCanRunIncrementalEtl($canRunIncrementalEtl = null)
    {
        // validation for constraint: boolean
        if (!is_null($canRunIncrementalEtl) && !is_bool($canRunIncrementalEtl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canRunIncrementalEtl, true), gettype($canRunIncrementalEtl)), __LINE__);
        }
        $this->CanRunIncrementalEtl = $canRunIncrementalEtl;
        return $this;
    }
    /**
     * Get EtlProcess value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\EtlProcessStatus|null
     */
    public function getEtlProcess()
    {
        return isset($this->EtlProcess) ? $this->EtlProcess : null;
    }
    /**
     * Set EtlProcess value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\EtlProcessStatus $etlProcess
     * @return \patest\StructType\GetEtlMonitoringDataResponse
     */
    public function setEtlProcess(\patest\StructType\EtlProcessStatus $etlProcess = null)
    {
        if (is_null($etlProcess) || (is_array($etlProcess) && empty($etlProcess))) {
            unset($this->EtlProcess);
        } else {
            $this->EtlProcess = $etlProcess;
        }
        return $this;
    }
    /**
     * Get JobStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\JobStatus|null
     */
    public function getJobStatus()
    {
        return isset($this->JobStatus) ? $this->JobStatus : null;
    }
    /**
     * Set JobStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\JobStatus $jobStatus
     * @return \patest\StructType\GetEtlMonitoringDataResponse
     */
    public function setJobStatus(\patest\StructType\JobStatus $jobStatus = null)
    {
        if (is_null($jobStatus) || (is_array($jobStatus) && empty($jobStatus))) {
            unset($this->JobStatus);
        } else {
            $this->JobStatus = $jobStatus;
        }
        return $this;
    }
    /**
     * Get Runs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfEtlRunSummary|null
     */
    public function getRuns()
    {
        return isset($this->Runs) ? $this->Runs : null;
    }
    /**
     * Set Runs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfEtlRunSummary $runs
     * @return \patest\StructType\GetEtlMonitoringDataResponse
     */
    public function setRuns(\patest\ArrayType\ArrayOfEtlRunSummary $runs = null)
    {
        if (is_null($runs) || (is_array($runs) && empty($runs))) {
            unset($this->Runs);
        } else {
            $this->Runs = $runs;
        }
        return $this;
    }
    /**
     * Get Warnings value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfstring|null
     */
    public function getWarnings()
    {
        return isset($this->Warnings) ? $this->Warnings : null;
    }
    /**
     * Set Warnings value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfstring $warnings
     * @return \patest\StructType\GetEtlMonitoringDataResponse
     */
    public function setWarnings(\patest\ArrayType\ArrayOfstring $warnings = null)
    {
        if (is_null($warnings) || (is_array($warnings) && empty($warnings))) {
            unset($this->Warnings);
        } else {
            $this->Warnings = $warnings;
        }
        return $this;
    }
}
