<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetEntityManagementQueryTokenContextResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetEntityManagementQueryTokenContextResponse
 * @subpackage Structs
 */
class GetEntityManagementQueryTokenContextResponse extends ExtensibleDataContract
{
    /**
     * The QueryTokenContext
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\QueryTokenContext
     */
    public $QueryTokenContext;
    /**
     * The QueryTokenLastHitDateTimeUtc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $QueryTokenLastHitDateTimeUtc;
    /**
     * Constructor method for GetEntityManagementQueryTokenContextResponse
     * @uses GetEntityManagementQueryTokenContextResponse::setQueryTokenContext()
     * @uses GetEntityManagementQueryTokenContextResponse::setQueryTokenLastHitDateTimeUtc()
     * @param \patest\StructType\QueryTokenContext $queryTokenContext
     * @param string $queryTokenLastHitDateTimeUtc
     */
    public function __construct(\patest\StructType\QueryTokenContext $queryTokenContext = null, $queryTokenLastHitDateTimeUtc = null)
    {
        $this
            ->setQueryTokenContext($queryTokenContext)
            ->setQueryTokenLastHitDateTimeUtc($queryTokenLastHitDateTimeUtc);
    }
    /**
     * Get QueryTokenContext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\QueryTokenContext|null
     */
    public function getQueryTokenContext()
    {
        return isset($this->QueryTokenContext) ? $this->QueryTokenContext : null;
    }
    /**
     * Set QueryTokenContext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\QueryTokenContext $queryTokenContext
     * @return \patest\StructType\GetEntityManagementQueryTokenContextResponse
     */
    public function setQueryTokenContext(\patest\StructType\QueryTokenContext $queryTokenContext = null)
    {
        if (is_null($queryTokenContext) || (is_array($queryTokenContext) && empty($queryTokenContext))) {
            unset($this->QueryTokenContext);
        } else {
            $this->QueryTokenContext = $queryTokenContext;
        }
        return $this;
    }
    /**
     * Get QueryTokenLastHitDateTimeUtc value
     * @return string|null
     */
    public function getQueryTokenLastHitDateTimeUtc()
    {
        return $this->QueryTokenLastHitDateTimeUtc;
    }
    /**
     * Set QueryTokenLastHitDateTimeUtc value
     * @param string $queryTokenLastHitDateTimeUtc
     * @return \patest\StructType\GetEntityManagementQueryTokenContextResponse
     */
    public function setQueryTokenLastHitDateTimeUtc($queryTokenLastHitDateTimeUtc = null)
    {
        // validation for constraint: string
        if (!is_null($queryTokenLastHitDateTimeUtc) && !is_string($queryTokenLastHitDateTimeUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($queryTokenLastHitDateTimeUtc, true), gettype($queryTokenLastHitDateTimeUtc)), __LINE__);
        }
        $this->QueryTokenLastHitDateTimeUtc = $queryTokenLastHitDateTimeUtc;
        return $this;
    }
}
