<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCustomSeatPricesRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetCustomSeatPricesRequest
 * @subpackage Structs
 */
class GetCustomSeatPricesRequest extends ExtensibleDataContract
{
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The SeatIdsByAreaId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfKeyValueOfguidArrayOfintox8ieOcg
     */
    public $SeatIdsByAreaId;
    /**
     * Constructor method for GetCustomSeatPricesRequest
     * @uses GetCustomSeatPricesRequest::setEventId()
     * @uses GetCustomSeatPricesRequest::setSeatIdsByAreaId()
     * @param string $eventId
     * @param \patest\ArrayType\ArrayOfKeyValueOfguidArrayOfintox8ieOcg $seatIdsByAreaId
     */
    public function __construct($eventId = null, \patest\ArrayType\ArrayOfKeyValueOfguidArrayOfintox8ieOcg $seatIdsByAreaId = null)
    {
        $this
            ->setEventId($eventId)
            ->setSeatIdsByAreaId($seatIdsByAreaId);
    }
    /**
     * Get EventId value
     * @return string|null
     */
    public function getEventId()
    {
        return $this->EventId;
    }
    /**
     * Set EventId value
     * @param string $eventId
     * @return \patest\StructType\GetCustomSeatPricesRequest
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        $this->EventId = $eventId;
        return $this;
    }
    /**
     * Get SeatIdsByAreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfKeyValueOfguidArrayOfintox8ieOcg|null
     */
    public function getSeatIdsByAreaId()
    {
        return isset($this->SeatIdsByAreaId) ? $this->SeatIdsByAreaId : null;
    }
    /**
     * Set SeatIdsByAreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfKeyValueOfguidArrayOfintox8ieOcg $seatIdsByAreaId
     * @return \patest\StructType\GetCustomSeatPricesRequest
     */
    public function setSeatIdsByAreaId(\patest\ArrayType\ArrayOfKeyValueOfguidArrayOfintox8ieOcg $seatIdsByAreaId = null)
    {
        if (is_null($seatIdsByAreaId) || (is_array($seatIdsByAreaId) && empty($seatIdsByAreaId))) {
            unset($this->SeatIdsByAreaId);
        } else {
            $this->SeatIdsByAreaId = $seatIdsByAreaId;
        }
        return $this;
    }
}
