<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCurrentShiftResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetCurrentShiftResponse
 * @subpackage Structs
 */
class GetCurrentShiftResponse extends AbstractStructBase
{
    /**
     * The CurrentShift
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Sales_Shift
     */
    public $CurrentShift;
    /**
     * The DefaultStartingAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\Money
     */
    public $DefaultStartingAmount;
    /**
     * The MustToClosePreviousShift
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $MustToClosePreviousShift;
    /**
     * The MustToSetStartingAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $MustToSetStartingAmount;
    /**
     * The OpenedShiftsData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfOpenedShiftData
     */
    public $OpenedShiftsData;
    /**
     * Constructor method for GetCurrentShiftResponse
     * @uses GetCurrentShiftResponse::setCurrentShift()
     * @uses GetCurrentShiftResponse::setDefaultStartingAmount()
     * @uses GetCurrentShiftResponse::setMustToClosePreviousShift()
     * @uses GetCurrentShiftResponse::setMustToSetStartingAmount()
     * @uses GetCurrentShiftResponse::setOpenedShiftsData()
     * @param \patest\StructType\Sales_Shift $currentShift
     * @param \patest\StructType\Money $defaultStartingAmount
     * @param bool $mustToClosePreviousShift
     * @param bool $mustToSetStartingAmount
     * @param \patest\ArrayType\ArrayOfOpenedShiftData $openedShiftsData
     */
    public function __construct(\patest\StructType\Sales_Shift $currentShift = null, \patest\StructType\Money $defaultStartingAmount = null, $mustToClosePreviousShift = null, $mustToSetStartingAmount = null, \patest\ArrayType\ArrayOfOpenedShiftData $openedShiftsData = null)
    {
        $this
            ->setCurrentShift($currentShift)
            ->setDefaultStartingAmount($defaultStartingAmount)
            ->setMustToClosePreviousShift($mustToClosePreviousShift)
            ->setMustToSetStartingAmount($mustToSetStartingAmount)
            ->setOpenedShiftsData($openedShiftsData);
    }
    /**
     * Get CurrentShift value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Sales_Shift|null
     */
    public function getCurrentShift()
    {
        return isset($this->CurrentShift) ? $this->CurrentShift : null;
    }
    /**
     * Set CurrentShift value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Sales_Shift $currentShift
     * @return \patest\StructType\GetCurrentShiftResponse
     */
    public function setCurrentShift(\patest\StructType\Sales_Shift $currentShift = null)
    {
        if (is_null($currentShift) || (is_array($currentShift) && empty($currentShift))) {
            unset($this->CurrentShift);
        } else {
            $this->CurrentShift = $currentShift;
        }
        return $this;
    }
    /**
     * Get DefaultStartingAmount value
     * @return \patest\StructType\Money|null
     */
    public function getDefaultStartingAmount()
    {
        return $this->DefaultStartingAmount;
    }
    /**
     * Set DefaultStartingAmount value
     * @param \patest\StructType\Money $defaultStartingAmount
     * @return \patest\StructType\GetCurrentShiftResponse
     */
    public function setDefaultStartingAmount(\patest\StructType\Money $defaultStartingAmount = null)
    {
        $this->DefaultStartingAmount = $defaultStartingAmount;
        return $this;
    }
    /**
     * Get MustToClosePreviousShift value
     * @return bool|null
     */
    public function getMustToClosePreviousShift()
    {
        return $this->MustToClosePreviousShift;
    }
    /**
     * Set MustToClosePreviousShift value
     * @param bool $mustToClosePreviousShift
     * @return \patest\StructType\GetCurrentShiftResponse
     */
    public function setMustToClosePreviousShift($mustToClosePreviousShift = null)
    {
        // validation for constraint: boolean
        if (!is_null($mustToClosePreviousShift) && !is_bool($mustToClosePreviousShift)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mustToClosePreviousShift, true), gettype($mustToClosePreviousShift)), __LINE__);
        }
        $this->MustToClosePreviousShift = $mustToClosePreviousShift;
        return $this;
    }
    /**
     * Get MustToSetStartingAmount value
     * @return bool|null
     */
    public function getMustToSetStartingAmount()
    {
        return $this->MustToSetStartingAmount;
    }
    /**
     * Set MustToSetStartingAmount value
     * @param bool $mustToSetStartingAmount
     * @return \patest\StructType\GetCurrentShiftResponse
     */
    public function setMustToSetStartingAmount($mustToSetStartingAmount = null)
    {
        // validation for constraint: boolean
        if (!is_null($mustToSetStartingAmount) && !is_bool($mustToSetStartingAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mustToSetStartingAmount, true), gettype($mustToSetStartingAmount)), __LINE__);
        }
        $this->MustToSetStartingAmount = $mustToSetStartingAmount;
        return $this;
    }
    /**
     * Get OpenedShiftsData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfOpenedShiftData|null
     */
    public function getOpenedShiftsData()
    {
        return isset($this->OpenedShiftsData) ? $this->OpenedShiftsData : null;
    }
    /**
     * Set OpenedShiftsData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfOpenedShiftData $openedShiftsData
     * @return \patest\StructType\GetCurrentShiftResponse
     */
    public function setOpenedShiftsData(\patest\ArrayType\ArrayOfOpenedShiftData $openedShiftsData = null)
    {
        if (is_null($openedShiftsData) || (is_array($openedShiftsData) && empty($openedShiftsData))) {
            unset($this->OpenedShiftsData);
        } else {
            $this->OpenedShiftsData = $openedShiftsData;
        }
        return $this;
    }
}
