<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCrmIdForCardSwipe-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetCrmIdForCardSwipe-Request
 * @subpackage Structs
 */
class GetCrmIdForCardSwipe_Request extends AbstractStructBase
{
    /**
     * The StripeData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StripeData;
    /**
     * Constructor method for GetCrmIdForCardSwipe-Request
     * @uses GetCrmIdForCardSwipe_Request::setStripeData()
     * @param string $stripeData
     */
    public function __construct($stripeData = null)
    {
        $this
            ->setStripeData($stripeData);
    }
    /**
     * Get StripeData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStripeData()
    {
        return isset($this->StripeData) ? $this->StripeData : null;
    }
    /**
     * Set StripeData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stripeData
     * @return \patest\StructType\GetCrmIdForCardSwipe_Request
     */
    public function setStripeData($stripeData = null)
    {
        // validation for constraint: string
        if (!is_null($stripeData) && !is_string($stripeData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stripeData, true), gettype($stripeData)), __LINE__);
        }
        if (is_null($stripeData) || (is_array($stripeData) && empty($stripeData))) {
            unset($this->StripeData);
        } else {
            $this->StripeData = $stripeData;
        }
        return $this;
    }
}
