<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetContextSalePointConfigurationRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetContextSalePointConfigurationRequest
 * @subpackage Structs
 */
class GetContextSalePointConfigurationRequest extends ExtensibleDataContract
{
    /**
     * The ClientKind
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientKind;
    /**
     * Constructor method for GetContextSalePointConfigurationRequest
     * @uses GetContextSalePointConfigurationRequest::setClientKind()
     * @param string $clientKind
     */
    public function __construct($clientKind = null)
    {
        $this
            ->setClientKind($clientKind);
    }
    /**
     * Get ClientKind value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientKind()
    {
        return isset($this->ClientKind) ? $this->ClientKind : null;
    }
    /**
     * Set ClientKind value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientKind
     * @return \patest\StructType\GetContextSalePointConfigurationRequest
     */
    public function setClientKind($clientKind = null)
    {
        // validation for constraint: string
        if (!is_null($clientKind) && !is_string($clientKind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientKind, true), gettype($clientKind)), __LINE__);
        }
        if (is_null($clientKind) || (is_array($clientKind) && empty($clientKind))) {
            unset($this->ClientKind);
        } else {
            $this->ClientKind = $clientKind;
        }
        return $this;
    }
}
