<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetClientEventTicketsResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetClientEventTicketsResponse
 * @subpackage Structs
 */
class GetClientEventTicketsResponse extends AbstractStructBase
{
    /**
     * The Genres
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfGenreDescription
     */
    public $Genres;
    /**
     * The IsThereMoreData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsThereMoreData;
    /**
     * The NextPageToken
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NextPageToken;
    /**
     * The Tickets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfClientTicket
     */
    public $Tickets;
    /**
     * Constructor method for GetClientEventTicketsResponse
     * @uses GetClientEventTicketsResponse::setGenres()
     * @uses GetClientEventTicketsResponse::setIsThereMoreData()
     * @uses GetClientEventTicketsResponse::setNextPageToken()
     * @uses GetClientEventTicketsResponse::setTickets()
     * @param \patest\ArrayType\ArrayOfGenreDescription $genres
     * @param bool $isThereMoreData
     * @param string $nextPageToken
     * @param \patest\ArrayType\ArrayOfClientTicket $tickets
     */
    public function __construct(\patest\ArrayType\ArrayOfGenreDescription $genres = null, $isThereMoreData = null, $nextPageToken = null, \patest\ArrayType\ArrayOfClientTicket $tickets = null)
    {
        $this
            ->setGenres($genres)
            ->setIsThereMoreData($isThereMoreData)
            ->setNextPageToken($nextPageToken)
            ->setTickets($tickets);
    }
    /**
     * Get Genres value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfGenreDescription|null
     */
    public function getGenres()
    {
        return isset($this->Genres) ? $this->Genres : null;
    }
    /**
     * Set Genres value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfGenreDescription $genres
     * @return \patest\StructType\GetClientEventTicketsResponse
     */
    public function setGenres(\patest\ArrayType\ArrayOfGenreDescription $genres = null)
    {
        if (is_null($genres) || (is_array($genres) && empty($genres))) {
            unset($this->Genres);
        } else {
            $this->Genres = $genres;
        }
        return $this;
    }
    /**
     * Get IsThereMoreData value
     * @return bool|null
     */
    public function getIsThereMoreData()
    {
        return $this->IsThereMoreData;
    }
    /**
     * Set IsThereMoreData value
     * @param bool $isThereMoreData
     * @return \patest\StructType\GetClientEventTicketsResponse
     */
    public function setIsThereMoreData($isThereMoreData = null)
    {
        // validation for constraint: boolean
        if (!is_null($isThereMoreData) && !is_bool($isThereMoreData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isThereMoreData, true), gettype($isThereMoreData)), __LINE__);
        }
        $this->IsThereMoreData = $isThereMoreData;
        return $this;
    }
    /**
     * Get NextPageToken value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNextPageToken()
    {
        return isset($this->NextPageToken) ? $this->NextPageToken : null;
    }
    /**
     * Set NextPageToken value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nextPageToken
     * @return \patest\StructType\GetClientEventTicketsResponse
     */
    public function setNextPageToken($nextPageToken = null)
    {
        // validation for constraint: string
        if (!is_null($nextPageToken) && !is_string($nextPageToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nextPageToken, true), gettype($nextPageToken)), __LINE__);
        }
        if (is_null($nextPageToken) || (is_array($nextPageToken) && empty($nextPageToken))) {
            unset($this->NextPageToken);
        } else {
            $this->NextPageToken = $nextPageToken;
        }
        return $this;
    }
    /**
     * Get Tickets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfClientTicket|null
     */
    public function getTickets()
    {
        return isset($this->Tickets) ? $this->Tickets : null;
    }
    /**
     * Set Tickets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfClientTicket $tickets
     * @return \patest\StructType\GetClientEventTicketsResponse
     */
    public function setTickets(\patest\ArrayType\ArrayOfClientTicket $tickets = null)
    {
        if (is_null($tickets) || (is_array($tickets) && empty($tickets))) {
            unset($this->Tickets);
        } else {
            $this->Tickets = $tickets;
        }
        return $this;
    }
}
