<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetClientEventTicketsRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetClientEventTicketsRequest
 * @subpackage Structs
 */
class GetClientEventTicketsRequest extends AbstractStructBase
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The EventGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventGuid;
    /**
     * The FromTicketLocalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $FromTicketLocalId;
    /**
     * The IncludeGenres
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IncludeGenres;
    /**
     * The IncludeNfc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IncludeNfc;
    /**
     * The IncludePurchasedByClientNonForwardedOwnedByRelatedUnderaged
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IncludePurchasedByClientNonForwardedOwnedByRelatedUnderaged;
    /**
     * The IncludeTicketsOfSpecificRelationshipType
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $IncludeTicketsOfSpecificRelationshipType;
    /**
     * The IncludeTicketsOfStronglyConnectedOwners
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IncludeTicketsOfStronglyConnectedOwners;
    /**
     * The MaxPageSize
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxPageSize;
    /**
     * The NextPageToken
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NextPageToken;
    /**
     * The StronglyRelatedClientsMaxAgeFilterForTicketList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $StronglyRelatedClientsMaxAgeFilterForTicketList;
    /**
     * Constructor method for GetClientEventTicketsRequest
     * @uses GetClientEventTicketsRequest::setClientId()
     * @uses GetClientEventTicketsRequest::setEventGuid()
     * @uses GetClientEventTicketsRequest::setFromTicketLocalId()
     * @uses GetClientEventTicketsRequest::setIncludeGenres()
     * @uses GetClientEventTicketsRequest::setIncludeNfc()
     * @uses GetClientEventTicketsRequest::setIncludePurchasedByClientNonForwardedOwnedByRelatedUnderaged()
     * @uses GetClientEventTicketsRequest::setIncludeTicketsOfSpecificRelationshipType()
     * @uses GetClientEventTicketsRequest::setIncludeTicketsOfStronglyConnectedOwners()
     * @uses GetClientEventTicketsRequest::setMaxPageSize()
     * @uses GetClientEventTicketsRequest::setNextPageToken()
     * @uses GetClientEventTicketsRequest::setStronglyRelatedClientsMaxAgeFilterForTicketList()
     * @param string $clientId
     * @param string $eventGuid
     * @param int $fromTicketLocalId
     * @param bool $includeGenres
     * @param bool $includeNfc
     * @param bool $includePurchasedByClientNonForwardedOwnedByRelatedUnderaged
     * @param string $includeTicketsOfSpecificRelationshipType
     * @param bool $includeTicketsOfStronglyConnectedOwners
     * @param int $maxPageSize
     * @param string $nextPageToken
     * @param int $stronglyRelatedClientsMaxAgeFilterForTicketList
     */
    public function __construct($clientId = null, $eventGuid = null, $fromTicketLocalId = null, $includeGenres = null, $includeNfc = null, $includePurchasedByClientNonForwardedOwnedByRelatedUnderaged = null, $includeTicketsOfSpecificRelationshipType = null, $includeTicketsOfStronglyConnectedOwners = null, $maxPageSize = null, $nextPageToken = null, $stronglyRelatedClientsMaxAgeFilterForTicketList = null)
    {
        $this
            ->setClientId($clientId)
            ->setEventGuid($eventGuid)
            ->setFromTicketLocalId($fromTicketLocalId)
            ->setIncludeGenres($includeGenres)
            ->setIncludeNfc($includeNfc)
            ->setIncludePurchasedByClientNonForwardedOwnedByRelatedUnderaged($includePurchasedByClientNonForwardedOwnedByRelatedUnderaged)
            ->setIncludeTicketsOfSpecificRelationshipType($includeTicketsOfSpecificRelationshipType)
            ->setIncludeTicketsOfStronglyConnectedOwners($includeTicketsOfStronglyConnectedOwners)
            ->setMaxPageSize($maxPageSize)
            ->setNextPageToken($nextPageToken)
            ->setStronglyRelatedClientsMaxAgeFilterForTicketList($stronglyRelatedClientsMaxAgeFilterForTicketList);
    }
    /**
     * Get ClientId value
     * @return string|null
     */
    public function getClientId()
    {
        return $this->ClientId;
    }
    /**
     * Set ClientId value
     * @param string $clientId
     * @return \patest\StructType\GetClientEventTicketsRequest
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        $this->ClientId = $clientId;
        return $this;
    }
    /**
     * Get EventGuid value
     * @return string|null
     */
    public function getEventGuid()
    {
        return $this->EventGuid;
    }
    /**
     * Set EventGuid value
     * @param string $eventGuid
     * @return \patest\StructType\GetClientEventTicketsRequest
     */
    public function setEventGuid($eventGuid = null)
    {
        // validation for constraint: string
        if (!is_null($eventGuid) && !is_string($eventGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventGuid, true), gettype($eventGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventGuid, true)), __LINE__);
        }
        $this->EventGuid = $eventGuid;
        return $this;
    }
    /**
     * Get FromTicketLocalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFromTicketLocalId()
    {
        return isset($this->FromTicketLocalId) ? $this->FromTicketLocalId : null;
    }
    /**
     * Set FromTicketLocalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $fromTicketLocalId
     * @return \patest\StructType\GetClientEventTicketsRequest
     */
    public function setFromTicketLocalId($fromTicketLocalId = null)
    {
        // validation for constraint: int
        if (!is_null($fromTicketLocalId) && !(is_int($fromTicketLocalId) || ctype_digit($fromTicketLocalId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fromTicketLocalId, true), gettype($fromTicketLocalId)), __LINE__);
        }
        if (is_null($fromTicketLocalId) || (is_array($fromTicketLocalId) && empty($fromTicketLocalId))) {
            unset($this->FromTicketLocalId);
        } else {
            $this->FromTicketLocalId = $fromTicketLocalId;
        }
        return $this;
    }
    /**
     * Get IncludeGenres value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIncludeGenres()
    {
        return isset($this->IncludeGenres) ? $this->IncludeGenres : null;
    }
    /**
     * Set IncludeGenres value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $includeGenres
     * @return \patest\StructType\GetClientEventTicketsRequest
     */
    public function setIncludeGenres($includeGenres = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeGenres) && !is_bool($includeGenres)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeGenres, true), gettype($includeGenres)), __LINE__);
        }
        if (is_null($includeGenres) || (is_array($includeGenres) && empty($includeGenres))) {
            unset($this->IncludeGenres);
        } else {
            $this->IncludeGenres = $includeGenres;
        }
        return $this;
    }
    /**
     * Get IncludeNfc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIncludeNfc()
    {
        return isset($this->IncludeNfc) ? $this->IncludeNfc : null;
    }
    /**
     * Set IncludeNfc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $includeNfc
     * @return \patest\StructType\GetClientEventTicketsRequest
     */
    public function setIncludeNfc($includeNfc = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeNfc) && !is_bool($includeNfc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeNfc, true), gettype($includeNfc)), __LINE__);
        }
        if (is_null($includeNfc) || (is_array($includeNfc) && empty($includeNfc))) {
            unset($this->IncludeNfc);
        } else {
            $this->IncludeNfc = $includeNfc;
        }
        return $this;
    }
    /**
     * Get IncludePurchasedByClientNonForwardedOwnedByRelatedUnderaged value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIncludePurchasedByClientNonForwardedOwnedByRelatedUnderaged()
    {
        return isset($this->IncludePurchasedByClientNonForwardedOwnedByRelatedUnderaged) ? $this->IncludePurchasedByClientNonForwardedOwnedByRelatedUnderaged : null;
    }
    /**
     * Set IncludePurchasedByClientNonForwardedOwnedByRelatedUnderaged value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $includePurchasedByClientNonForwardedOwnedByRelatedUnderaged
     * @return \patest\StructType\GetClientEventTicketsRequest
     */
    public function setIncludePurchasedByClientNonForwardedOwnedByRelatedUnderaged($includePurchasedByClientNonForwardedOwnedByRelatedUnderaged = null)
    {
        // validation for constraint: boolean
        if (!is_null($includePurchasedByClientNonForwardedOwnedByRelatedUnderaged) && !is_bool($includePurchasedByClientNonForwardedOwnedByRelatedUnderaged)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includePurchasedByClientNonForwardedOwnedByRelatedUnderaged, true), gettype($includePurchasedByClientNonForwardedOwnedByRelatedUnderaged)), __LINE__);
        }
        if (is_null($includePurchasedByClientNonForwardedOwnedByRelatedUnderaged) || (is_array($includePurchasedByClientNonForwardedOwnedByRelatedUnderaged) && empty($includePurchasedByClientNonForwardedOwnedByRelatedUnderaged))) {
            unset($this->IncludePurchasedByClientNonForwardedOwnedByRelatedUnderaged);
        } else {
            $this->IncludePurchasedByClientNonForwardedOwnedByRelatedUnderaged = $includePurchasedByClientNonForwardedOwnedByRelatedUnderaged;
        }
        return $this;
    }
    /**
     * Get IncludeTicketsOfSpecificRelationshipType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIncludeTicketsOfSpecificRelationshipType()
    {
        return isset($this->IncludeTicketsOfSpecificRelationshipType) ? $this->IncludeTicketsOfSpecificRelationshipType : null;
    }
    /**
     * Set IncludeTicketsOfSpecificRelationshipType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $includeTicketsOfSpecificRelationshipType
     * @return \patest\StructType\GetClientEventTicketsRequest
     */
    public function setIncludeTicketsOfSpecificRelationshipType($includeTicketsOfSpecificRelationshipType = null)
    {
        // validation for constraint: string
        if (!is_null($includeTicketsOfSpecificRelationshipType) && !is_string($includeTicketsOfSpecificRelationshipType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($includeTicketsOfSpecificRelationshipType, true), gettype($includeTicketsOfSpecificRelationshipType)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($includeTicketsOfSpecificRelationshipType) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $includeTicketsOfSpecificRelationshipType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($includeTicketsOfSpecificRelationshipType, true)), __LINE__);
        }
        if (is_null($includeTicketsOfSpecificRelationshipType) || (is_array($includeTicketsOfSpecificRelationshipType) && empty($includeTicketsOfSpecificRelationshipType))) {
            unset($this->IncludeTicketsOfSpecificRelationshipType);
        } else {
            $this->IncludeTicketsOfSpecificRelationshipType = $includeTicketsOfSpecificRelationshipType;
        }
        return $this;
    }
    /**
     * Get IncludeTicketsOfStronglyConnectedOwners value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIncludeTicketsOfStronglyConnectedOwners()
    {
        return isset($this->IncludeTicketsOfStronglyConnectedOwners) ? $this->IncludeTicketsOfStronglyConnectedOwners : null;
    }
    /**
     * Set IncludeTicketsOfStronglyConnectedOwners value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $includeTicketsOfStronglyConnectedOwners
     * @return \patest\StructType\GetClientEventTicketsRequest
     */
    public function setIncludeTicketsOfStronglyConnectedOwners($includeTicketsOfStronglyConnectedOwners = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeTicketsOfStronglyConnectedOwners) && !is_bool($includeTicketsOfStronglyConnectedOwners)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeTicketsOfStronglyConnectedOwners, true), gettype($includeTicketsOfStronglyConnectedOwners)), __LINE__);
        }
        if (is_null($includeTicketsOfStronglyConnectedOwners) || (is_array($includeTicketsOfStronglyConnectedOwners) && empty($includeTicketsOfStronglyConnectedOwners))) {
            unset($this->IncludeTicketsOfStronglyConnectedOwners);
        } else {
            $this->IncludeTicketsOfStronglyConnectedOwners = $includeTicketsOfStronglyConnectedOwners;
        }
        return $this;
    }
    /**
     * Get MaxPageSize value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxPageSize()
    {
        return isset($this->MaxPageSize) ? $this->MaxPageSize : null;
    }
    /**
     * Set MaxPageSize value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxPageSize
     * @return \patest\StructType\GetClientEventTicketsRequest
     */
    public function setMaxPageSize($maxPageSize = null)
    {
        // validation for constraint: int
        if (!is_null($maxPageSize) && !(is_int($maxPageSize) || ctype_digit($maxPageSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxPageSize, true), gettype($maxPageSize)), __LINE__);
        }
        if (is_null($maxPageSize) || (is_array($maxPageSize) && empty($maxPageSize))) {
            unset($this->MaxPageSize);
        } else {
            $this->MaxPageSize = $maxPageSize;
        }
        return $this;
    }
    /**
     * Get NextPageToken value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNextPageToken()
    {
        return isset($this->NextPageToken) ? $this->NextPageToken : null;
    }
    /**
     * Set NextPageToken value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nextPageToken
     * @return \patest\StructType\GetClientEventTicketsRequest
     */
    public function setNextPageToken($nextPageToken = null)
    {
        // validation for constraint: string
        if (!is_null($nextPageToken) && !is_string($nextPageToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nextPageToken, true), gettype($nextPageToken)), __LINE__);
        }
        if (is_null($nextPageToken) || (is_array($nextPageToken) && empty($nextPageToken))) {
            unset($this->NextPageToken);
        } else {
            $this->NextPageToken = $nextPageToken;
        }
        return $this;
    }
    /**
     * Get StronglyRelatedClientsMaxAgeFilterForTicketList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getStronglyRelatedClientsMaxAgeFilterForTicketList()
    {
        return isset($this->StronglyRelatedClientsMaxAgeFilterForTicketList) ? $this->StronglyRelatedClientsMaxAgeFilterForTicketList : null;
    }
    /**
     * Set StronglyRelatedClientsMaxAgeFilterForTicketList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $stronglyRelatedClientsMaxAgeFilterForTicketList
     * @return \patest\StructType\GetClientEventTicketsRequest
     */
    public function setStronglyRelatedClientsMaxAgeFilterForTicketList($stronglyRelatedClientsMaxAgeFilterForTicketList = null)
    {
        // validation for constraint: int
        if (!is_null($stronglyRelatedClientsMaxAgeFilterForTicketList) && !(is_int($stronglyRelatedClientsMaxAgeFilterForTicketList) || ctype_digit($stronglyRelatedClientsMaxAgeFilterForTicketList))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($stronglyRelatedClientsMaxAgeFilterForTicketList, true), gettype($stronglyRelatedClientsMaxAgeFilterForTicketList)), __LINE__);
        }
        if (is_null($stronglyRelatedClientsMaxAgeFilterForTicketList) || (is_array($stronglyRelatedClientsMaxAgeFilterForTicketList) && empty($stronglyRelatedClientsMaxAgeFilterForTicketList))) {
            unset($this->StronglyRelatedClientsMaxAgeFilterForTicketList);
        } else {
            $this->StronglyRelatedClientsMaxAgeFilterForTicketList = $stronglyRelatedClientsMaxAgeFilterForTicketList;
        }
        return $this;
    }
}
