<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetClassContentRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetClassContentRequest
 * @subpackage Structs
 */
class GetClassContentRequest extends AbstractStructBase
{
    /**
     * The ClassNodeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClassNodeId;
    /**
     * The IsNative
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsNative;
    /**
     * Constructor method for GetClassContentRequest
     * @uses GetClassContentRequest::setClassNodeId()
     * @uses GetClassContentRequest::setIsNative()
     * @param string $classNodeId
     * @param bool $isNative
     */
    public function __construct($classNodeId = null, $isNative = null)
    {
        $this
            ->setClassNodeId($classNodeId)
            ->setIsNative($isNative);
    }
    /**
     * Get ClassNodeId value
     * @return string|null
     */
    public function getClassNodeId()
    {
        return $this->ClassNodeId;
    }
    /**
     * Set ClassNodeId value
     * @param string $classNodeId
     * @return \patest\StructType\GetClassContentRequest
     */
    public function setClassNodeId($classNodeId = null)
    {
        // validation for constraint: string
        if (!is_null($classNodeId) && !is_string($classNodeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($classNodeId, true), gettype($classNodeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($classNodeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $classNodeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($classNodeId, true)), __LINE__);
        }
        $this->ClassNodeId = $classNodeId;
        return $this;
    }
    /**
     * Get IsNative value
     * @return bool|null
     */
    public function getIsNative()
    {
        return $this->IsNative;
    }
    /**
     * Set IsNative value
     * @param bool $isNative
     * @return \patest\StructType\GetClassContentRequest
     */
    public function setIsNative($isNative = null)
    {
        // validation for constraint: boolean
        if (!is_null($isNative) && !is_bool($isNative)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isNative, true), gettype($isNative)), __LINE__);
        }
        $this->IsNative = $isNative;
        return $this;
    }
}
