<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCalculatedRelocationsPolicy-Response StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetCalculatedRelocationsPolicy-Response
 * @subpackage Structs
 */
class GetCalculatedRelocationsPolicy_Response extends ExtensibleDataContract
{
    /**
     * The AccountCreditCategory
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccountCreditCategory;
    /**
     * The AddOnsEnabled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AddOnsEnabled;
    /**
     * The AllowPaymentConsolidation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AllowPaymentConsolidation;
    /**
     * The CrossPlanEnabled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $CrossPlanEnabled;
    /**
     * The DefaultAddOnPriceType
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DefaultAddOnPriceType;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Description;
    /**
     * The DowngradesEnabled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $DowngradesEnabled;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsActive;
    /**
     * The IsParking
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsParking;
    /**
     * The MaxAddOns
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MaxAddOns;
    /**
     * The MaxTotalSubs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MaxTotalSubs;
    /**
     * The RelocateOutBlockedClientTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $RelocateOutBlockedClientTypes;
    /**
     * The RelocateOutBlockedPriceLevels
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $RelocateOutBlockedPriceLevels;
    /**
     * The RelocateOutBlockedPriceTypeIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $RelocateOutBlockedPriceTypeIds;
    /**
     * The RelocateOutEnabled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $RelocateOutEnabled;
    /**
     * The RelocationPriceTypeMapping
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfKeyValueOfguidguid
     */
    public $RelocationPriceTypeMapping;
    /**
     * The SeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeriesId;
    /**
     * The TargetSeries
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $TargetSeries;
    /**
     * Constructor method for GetCalculatedRelocationsPolicy-Response
     * @uses GetCalculatedRelocationsPolicy_Response::setAccountCreditCategory()
     * @uses GetCalculatedRelocationsPolicy_Response::setAddOnsEnabled()
     * @uses GetCalculatedRelocationsPolicy_Response::setAllowPaymentConsolidation()
     * @uses GetCalculatedRelocationsPolicy_Response::setCrossPlanEnabled()
     * @uses GetCalculatedRelocationsPolicy_Response::setDefaultAddOnPriceType()
     * @uses GetCalculatedRelocationsPolicy_Response::setDescription()
     * @uses GetCalculatedRelocationsPolicy_Response::setDowngradesEnabled()
     * @uses GetCalculatedRelocationsPolicy_Response::setIsActive()
     * @uses GetCalculatedRelocationsPolicy_Response::setIsParking()
     * @uses GetCalculatedRelocationsPolicy_Response::setMaxAddOns()
     * @uses GetCalculatedRelocationsPolicy_Response::setMaxTotalSubs()
     * @uses GetCalculatedRelocationsPolicy_Response::setRelocateOutBlockedClientTypes()
     * @uses GetCalculatedRelocationsPolicy_Response::setRelocateOutBlockedPriceLevels()
     * @uses GetCalculatedRelocationsPolicy_Response::setRelocateOutBlockedPriceTypeIds()
     * @uses GetCalculatedRelocationsPolicy_Response::setRelocateOutEnabled()
     * @uses GetCalculatedRelocationsPolicy_Response::setRelocationPriceTypeMapping()
     * @uses GetCalculatedRelocationsPolicy_Response::setSeriesId()
     * @uses GetCalculatedRelocationsPolicy_Response::setTargetSeries()
     * @param string $accountCreditCategory
     * @param bool $addOnsEnabled
     * @param bool $allowPaymentConsolidation
     * @param bool $crossPlanEnabled
     * @param string $defaultAddOnPriceType
     * @param \patest\StructType\GlobalString $description
     * @param bool $downgradesEnabled
     * @param bool $isActive
     * @param bool $isParking
     * @param int $maxAddOns
     * @param int $maxTotalSubs
     * @param \patest\ArrayType\ArrayOfguid $relocateOutBlockedClientTypes
     * @param \patest\ArrayType\ArrayOfguid $relocateOutBlockedPriceLevels
     * @param \patest\ArrayType\ArrayOfguid $relocateOutBlockedPriceTypeIds
     * @param bool $relocateOutEnabled
     * @param \patest\ArrayType\ArrayOfKeyValueOfguidguid $relocationPriceTypeMapping
     * @param string $seriesId
     * @param \patest\ArrayType\ArrayOfguid $targetSeries
     */
    public function __construct($accountCreditCategory = null, $addOnsEnabled = null, $allowPaymentConsolidation = null, $crossPlanEnabled = null, $defaultAddOnPriceType = null, \patest\StructType\GlobalString $description = null, $downgradesEnabled = null, $isActive = null, $isParking = null, $maxAddOns = null, $maxTotalSubs = null, \patest\ArrayType\ArrayOfguid $relocateOutBlockedClientTypes = null, \patest\ArrayType\ArrayOfguid $relocateOutBlockedPriceLevels = null, \patest\ArrayType\ArrayOfguid $relocateOutBlockedPriceTypeIds = null, $relocateOutEnabled = null, \patest\ArrayType\ArrayOfKeyValueOfguidguid $relocationPriceTypeMapping = null, $seriesId = null, \patest\ArrayType\ArrayOfguid $targetSeries = null)
    {
        $this
            ->setAccountCreditCategory($accountCreditCategory)
            ->setAddOnsEnabled($addOnsEnabled)
            ->setAllowPaymentConsolidation($allowPaymentConsolidation)
            ->setCrossPlanEnabled($crossPlanEnabled)
            ->setDefaultAddOnPriceType($defaultAddOnPriceType)
            ->setDescription($description)
            ->setDowngradesEnabled($downgradesEnabled)
            ->setIsActive($isActive)
            ->setIsParking($isParking)
            ->setMaxAddOns($maxAddOns)
            ->setMaxTotalSubs($maxTotalSubs)
            ->setRelocateOutBlockedClientTypes($relocateOutBlockedClientTypes)
            ->setRelocateOutBlockedPriceLevels($relocateOutBlockedPriceLevels)
            ->setRelocateOutBlockedPriceTypeIds($relocateOutBlockedPriceTypeIds)
            ->setRelocateOutEnabled($relocateOutEnabled)
            ->setRelocationPriceTypeMapping($relocationPriceTypeMapping)
            ->setSeriesId($seriesId)
            ->setTargetSeries($targetSeries);
    }
    /**
     * Get AccountCreditCategory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountCreditCategory()
    {
        return isset($this->AccountCreditCategory) ? $this->AccountCreditCategory : null;
    }
    /**
     * Set AccountCreditCategory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountCreditCategory
     * @return \patest\StructType\GetCalculatedRelocationsPolicy_Response
     */
    public function setAccountCreditCategory($accountCreditCategory = null)
    {
        // validation for constraint: string
        if (!is_null($accountCreditCategory) && !is_string($accountCreditCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountCreditCategory, true), gettype($accountCreditCategory)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accountCreditCategory) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accountCreditCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accountCreditCategory, true)), __LINE__);
        }
        if (is_null($accountCreditCategory) || (is_array($accountCreditCategory) && empty($accountCreditCategory))) {
            unset($this->AccountCreditCategory);
        } else {
            $this->AccountCreditCategory = $accountCreditCategory;
        }
        return $this;
    }
    /**
     * Get AddOnsEnabled value
     * @return bool|null
     */
    public function getAddOnsEnabled()
    {
        return $this->AddOnsEnabled;
    }
    /**
     * Set AddOnsEnabled value
     * @param bool $addOnsEnabled
     * @return \patest\StructType\GetCalculatedRelocationsPolicy_Response
     */
    public function setAddOnsEnabled($addOnsEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($addOnsEnabled) && !is_bool($addOnsEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($addOnsEnabled, true), gettype($addOnsEnabled)), __LINE__);
        }
        $this->AddOnsEnabled = $addOnsEnabled;
        return $this;
    }
    /**
     * Get AllowPaymentConsolidation value
     * @return bool|null
     */
    public function getAllowPaymentConsolidation()
    {
        return $this->AllowPaymentConsolidation;
    }
    /**
     * Set AllowPaymentConsolidation value
     * @param bool $allowPaymentConsolidation
     * @return \patest\StructType\GetCalculatedRelocationsPolicy_Response
     */
    public function setAllowPaymentConsolidation($allowPaymentConsolidation = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowPaymentConsolidation) && !is_bool($allowPaymentConsolidation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowPaymentConsolidation, true), gettype($allowPaymentConsolidation)), __LINE__);
        }
        $this->AllowPaymentConsolidation = $allowPaymentConsolidation;
        return $this;
    }
    /**
     * Get CrossPlanEnabled value
     * @return bool|null
     */
    public function getCrossPlanEnabled()
    {
        return $this->CrossPlanEnabled;
    }
    /**
     * Set CrossPlanEnabled value
     * @param bool $crossPlanEnabled
     * @return \patest\StructType\GetCalculatedRelocationsPolicy_Response
     */
    public function setCrossPlanEnabled($crossPlanEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($crossPlanEnabled) && !is_bool($crossPlanEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($crossPlanEnabled, true), gettype($crossPlanEnabled)), __LINE__);
        }
        $this->CrossPlanEnabled = $crossPlanEnabled;
        return $this;
    }
    /**
     * Get DefaultAddOnPriceType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultAddOnPriceType()
    {
        return isset($this->DefaultAddOnPriceType) ? $this->DefaultAddOnPriceType : null;
    }
    /**
     * Set DefaultAddOnPriceType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $defaultAddOnPriceType
     * @return \patest\StructType\GetCalculatedRelocationsPolicy_Response
     */
    public function setDefaultAddOnPriceType($defaultAddOnPriceType = null)
    {
        // validation for constraint: string
        if (!is_null($defaultAddOnPriceType) && !is_string($defaultAddOnPriceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultAddOnPriceType, true), gettype($defaultAddOnPriceType)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($defaultAddOnPriceType) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $defaultAddOnPriceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($defaultAddOnPriceType, true)), __LINE__);
        }
        if (is_null($defaultAddOnPriceType) || (is_array($defaultAddOnPriceType) && empty($defaultAddOnPriceType))) {
            unset($this->DefaultAddOnPriceType);
        } else {
            $this->DefaultAddOnPriceType = $defaultAddOnPriceType;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $description
     * @return \patest\StructType\GetCalculatedRelocationsPolicy_Response
     */
    public function setDescription(\patest\StructType\GlobalString $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get DowngradesEnabled value
     * @return bool|null
     */
    public function getDowngradesEnabled()
    {
        return $this->DowngradesEnabled;
    }
    /**
     * Set DowngradesEnabled value
     * @param bool $downgradesEnabled
     * @return \patest\StructType\GetCalculatedRelocationsPolicy_Response
     */
    public function setDowngradesEnabled($downgradesEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($downgradesEnabled) && !is_bool($downgradesEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($downgradesEnabled, true), gettype($downgradesEnabled)), __LINE__);
        }
        $this->DowngradesEnabled = $downgradesEnabled;
        return $this;
    }
    /**
     * Get IsActive value
     * @return bool|null
     */
    public function getIsActive()
    {
        return $this->IsActive;
    }
    /**
     * Set IsActive value
     * @param bool $isActive
     * @return \patest\StructType\GetCalculatedRelocationsPolicy_Response
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        $this->IsActive = $isActive;
        return $this;
    }
    /**
     * Get IsParking value
     * @return bool|null
     */
    public function getIsParking()
    {
        return $this->IsParking;
    }
    /**
     * Set IsParking value
     * @param bool $isParking
     * @return \patest\StructType\GetCalculatedRelocationsPolicy_Response
     */
    public function setIsParking($isParking = null)
    {
        // validation for constraint: boolean
        if (!is_null($isParking) && !is_bool($isParking)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isParking, true), gettype($isParking)), __LINE__);
        }
        $this->IsParking = $isParking;
        return $this;
    }
    /**
     * Get MaxAddOns value
     * @return int|null
     */
    public function getMaxAddOns()
    {
        return $this->MaxAddOns;
    }
    /**
     * Set MaxAddOns value
     * @param int $maxAddOns
     * @return \patest\StructType\GetCalculatedRelocationsPolicy_Response
     */
    public function setMaxAddOns($maxAddOns = null)
    {
        // validation for constraint: int
        if (!is_null($maxAddOns) && !(is_int($maxAddOns) || ctype_digit($maxAddOns))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxAddOns, true), gettype($maxAddOns)), __LINE__);
        }
        $this->MaxAddOns = $maxAddOns;
        return $this;
    }
    /**
     * Get MaxTotalSubs value
     * @return int|null
     */
    public function getMaxTotalSubs()
    {
        return $this->MaxTotalSubs;
    }
    /**
     * Set MaxTotalSubs value
     * @param int $maxTotalSubs
     * @return \patest\StructType\GetCalculatedRelocationsPolicy_Response
     */
    public function setMaxTotalSubs($maxTotalSubs = null)
    {
        // validation for constraint: int
        if (!is_null($maxTotalSubs) && !(is_int($maxTotalSubs) || ctype_digit($maxTotalSubs))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxTotalSubs, true), gettype($maxTotalSubs)), __LINE__);
        }
        $this->MaxTotalSubs = $maxTotalSubs;
        return $this;
    }
    /**
     * Get RelocateOutBlockedClientTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getRelocateOutBlockedClientTypes()
    {
        return isset($this->RelocateOutBlockedClientTypes) ? $this->RelocateOutBlockedClientTypes : null;
    }
    /**
     * Set RelocateOutBlockedClientTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $relocateOutBlockedClientTypes
     * @return \patest\StructType\GetCalculatedRelocationsPolicy_Response
     */
    public function setRelocateOutBlockedClientTypes(\patest\ArrayType\ArrayOfguid $relocateOutBlockedClientTypes = null)
    {
        if (is_null($relocateOutBlockedClientTypes) || (is_array($relocateOutBlockedClientTypes) && empty($relocateOutBlockedClientTypes))) {
            unset($this->RelocateOutBlockedClientTypes);
        } else {
            $this->RelocateOutBlockedClientTypes = $relocateOutBlockedClientTypes;
        }
        return $this;
    }
    /**
     * Get RelocateOutBlockedPriceLevels value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getRelocateOutBlockedPriceLevels()
    {
        return isset($this->RelocateOutBlockedPriceLevels) ? $this->RelocateOutBlockedPriceLevels : null;
    }
    /**
     * Set RelocateOutBlockedPriceLevels value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $relocateOutBlockedPriceLevels
     * @return \patest\StructType\GetCalculatedRelocationsPolicy_Response
     */
    public function setRelocateOutBlockedPriceLevels(\patest\ArrayType\ArrayOfguid $relocateOutBlockedPriceLevels = null)
    {
        if (is_null($relocateOutBlockedPriceLevels) || (is_array($relocateOutBlockedPriceLevels) && empty($relocateOutBlockedPriceLevels))) {
            unset($this->RelocateOutBlockedPriceLevels);
        } else {
            $this->RelocateOutBlockedPriceLevels = $relocateOutBlockedPriceLevels;
        }
        return $this;
    }
    /**
     * Get RelocateOutBlockedPriceTypeIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getRelocateOutBlockedPriceTypeIds()
    {
        return isset($this->RelocateOutBlockedPriceTypeIds) ? $this->RelocateOutBlockedPriceTypeIds : null;
    }
    /**
     * Set RelocateOutBlockedPriceTypeIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $relocateOutBlockedPriceTypeIds
     * @return \patest\StructType\GetCalculatedRelocationsPolicy_Response
     */
    public function setRelocateOutBlockedPriceTypeIds(\patest\ArrayType\ArrayOfguid $relocateOutBlockedPriceTypeIds = null)
    {
        if (is_null($relocateOutBlockedPriceTypeIds) || (is_array($relocateOutBlockedPriceTypeIds) && empty($relocateOutBlockedPriceTypeIds))) {
            unset($this->RelocateOutBlockedPriceTypeIds);
        } else {
            $this->RelocateOutBlockedPriceTypeIds = $relocateOutBlockedPriceTypeIds;
        }
        return $this;
    }
    /**
     * Get RelocateOutEnabled value
     * @return bool|null
     */
    public function getRelocateOutEnabled()
    {
        return $this->RelocateOutEnabled;
    }
    /**
     * Set RelocateOutEnabled value
     * @param bool $relocateOutEnabled
     * @return \patest\StructType\GetCalculatedRelocationsPolicy_Response
     */
    public function setRelocateOutEnabled($relocateOutEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($relocateOutEnabled) && !is_bool($relocateOutEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($relocateOutEnabled, true), gettype($relocateOutEnabled)), __LINE__);
        }
        $this->RelocateOutEnabled = $relocateOutEnabled;
        return $this;
    }
    /**
     * Get RelocationPriceTypeMapping value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfKeyValueOfguidguid|null
     */
    public function getRelocationPriceTypeMapping()
    {
        return isset($this->RelocationPriceTypeMapping) ? $this->RelocationPriceTypeMapping : null;
    }
    /**
     * Set RelocationPriceTypeMapping value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfKeyValueOfguidguid $relocationPriceTypeMapping
     * @return \patest\StructType\GetCalculatedRelocationsPolicy_Response
     */
    public function setRelocationPriceTypeMapping(\patest\ArrayType\ArrayOfKeyValueOfguidguid $relocationPriceTypeMapping = null)
    {
        if (is_null($relocationPriceTypeMapping) || (is_array($relocationPriceTypeMapping) && empty($relocationPriceTypeMapping))) {
            unset($this->RelocationPriceTypeMapping);
        } else {
            $this->RelocationPriceTypeMapping = $relocationPriceTypeMapping;
        }
        return $this;
    }
    /**
     * Get SeriesId value
     * @return string|null
     */
    public function getSeriesId()
    {
        return $this->SeriesId;
    }
    /**
     * Set SeriesId value
     * @param string $seriesId
     * @return \patest\StructType\GetCalculatedRelocationsPolicy_Response
     */
    public function setSeriesId($seriesId = null)
    {
        // validation for constraint: string
        if (!is_null($seriesId) && !is_string($seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesId, true), gettype($seriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seriesId, true)), __LINE__);
        }
        $this->SeriesId = $seriesId;
        return $this;
    }
    /**
     * Get TargetSeries value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getTargetSeries()
    {
        return isset($this->TargetSeries) ? $this->TargetSeries : null;
    }
    /**
     * Set TargetSeries value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $targetSeries
     * @return \patest\StructType\GetCalculatedRelocationsPolicy_Response
     */
    public function setTargetSeries(\patest\ArrayType\ArrayOfguid $targetSeries = null)
    {
        if (is_null($targetSeries) || (is_array($targetSeries) && empty($targetSeries))) {
            unset($this->TargetSeries);
        } else {
            $this->TargetSeries = $targetSeries;
        }
        return $this;
    }
}
