<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetBarcodeEntities-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetBarcodeEntities-Request
 * @subpackage Structs
 */
class GetBarcodeEntities_Request extends AbstractStructBase
{
    /**
     * The Barcode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Barcode;
    /**
     * The IsCheckBarcode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsCheckBarcode;
    /**
     * The IsCheckCrm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsCheckCrm;
    /**
     * The IsCheckMerchandise
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsCheckMerchandise;
    /**
     * The IsGetClient
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsGetClient;
    /**
     * The IsGetTransaction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsGetTransaction;
    /**
     * The IsGetTransactionOnlyIfTicket
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsGetTransactionOnlyIfTicket;
    /**
     * Constructor method for GetBarcodeEntities-Request
     * @uses GetBarcodeEntities_Request::setBarcode()
     * @uses GetBarcodeEntities_Request::setIsCheckBarcode()
     * @uses GetBarcodeEntities_Request::setIsCheckCrm()
     * @uses GetBarcodeEntities_Request::setIsCheckMerchandise()
     * @uses GetBarcodeEntities_Request::setIsGetClient()
     * @uses GetBarcodeEntities_Request::setIsGetTransaction()
     * @uses GetBarcodeEntities_Request::setIsGetTransactionOnlyIfTicket()
     * @param string $barcode
     * @param bool $isCheckBarcode
     * @param bool $isCheckCrm
     * @param bool $isCheckMerchandise
     * @param bool $isGetClient
     * @param bool $isGetTransaction
     * @param bool $isGetTransactionOnlyIfTicket
     */
    public function __construct($barcode = null, $isCheckBarcode = null, $isCheckCrm = null, $isCheckMerchandise = null, $isGetClient = null, $isGetTransaction = null, $isGetTransactionOnlyIfTicket = null)
    {
        $this
            ->setBarcode($barcode)
            ->setIsCheckBarcode($isCheckBarcode)
            ->setIsCheckCrm($isCheckCrm)
            ->setIsCheckMerchandise($isCheckMerchandise)
            ->setIsGetClient($isGetClient)
            ->setIsGetTransaction($isGetTransaction)
            ->setIsGetTransactionOnlyIfTicket($isGetTransactionOnlyIfTicket);
    }
    /**
     * Get Barcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarcode()
    {
        return isset($this->Barcode) ? $this->Barcode : null;
    }
    /**
     * Set Barcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barcode
     * @return \patest\StructType\GetBarcodeEntities_Request
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcode, true), gettype($barcode)), __LINE__);
        }
        if (is_null($barcode) || (is_array($barcode) && empty($barcode))) {
            unset($this->Barcode);
        } else {
            $this->Barcode = $barcode;
        }
        return $this;
    }
    /**
     * Get IsCheckBarcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsCheckBarcode()
    {
        return isset($this->IsCheckBarcode) ? $this->IsCheckBarcode : null;
    }
    /**
     * Set IsCheckBarcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isCheckBarcode
     * @return \patest\StructType\GetBarcodeEntities_Request
     */
    public function setIsCheckBarcode($isCheckBarcode = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCheckBarcode) && !is_bool($isCheckBarcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCheckBarcode, true), gettype($isCheckBarcode)), __LINE__);
        }
        if (is_null($isCheckBarcode) || (is_array($isCheckBarcode) && empty($isCheckBarcode))) {
            unset($this->IsCheckBarcode);
        } else {
            $this->IsCheckBarcode = $isCheckBarcode;
        }
        return $this;
    }
    /**
     * Get IsCheckCrm value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsCheckCrm()
    {
        return isset($this->IsCheckCrm) ? $this->IsCheckCrm : null;
    }
    /**
     * Set IsCheckCrm value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isCheckCrm
     * @return \patest\StructType\GetBarcodeEntities_Request
     */
    public function setIsCheckCrm($isCheckCrm = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCheckCrm) && !is_bool($isCheckCrm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCheckCrm, true), gettype($isCheckCrm)), __LINE__);
        }
        if (is_null($isCheckCrm) || (is_array($isCheckCrm) && empty($isCheckCrm))) {
            unset($this->IsCheckCrm);
        } else {
            $this->IsCheckCrm = $isCheckCrm;
        }
        return $this;
    }
    /**
     * Get IsCheckMerchandise value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsCheckMerchandise()
    {
        return isset($this->IsCheckMerchandise) ? $this->IsCheckMerchandise : null;
    }
    /**
     * Set IsCheckMerchandise value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isCheckMerchandise
     * @return \patest\StructType\GetBarcodeEntities_Request
     */
    public function setIsCheckMerchandise($isCheckMerchandise = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCheckMerchandise) && !is_bool($isCheckMerchandise)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCheckMerchandise, true), gettype($isCheckMerchandise)), __LINE__);
        }
        if (is_null($isCheckMerchandise) || (is_array($isCheckMerchandise) && empty($isCheckMerchandise))) {
            unset($this->IsCheckMerchandise);
        } else {
            $this->IsCheckMerchandise = $isCheckMerchandise;
        }
        return $this;
    }
    /**
     * Get IsGetClient value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsGetClient()
    {
        return isset($this->IsGetClient) ? $this->IsGetClient : null;
    }
    /**
     * Set IsGetClient value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isGetClient
     * @return \patest\StructType\GetBarcodeEntities_Request
     */
    public function setIsGetClient($isGetClient = null)
    {
        // validation for constraint: boolean
        if (!is_null($isGetClient) && !is_bool($isGetClient)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isGetClient, true), gettype($isGetClient)), __LINE__);
        }
        if (is_null($isGetClient) || (is_array($isGetClient) && empty($isGetClient))) {
            unset($this->IsGetClient);
        } else {
            $this->IsGetClient = $isGetClient;
        }
        return $this;
    }
    /**
     * Get IsGetTransaction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsGetTransaction()
    {
        return isset($this->IsGetTransaction) ? $this->IsGetTransaction : null;
    }
    /**
     * Set IsGetTransaction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isGetTransaction
     * @return \patest\StructType\GetBarcodeEntities_Request
     */
    public function setIsGetTransaction($isGetTransaction = null)
    {
        // validation for constraint: boolean
        if (!is_null($isGetTransaction) && !is_bool($isGetTransaction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isGetTransaction, true), gettype($isGetTransaction)), __LINE__);
        }
        if (is_null($isGetTransaction) || (is_array($isGetTransaction) && empty($isGetTransaction))) {
            unset($this->IsGetTransaction);
        } else {
            $this->IsGetTransaction = $isGetTransaction;
        }
        return $this;
    }
    /**
     * Get IsGetTransactionOnlyIfTicket value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsGetTransactionOnlyIfTicket()
    {
        return isset($this->IsGetTransactionOnlyIfTicket) ? $this->IsGetTransactionOnlyIfTicket : null;
    }
    /**
     * Set IsGetTransactionOnlyIfTicket value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isGetTransactionOnlyIfTicket
     * @return \patest\StructType\GetBarcodeEntities_Request
     */
    public function setIsGetTransactionOnlyIfTicket($isGetTransactionOnlyIfTicket = null)
    {
        // validation for constraint: boolean
        if (!is_null($isGetTransactionOnlyIfTicket) && !is_bool($isGetTransactionOnlyIfTicket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isGetTransactionOnlyIfTicket, true), gettype($isGetTransactionOnlyIfTicket)), __LINE__);
        }
        if (is_null($isGetTransactionOnlyIfTicket) || (is_array($isGetTransactionOnlyIfTicket) && empty($isGetTransactionOnlyIfTicket))) {
            unset($this->IsGetTransactionOnlyIfTicket);
        } else {
            $this->IsGetTransactionOnlyIfTicket = $isGetTransactionOnlyIfTicket;
        }
        return $this;
    }
}
