<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetBarcodeChangesRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetBarcodeChangesRequest
 * @subpackage Structs
 */
class GetBarcodeChangesRequest extends ExtensibleDataContract
{
    /**
     * The AccessControlSystemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccessControlSystemId;
    /**
     * The EventIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $EventIds;
    /**
     * The MaxRecords
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxRecords;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The Properties
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Properties;
    /**
     * The ReferencedEntityNames
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfstring
     */
    public $ReferencedEntityNames;
    /**
     * The StartingLocalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $StartingLocalId;
    /**
     * The StartingTimeUtc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StartingTimeUtc;
    /**
     * Constructor method for GetBarcodeChangesRequest
     * @uses GetBarcodeChangesRequest::setAccessControlSystemId()
     * @uses GetBarcodeChangesRequest::setEventIds()
     * @uses GetBarcodeChangesRequest::setMaxRecords()
     * @uses GetBarcodeChangesRequest::setOrganizationUnitId()
     * @uses GetBarcodeChangesRequest::setProperties()
     * @uses GetBarcodeChangesRequest::setReferencedEntityNames()
     * @uses GetBarcodeChangesRequest::setStartingLocalId()
     * @uses GetBarcodeChangesRequest::setStartingTimeUtc()
     * @param string $accessControlSystemId
     * @param \patest\ArrayType\ArrayOfguid $eventIds
     * @param int $maxRecords
     * @param string $organizationUnitId
     * @param string $properties
     * @param \patest\ArrayType\ArrayOfstring $referencedEntityNames
     * @param int $startingLocalId
     * @param string $startingTimeUtc
     */
    public function __construct($accessControlSystemId = null, \patest\ArrayType\ArrayOfguid $eventIds = null, $maxRecords = null, $organizationUnitId = null, $properties = null, \patest\ArrayType\ArrayOfstring $referencedEntityNames = null, $startingLocalId = null, $startingTimeUtc = null)
    {
        $this
            ->setAccessControlSystemId($accessControlSystemId)
            ->setEventIds($eventIds)
            ->setMaxRecords($maxRecords)
            ->setOrganizationUnitId($organizationUnitId)
            ->setProperties($properties)
            ->setReferencedEntityNames($referencedEntityNames)
            ->setStartingLocalId($startingLocalId)
            ->setStartingTimeUtc($startingTimeUtc);
    }
    /**
     * Get AccessControlSystemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessControlSystemId()
    {
        return isset($this->AccessControlSystemId) ? $this->AccessControlSystemId : null;
    }
    /**
     * Set AccessControlSystemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessControlSystemId
     * @return \patest\StructType\GetBarcodeChangesRequest
     */
    public function setAccessControlSystemId($accessControlSystemId = null)
    {
        // validation for constraint: string
        if (!is_null($accessControlSystemId) && !is_string($accessControlSystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessControlSystemId, true), gettype($accessControlSystemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accessControlSystemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accessControlSystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accessControlSystemId, true)), __LINE__);
        }
        if (is_null($accessControlSystemId) || (is_array($accessControlSystemId) && empty($accessControlSystemId))) {
            unset($this->AccessControlSystemId);
        } else {
            $this->AccessControlSystemId = $accessControlSystemId;
        }
        return $this;
    }
    /**
     * Get EventIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getEventIds()
    {
        return isset($this->EventIds) ? $this->EventIds : null;
    }
    /**
     * Set EventIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $eventIds
     * @return \patest\StructType\GetBarcodeChangesRequest
     */
    public function setEventIds(\patest\ArrayType\ArrayOfguid $eventIds = null)
    {
        if (is_null($eventIds) || (is_array($eventIds) && empty($eventIds))) {
            unset($this->EventIds);
        } else {
            $this->EventIds = $eventIds;
        }
        return $this;
    }
    /**
     * Get MaxRecords value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxRecords()
    {
        return isset($this->MaxRecords) ? $this->MaxRecords : null;
    }
    /**
     * Set MaxRecords value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxRecords
     * @return \patest\StructType\GetBarcodeChangesRequest
     */
    public function setMaxRecords($maxRecords = null)
    {
        // validation for constraint: int
        if (!is_null($maxRecords) && !(is_int($maxRecords) || ctype_digit($maxRecords))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxRecords, true), gettype($maxRecords)), __LINE__);
        }
        if (is_null($maxRecords) || (is_array($maxRecords) && empty($maxRecords))) {
            unset($this->MaxRecords);
        } else {
            $this->MaxRecords = $maxRecords;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\GetBarcodeChangesRequest
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get Properties value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProperties()
    {
        return isset($this->Properties) ? $this->Properties : null;
    }
    /**
     * Set Properties value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $properties
     * @return \patest\StructType\GetBarcodeChangesRequest
     */
    public function setProperties($properties = null)
    {
        // validation for constraint: string
        if (!is_null($properties) && !is_string($properties)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($properties, true), gettype($properties)), __LINE__);
        }
        if (is_null($properties) || (is_array($properties) && empty($properties))) {
            unset($this->Properties);
        } else {
            $this->Properties = $properties;
        }
        return $this;
    }
    /**
     * Get ReferencedEntityNames value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfstring|null
     */
    public function getReferencedEntityNames()
    {
        return isset($this->ReferencedEntityNames) ? $this->ReferencedEntityNames : null;
    }
    /**
     * Set ReferencedEntityNames value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfstring $referencedEntityNames
     * @return \patest\StructType\GetBarcodeChangesRequest
     */
    public function setReferencedEntityNames(\patest\ArrayType\ArrayOfstring $referencedEntityNames = null)
    {
        if (is_null($referencedEntityNames) || (is_array($referencedEntityNames) && empty($referencedEntityNames))) {
            unset($this->ReferencedEntityNames);
        } else {
            $this->ReferencedEntityNames = $referencedEntityNames;
        }
        return $this;
    }
    /**
     * Get StartingLocalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getStartingLocalId()
    {
        return isset($this->StartingLocalId) ? $this->StartingLocalId : null;
    }
    /**
     * Set StartingLocalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $startingLocalId
     * @return \patest\StructType\GetBarcodeChangesRequest
     */
    public function setStartingLocalId($startingLocalId = null)
    {
        // validation for constraint: int
        if (!is_null($startingLocalId) && !(is_int($startingLocalId) || ctype_digit($startingLocalId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($startingLocalId, true), gettype($startingLocalId)), __LINE__);
        }
        if (is_null($startingLocalId) || (is_array($startingLocalId) && empty($startingLocalId))) {
            unset($this->StartingLocalId);
        } else {
            $this->StartingLocalId = $startingLocalId;
        }
        return $this;
    }
    /**
     * Get StartingTimeUtc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartingTimeUtc()
    {
        return isset($this->StartingTimeUtc) ? $this->StartingTimeUtc : null;
    }
    /**
     * Set StartingTimeUtc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startingTimeUtc
     * @return \patest\StructType\GetBarcodeChangesRequest
     */
    public function setStartingTimeUtc($startingTimeUtc = null)
    {
        // validation for constraint: string
        if (!is_null($startingTimeUtc) && !is_string($startingTimeUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startingTimeUtc, true), gettype($startingTimeUtc)), __LINE__);
        }
        if (is_null($startingTimeUtc) || (is_array($startingTimeUtc) && empty($startingTimeUtc))) {
            unset($this->StartingTimeUtc);
        } else {
            $this->StartingTimeUtc = $startingTimeUtc;
        }
        return $this;
    }
}
