<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetBallotVirtualPriceTypeValues StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetBallotVirtualPriceTypeValues
 * @subpackage Structs
 */
class GetBallotVirtualPriceTypeValues extends AbstractStructBase
{
    /**
     * The Maximum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Maximum;
    /**
     * The Minimum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Minimum;
    /**
     * The VirtualPriceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $VirtualPriceTypeId;
    /**
     * The VirtualPriceTypeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VirtualPriceTypeName;
    /**
     * Constructor method for GetBallotVirtualPriceTypeValues
     * @uses GetBallotVirtualPriceTypeValues::setMaximum()
     * @uses GetBallotVirtualPriceTypeValues::setMinimum()
     * @uses GetBallotVirtualPriceTypeValues::setVirtualPriceTypeId()
     * @uses GetBallotVirtualPriceTypeValues::setVirtualPriceTypeName()
     * @param float $maximum
     * @param float $minimum
     * @param string $virtualPriceTypeId
     * @param string $virtualPriceTypeName
     */
    public function __construct($maximum = null, $minimum = null, $virtualPriceTypeId = null, $virtualPriceTypeName = null)
    {
        $this
            ->setMaximum($maximum)
            ->setMinimum($minimum)
            ->setVirtualPriceTypeId($virtualPriceTypeId)
            ->setVirtualPriceTypeName($virtualPriceTypeName);
    }
    /**
     * Get Maximum value
     * @return float|null
     */
    public function getMaximum()
    {
        return $this->Maximum;
    }
    /**
     * Set Maximum value
     * @param float $maximum
     * @return \patest\StructType\GetBallotVirtualPriceTypeValues
     */
    public function setMaximum($maximum = null)
    {
        // validation for constraint: float
        if (!is_null($maximum) && !(is_float($maximum) || is_numeric($maximum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maximum, true), gettype($maximum)), __LINE__);
        }
        $this->Maximum = $maximum;
        return $this;
    }
    /**
     * Get Minimum value
     * @return float|null
     */
    public function getMinimum()
    {
        return $this->Minimum;
    }
    /**
     * Set Minimum value
     * @param float $minimum
     * @return \patest\StructType\GetBallotVirtualPriceTypeValues
     */
    public function setMinimum($minimum = null)
    {
        // validation for constraint: float
        if (!is_null($minimum) && !(is_float($minimum) || is_numeric($minimum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($minimum, true), gettype($minimum)), __LINE__);
        }
        $this->Minimum = $minimum;
        return $this;
    }
    /**
     * Get VirtualPriceTypeId value
     * @return string|null
     */
    public function getVirtualPriceTypeId()
    {
        return $this->VirtualPriceTypeId;
    }
    /**
     * Set VirtualPriceTypeId value
     * @param string $virtualPriceTypeId
     * @return \patest\StructType\GetBallotVirtualPriceTypeValues
     */
    public function setVirtualPriceTypeId($virtualPriceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($virtualPriceTypeId) && !is_string($virtualPriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($virtualPriceTypeId, true), gettype($virtualPriceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($virtualPriceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $virtualPriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($virtualPriceTypeId, true)), __LINE__);
        }
        $this->VirtualPriceTypeId = $virtualPriceTypeId;
        return $this;
    }
    /**
     * Get VirtualPriceTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVirtualPriceTypeName()
    {
        return isset($this->VirtualPriceTypeName) ? $this->VirtualPriceTypeName : null;
    }
    /**
     * Set VirtualPriceTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $virtualPriceTypeName
     * @return \patest\StructType\GetBallotVirtualPriceTypeValues
     */
    public function setVirtualPriceTypeName($virtualPriceTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($virtualPriceTypeName) && !is_string($virtualPriceTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($virtualPriceTypeName, true), gettype($virtualPriceTypeName)), __LINE__);
        }
        if (is_null($virtualPriceTypeName) || (is_array($virtualPriceTypeName) && empty($virtualPriceTypeName))) {
            unset($this->VirtualPriceTypeName);
        } else {
            $this->VirtualPriceTypeName = $virtualPriceTypeName;
        }
        return $this;
    }
}
