<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetBallotPricingSectionValues StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetBallotPricingSectionValues
 * @subpackage Structs
 */
class GetBallotPricingSectionValues extends AbstractStructBase
{
    /**
     * The BasePriceTypeMaximum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $BasePriceTypeMaximum;
    /**
     * The BasePriceTypeMinimum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $BasePriceTypeMinimum;
    /**
     * The Maximum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Maximum;
    /**
     * The Minimum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Minimum;
    /**
     * The SectionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SectionId;
    /**
     * The VirtualPriceTypeValues
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfGetBallotVirtualPriceTypeValues
     */
    public $VirtualPriceTypeValues;
    /**
     * Constructor method for GetBallotPricingSectionValues
     * @uses GetBallotPricingSectionValues::setBasePriceTypeMaximum()
     * @uses GetBallotPricingSectionValues::setBasePriceTypeMinimum()
     * @uses GetBallotPricingSectionValues::setMaximum()
     * @uses GetBallotPricingSectionValues::setMinimum()
     * @uses GetBallotPricingSectionValues::setSectionId()
     * @uses GetBallotPricingSectionValues::setVirtualPriceTypeValues()
     * @param float $basePriceTypeMaximum
     * @param float $basePriceTypeMinimum
     * @param float $maximum
     * @param float $minimum
     * @param string $sectionId
     * @param \patest\ArrayType\ArrayOfGetBallotVirtualPriceTypeValues $virtualPriceTypeValues
     */
    public function __construct($basePriceTypeMaximum = null, $basePriceTypeMinimum = null, $maximum = null, $minimum = null, $sectionId = null, \patest\ArrayType\ArrayOfGetBallotVirtualPriceTypeValues $virtualPriceTypeValues = null)
    {
        $this
            ->setBasePriceTypeMaximum($basePriceTypeMaximum)
            ->setBasePriceTypeMinimum($basePriceTypeMinimum)
            ->setMaximum($maximum)
            ->setMinimum($minimum)
            ->setSectionId($sectionId)
            ->setVirtualPriceTypeValues($virtualPriceTypeValues);
    }
    /**
     * Get BasePriceTypeMaximum value
     * @return float|null
     */
    public function getBasePriceTypeMaximum()
    {
        return $this->BasePriceTypeMaximum;
    }
    /**
     * Set BasePriceTypeMaximum value
     * @param float $basePriceTypeMaximum
     * @return \patest\StructType\GetBallotPricingSectionValues
     */
    public function setBasePriceTypeMaximum($basePriceTypeMaximum = null)
    {
        // validation for constraint: float
        if (!is_null($basePriceTypeMaximum) && !(is_float($basePriceTypeMaximum) || is_numeric($basePriceTypeMaximum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($basePriceTypeMaximum, true), gettype($basePriceTypeMaximum)), __LINE__);
        }
        $this->BasePriceTypeMaximum = $basePriceTypeMaximum;
        return $this;
    }
    /**
     * Get BasePriceTypeMinimum value
     * @return float|null
     */
    public function getBasePriceTypeMinimum()
    {
        return $this->BasePriceTypeMinimum;
    }
    /**
     * Set BasePriceTypeMinimum value
     * @param float $basePriceTypeMinimum
     * @return \patest\StructType\GetBallotPricingSectionValues
     */
    public function setBasePriceTypeMinimum($basePriceTypeMinimum = null)
    {
        // validation for constraint: float
        if (!is_null($basePriceTypeMinimum) && !(is_float($basePriceTypeMinimum) || is_numeric($basePriceTypeMinimum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($basePriceTypeMinimum, true), gettype($basePriceTypeMinimum)), __LINE__);
        }
        $this->BasePriceTypeMinimum = $basePriceTypeMinimum;
        return $this;
    }
    /**
     * Get Maximum value
     * @return float|null
     */
    public function getMaximum()
    {
        return $this->Maximum;
    }
    /**
     * Set Maximum value
     * @param float $maximum
     * @return \patest\StructType\GetBallotPricingSectionValues
     */
    public function setMaximum($maximum = null)
    {
        // validation for constraint: float
        if (!is_null($maximum) && !(is_float($maximum) || is_numeric($maximum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maximum, true), gettype($maximum)), __LINE__);
        }
        $this->Maximum = $maximum;
        return $this;
    }
    /**
     * Get Minimum value
     * @return float|null
     */
    public function getMinimum()
    {
        return $this->Minimum;
    }
    /**
     * Set Minimum value
     * @param float $minimum
     * @return \patest\StructType\GetBallotPricingSectionValues
     */
    public function setMinimum($minimum = null)
    {
        // validation for constraint: float
        if (!is_null($minimum) && !(is_float($minimum) || is_numeric($minimum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($minimum, true), gettype($minimum)), __LINE__);
        }
        $this->Minimum = $minimum;
        return $this;
    }
    /**
     * Get SectionId value
     * @return string|null
     */
    public function getSectionId()
    {
        return $this->SectionId;
    }
    /**
     * Set SectionId value
     * @param string $sectionId
     * @return \patest\StructType\GetBallotPricingSectionValues
     */
    public function setSectionId($sectionId = null)
    {
        // validation for constraint: string
        if (!is_null($sectionId) && !is_string($sectionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sectionId, true), gettype($sectionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sectionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sectionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sectionId, true)), __LINE__);
        }
        $this->SectionId = $sectionId;
        return $this;
    }
    /**
     * Get VirtualPriceTypeValues value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfGetBallotVirtualPriceTypeValues|null
     */
    public function getVirtualPriceTypeValues()
    {
        return isset($this->VirtualPriceTypeValues) ? $this->VirtualPriceTypeValues : null;
    }
    /**
     * Set VirtualPriceTypeValues value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfGetBallotVirtualPriceTypeValues $virtualPriceTypeValues
     * @return \patest\StructType\GetBallotPricingSectionValues
     */
    public function setVirtualPriceTypeValues(\patest\ArrayType\ArrayOfGetBallotVirtualPriceTypeValues $virtualPriceTypeValues = null)
    {
        if (is_null($virtualPriceTypeValues) || (is_array($virtualPriceTypeValues) && empty($virtualPriceTypeValues))) {
            unset($this->VirtualPriceTypeValues);
        } else {
            $this->VirtualPriceTypeValues = $virtualPriceTypeValues;
        }
        return $this;
    }
}
