<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAvailableProducts-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetAvailableProducts-Request
 * @subpackage Structs
 */
class GetAvailableProducts_Request extends ExtensibleDataContract
{
    /**
     * The CategoryId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CategoryId;
    /**
     * The ClassNodeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClassNodeId;
    /**
     * The FreeText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FreeText;
    /**
     * The IncludeMerchandiseItems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeMerchandiseItems;
    /**
     * The TopRecords
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TopRecords;
    /**
     * The TypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TypeId;
    /**
     * The IsClassified
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsClassified;
    /**
     * Constructor method for GetAvailableProducts-Request
     * @uses GetAvailableProducts_Request::setCategoryId()
     * @uses GetAvailableProducts_Request::setClassNodeId()
     * @uses GetAvailableProducts_Request::setFreeText()
     * @uses GetAvailableProducts_Request::setIncludeMerchandiseItems()
     * @uses GetAvailableProducts_Request::setTopRecords()
     * @uses GetAvailableProducts_Request::setTypeId()
     * @uses GetAvailableProducts_Request::setIsClassified()
     * @param string $categoryId
     * @param string $classNodeId
     * @param string $freeText
     * @param bool $includeMerchandiseItems
     * @param int $topRecords
     * @param string $typeId
     * @param bool $isClassified
     */
    public function __construct($categoryId = null, $classNodeId = null, $freeText = null, $includeMerchandiseItems = null, $topRecords = null, $typeId = null, $isClassified = null)
    {
        $this
            ->setCategoryId($categoryId)
            ->setClassNodeId($classNodeId)
            ->setFreeText($freeText)
            ->setIncludeMerchandiseItems($includeMerchandiseItems)
            ->setTopRecords($topRecords)
            ->setTypeId($typeId)
            ->setIsClassified($isClassified);
    }
    /**
     * Get CategoryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCategoryId()
    {
        return isset($this->CategoryId) ? $this->CategoryId : null;
    }
    /**
     * Set CategoryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $categoryId
     * @return \patest\StructType\GetAvailableProducts_Request
     */
    public function setCategoryId($categoryId = null)
    {
        // validation for constraint: string
        if (!is_null($categoryId) && !is_string($categoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($categoryId, true), gettype($categoryId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($categoryId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $categoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($categoryId, true)), __LINE__);
        }
        if (is_null($categoryId) || (is_array($categoryId) && empty($categoryId))) {
            unset($this->CategoryId);
        } else {
            $this->CategoryId = $categoryId;
        }
        return $this;
    }
    /**
     * Get ClassNodeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClassNodeId()
    {
        return isset($this->ClassNodeId) ? $this->ClassNodeId : null;
    }
    /**
     * Set ClassNodeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $classNodeId
     * @return \patest\StructType\GetAvailableProducts_Request
     */
    public function setClassNodeId($classNodeId = null)
    {
        // validation for constraint: string
        if (!is_null($classNodeId) && !is_string($classNodeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($classNodeId, true), gettype($classNodeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($classNodeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $classNodeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($classNodeId, true)), __LINE__);
        }
        if (is_null($classNodeId) || (is_array($classNodeId) && empty($classNodeId))) {
            unset($this->ClassNodeId);
        } else {
            $this->ClassNodeId = $classNodeId;
        }
        return $this;
    }
    /**
     * Get FreeText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFreeText()
    {
        return isset($this->FreeText) ? $this->FreeText : null;
    }
    /**
     * Set FreeText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $freeText
     * @return \patest\StructType\GetAvailableProducts_Request
     */
    public function setFreeText($freeText = null)
    {
        // validation for constraint: string
        if (!is_null($freeText) && !is_string($freeText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($freeText, true), gettype($freeText)), __LINE__);
        }
        if (is_null($freeText) || (is_array($freeText) && empty($freeText))) {
            unset($this->FreeText);
        } else {
            $this->FreeText = $freeText;
        }
        return $this;
    }
    /**
     * Get IncludeMerchandiseItems value
     * @return bool|null
     */
    public function getIncludeMerchandiseItems()
    {
        return $this->IncludeMerchandiseItems;
    }
    /**
     * Set IncludeMerchandiseItems value
     * @param bool $includeMerchandiseItems
     * @return \patest\StructType\GetAvailableProducts_Request
     */
    public function setIncludeMerchandiseItems($includeMerchandiseItems = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeMerchandiseItems) && !is_bool($includeMerchandiseItems)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeMerchandiseItems, true), gettype($includeMerchandiseItems)), __LINE__);
        }
        $this->IncludeMerchandiseItems = $includeMerchandiseItems;
        return $this;
    }
    /**
     * Get TopRecords value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTopRecords()
    {
        return isset($this->TopRecords) ? $this->TopRecords : null;
    }
    /**
     * Set TopRecords value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $topRecords
     * @return \patest\StructType\GetAvailableProducts_Request
     */
    public function setTopRecords($topRecords = null)
    {
        // validation for constraint: int
        if (!is_null($topRecords) && !(is_int($topRecords) || ctype_digit($topRecords))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($topRecords, true), gettype($topRecords)), __LINE__);
        }
        if (is_null($topRecords) || (is_array($topRecords) && empty($topRecords))) {
            unset($this->TopRecords);
        } else {
            $this->TopRecords = $topRecords;
        }
        return $this;
    }
    /**
     * Get TypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTypeId()
    {
        return isset($this->TypeId) ? $this->TypeId : null;
    }
    /**
     * Set TypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $typeId
     * @return \patest\StructType\GetAvailableProducts_Request
     */
    public function setTypeId($typeId = null)
    {
        // validation for constraint: string
        if (!is_null($typeId) && !is_string($typeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeId, true), gettype($typeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($typeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $typeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($typeId, true)), __LINE__);
        }
        if (is_null($typeId) || (is_array($typeId) && empty($typeId))) {
            unset($this->TypeId);
        } else {
            $this->TypeId = $typeId;
        }
        return $this;
    }
    /**
     * Get IsClassified value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsClassified()
    {
        return isset($this->IsClassified) ? $this->IsClassified : null;
    }
    /**
     * Set IsClassified value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isClassified
     * @return \patest\StructType\GetAvailableProducts_Request
     */
    public function setIsClassified($isClassified = null)
    {
        // validation for constraint: boolean
        if (!is_null($isClassified) && !is_bool($isClassified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isClassified, true), gettype($isClassified)), __LINE__);
        }
        if (is_null($isClassified) || (is_array($isClassified) && empty($isClassified))) {
            unset($this->IsClassified);
        } else {
            $this->IsClassified = $isClassified;
        }
        return $this;
    }
}
