<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAvailablePaymentMethods-Response StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetAvailablePaymentMethods-Response
 * @subpackage Structs
 */
class GetAvailablePaymentMethods_Response extends ExtensibleDataContract
{
    /**
     * The PayMethods
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfPaymentMethodDescription
     */
    public $PayMethods;
    /**
     * The ReimbursementMethods
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfPaymentMethodDescription
     */
    public $ReimbursementMethods;
    /**
     * Constructor method for GetAvailablePaymentMethods-Response
     * @uses GetAvailablePaymentMethods_Response::setPayMethods()
     * @uses GetAvailablePaymentMethods_Response::setReimbursementMethods()
     * @param \patest\ArrayType\ArrayOfPaymentMethodDescription $payMethods
     * @param \patest\ArrayType\ArrayOfPaymentMethodDescription $reimbursementMethods
     */
    public function __construct(\patest\ArrayType\ArrayOfPaymentMethodDescription $payMethods = null, \patest\ArrayType\ArrayOfPaymentMethodDescription $reimbursementMethods = null)
    {
        $this
            ->setPayMethods($payMethods)
            ->setReimbursementMethods($reimbursementMethods);
    }
    /**
     * Get PayMethods value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfPaymentMethodDescription|null
     */
    public function getPayMethods()
    {
        return isset($this->PayMethods) ? $this->PayMethods : null;
    }
    /**
     * Set PayMethods value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfPaymentMethodDescription $payMethods
     * @return \patest\StructType\GetAvailablePaymentMethods_Response
     */
    public function setPayMethods(\patest\ArrayType\ArrayOfPaymentMethodDescription $payMethods = null)
    {
        if (is_null($payMethods) || (is_array($payMethods) && empty($payMethods))) {
            unset($this->PayMethods);
        } else {
            $this->PayMethods = $payMethods;
        }
        return $this;
    }
    /**
     * Get ReimbursementMethods value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfPaymentMethodDescription|null
     */
    public function getReimbursementMethods()
    {
        return isset($this->ReimbursementMethods) ? $this->ReimbursementMethods : null;
    }
    /**
     * Set ReimbursementMethods value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfPaymentMethodDescription $reimbursementMethods
     * @return \patest\StructType\GetAvailablePaymentMethods_Response
     */
    public function setReimbursementMethods(\patest\ArrayType\ArrayOfPaymentMethodDescription $reimbursementMethods = null)
    {
        if (is_null($reimbursementMethods) || (is_array($reimbursementMethods) && empty($reimbursementMethods))) {
            unset($this->ReimbursementMethods);
        } else {
            $this->ReimbursementMethods = $reimbursementMethods;
        }
        return $this;
    }
}
