<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAvailableDepositsRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetAvailableDepositsRequest
 * @subpackage Structs
 */
class GetAvailableDepositsRequest extends AbstractStructBase
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The DoNotIncludeRelatedClients
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $DoNotIncludeRelatedClients;
    /**
     * The PaymentMethodId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentMethodId;
    /**
     * The CurrentTransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CurrentTransactionGuid;
    /**
     * Constructor method for GetAvailableDepositsRequest
     * @uses GetAvailableDepositsRequest::setClientId()
     * @uses GetAvailableDepositsRequest::setDoNotIncludeRelatedClients()
     * @uses GetAvailableDepositsRequest::setPaymentMethodId()
     * @uses GetAvailableDepositsRequest::setCurrentTransactionGuid()
     * @param string $clientId
     * @param bool $doNotIncludeRelatedClients
     * @param string $paymentMethodId
     * @param string $currentTransactionGuid
     */
    public function __construct($clientId = null, $doNotIncludeRelatedClients = null, $paymentMethodId = null, $currentTransactionGuid = null)
    {
        $this
            ->setClientId($clientId)
            ->setDoNotIncludeRelatedClients($doNotIncludeRelatedClients)
            ->setPaymentMethodId($paymentMethodId)
            ->setCurrentTransactionGuid($currentTransactionGuid);
    }
    /**
     * Get ClientId value
     * @return string|null
     */
    public function getClientId()
    {
        return $this->ClientId;
    }
    /**
     * Set ClientId value
     * @param string $clientId
     * @return \patest\StructType\GetAvailableDepositsRequest
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        $this->ClientId = $clientId;
        return $this;
    }
    /**
     * Get DoNotIncludeRelatedClients value
     * @return bool|null
     */
    public function getDoNotIncludeRelatedClients()
    {
        return $this->DoNotIncludeRelatedClients;
    }
    /**
     * Set DoNotIncludeRelatedClients value
     * @param bool $doNotIncludeRelatedClients
     * @return \patest\StructType\GetAvailableDepositsRequest
     */
    public function setDoNotIncludeRelatedClients($doNotIncludeRelatedClients = null)
    {
        // validation for constraint: boolean
        if (!is_null($doNotIncludeRelatedClients) && !is_bool($doNotIncludeRelatedClients)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($doNotIncludeRelatedClients, true), gettype($doNotIncludeRelatedClients)), __LINE__);
        }
        $this->DoNotIncludeRelatedClients = $doNotIncludeRelatedClients;
        return $this;
    }
    /**
     * Get PaymentMethodId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodId()
    {
        return isset($this->PaymentMethodId) ? $this->PaymentMethodId : null;
    }
    /**
     * Set PaymentMethodId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethodId
     * @return \patest\StructType\GetAvailableDepositsRequest
     */
    public function setPaymentMethodId($paymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodId) && !is_string($paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodId, true), gettype($paymentMethodId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentMethodId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentMethodId, true)), __LINE__);
        }
        if (is_null($paymentMethodId) || (is_array($paymentMethodId) && empty($paymentMethodId))) {
            unset($this->PaymentMethodId);
        } else {
            $this->PaymentMethodId = $paymentMethodId;
        }
        return $this;
    }
    /**
     * Get CurrentTransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrentTransactionGuid()
    {
        return isset($this->CurrentTransactionGuid) ? $this->CurrentTransactionGuid : null;
    }
    /**
     * Set CurrentTransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currentTransactionGuid
     * @return \patest\StructType\GetAvailableDepositsRequest
     */
    public function setCurrentTransactionGuid($currentTransactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($currentTransactionGuid) && !is_string($currentTransactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currentTransactionGuid, true), gettype($currentTransactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($currentTransactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $currentTransactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($currentTransactionGuid, true)), __LINE__);
        }
        if (is_null($currentTransactionGuid) || (is_array($currentTransactionGuid) && empty($currentTransactionGuid))) {
            unset($this->CurrentTransactionGuid);
        } else {
            $this->CurrentTransactionGuid = $currentTransactionGuid;
        }
        return $this;
    }
}
