<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAvailableDataResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetAvailableDataResponse
 * @subpackage Structs
 */
class GetAvailableDataResponse extends AbstractStructBase
{
    /**
     * The Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\DataBatch
     */
    public $Data;
    /**
     * The IsThereMoreData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsThereMoreData;
    /**
     * The TransmissionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransmissionId;
    /**
     * Constructor method for GetAvailableDataResponse
     * @uses GetAvailableDataResponse::setData()
     * @uses GetAvailableDataResponse::setIsThereMoreData()
     * @uses GetAvailableDataResponse::setTransmissionId()
     * @param \patest\StructType\DataBatch $data
     * @param bool $isThereMoreData
     * @param string $transmissionId
     */
    public function __construct(\patest\StructType\DataBatch $data = null, $isThereMoreData = null, $transmissionId = null)
    {
        $this
            ->setData($data)
            ->setIsThereMoreData($isThereMoreData)
            ->setTransmissionId($transmissionId);
    }
    /**
     * Get Data value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\DataBatch|null
     */
    public function getData()
    {
        return isset($this->Data) ? $this->Data : null;
    }
    /**
     * Set Data value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\DataBatch $data
     * @return \patest\StructType\GetAvailableDataResponse
     */
    public function setData(\patest\StructType\DataBatch $data = null)
    {
        if (is_null($data) || (is_array($data) && empty($data))) {
            unset($this->Data);
        } else {
            $this->Data = $data;
        }
        return $this;
    }
    /**
     * Get IsThereMoreData value
     * @return bool|null
     */
    public function getIsThereMoreData()
    {
        return $this->IsThereMoreData;
    }
    /**
     * Set IsThereMoreData value
     * @param bool $isThereMoreData
     * @return \patest\StructType\GetAvailableDataResponse
     */
    public function setIsThereMoreData($isThereMoreData = null)
    {
        // validation for constraint: boolean
        if (!is_null($isThereMoreData) && !is_bool($isThereMoreData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isThereMoreData, true), gettype($isThereMoreData)), __LINE__);
        }
        $this->IsThereMoreData = $isThereMoreData;
        return $this;
    }
    /**
     * Get TransmissionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransmissionId()
    {
        return isset($this->TransmissionId) ? $this->TransmissionId : null;
    }
    /**
     * Set TransmissionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transmissionId
     * @return \patest\StructType\GetAvailableDataResponse
     */
    public function setTransmissionId($transmissionId = null)
    {
        // validation for constraint: string
        if (!is_null($transmissionId) && !is_string($transmissionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transmissionId, true), gettype($transmissionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transmissionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transmissionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transmissionId, true)), __LINE__);
        }
        if (is_null($transmissionId) || (is_array($transmissionId) && empty($transmissionId))) {
            unset($this->TransmissionId);
        } else {
            $this->TransmissionId = $transmissionId;
        }
        return $this;
    }
}
