<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GenerateOTP-Response StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GenerateOTP-Response
 * @subpackage Structs
 */
class GenerateOTP_Response extends ExtensibleDataContract
{
    /**
     * The RecipientUserId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RecipientUserId;
    /**
     * Constructor method for GenerateOTP-Response
     * @uses GenerateOTP_Response::setRecipientUserId()
     * @param string $recipientUserId
     */
    public function __construct($recipientUserId = null)
    {
        $this
            ->setRecipientUserId($recipientUserId);
    }
    /**
     * Get RecipientUserId value
     * @return string|null
     */
    public function getRecipientUserId()
    {
        return $this->RecipientUserId;
    }
    /**
     * Set RecipientUserId value
     * @param string $recipientUserId
     * @return \patest\StructType\GenerateOTP_Response
     */
    public function setRecipientUserId($recipientUserId = null)
    {
        // validation for constraint: string
        if (!is_null($recipientUserId) && !is_string($recipientUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recipientUserId, true), gettype($recipientUserId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($recipientUserId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $recipientUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($recipientUserId, true)), __LINE__);
        }
        $this->RecipientUserId = $recipientUserId;
        return $this;
    }
}
