<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GeneralAdmissionSettings StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GeneralAdmissionSettings
 * @subpackage Structs
 */
class GeneralAdmissionSettings extends AbstractStructBase
{
    /**
     * The Capacity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Capacity;
    /**
     * The MaxCapacity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxCapacity;
    /**
     * The PriceLevelGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceLevelGuid;
    /**
     * The Priority
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Priority;
    /**
     * The Restrictions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfGeneralAdmissionRestrictionSettings
     */
    public $Restrictions;
    /**
     * Constructor method for GeneralAdmissionSettings
     * @uses GeneralAdmissionSettings::setCapacity()
     * @uses GeneralAdmissionSettings::setMaxCapacity()
     * @uses GeneralAdmissionSettings::setPriceLevelGuid()
     * @uses GeneralAdmissionSettings::setPriority()
     * @uses GeneralAdmissionSettings::setRestrictions()
     * @param int $capacity
     * @param int $maxCapacity
     * @param string $priceLevelGuid
     * @param int $priority
     * @param \patest\ArrayType\ArrayOfGeneralAdmissionRestrictionSettings $restrictions
     */
    public function __construct($capacity = null, $maxCapacity = null, $priceLevelGuid = null, $priority = null, \patest\ArrayType\ArrayOfGeneralAdmissionRestrictionSettings $restrictions = null)
    {
        $this
            ->setCapacity($capacity)
            ->setMaxCapacity($maxCapacity)
            ->setPriceLevelGuid($priceLevelGuid)
            ->setPriority($priority)
            ->setRestrictions($restrictions);
    }
    /**
     * Get Capacity value
     * @return int|null
     */
    public function getCapacity()
    {
        return $this->Capacity;
    }
    /**
     * Set Capacity value
     * @param int $capacity
     * @return \patest\StructType\GeneralAdmissionSettings
     */
    public function setCapacity($capacity = null)
    {
        // validation for constraint: int
        if (!is_null($capacity) && !(is_int($capacity) || ctype_digit($capacity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($capacity, true), gettype($capacity)), __LINE__);
        }
        $this->Capacity = $capacity;
        return $this;
    }
    /**
     * Get MaxCapacity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxCapacity()
    {
        return isset($this->MaxCapacity) ? $this->MaxCapacity : null;
    }
    /**
     * Set MaxCapacity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxCapacity
     * @return \patest\StructType\GeneralAdmissionSettings
     */
    public function setMaxCapacity($maxCapacity = null)
    {
        // validation for constraint: int
        if (!is_null($maxCapacity) && !(is_int($maxCapacity) || ctype_digit($maxCapacity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxCapacity, true), gettype($maxCapacity)), __LINE__);
        }
        if (is_null($maxCapacity) || (is_array($maxCapacity) && empty($maxCapacity))) {
            unset($this->MaxCapacity);
        } else {
            $this->MaxCapacity = $maxCapacity;
        }
        return $this;
    }
    /**
     * Get PriceLevelGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceLevelGuid()
    {
        return isset($this->PriceLevelGuid) ? $this->PriceLevelGuid : null;
    }
    /**
     * Set PriceLevelGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceLevelGuid
     * @return \patest\StructType\GeneralAdmissionSettings
     */
    public function setPriceLevelGuid($priceLevelGuid = null)
    {
        // validation for constraint: string
        if (!is_null($priceLevelGuid) && !is_string($priceLevelGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceLevelGuid, true), gettype($priceLevelGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceLevelGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceLevelGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceLevelGuid, true)), __LINE__);
        }
        if (is_null($priceLevelGuid) || (is_array($priceLevelGuid) && empty($priceLevelGuid))) {
            unset($this->PriceLevelGuid);
        } else {
            $this->PriceLevelGuid = $priceLevelGuid;
        }
        return $this;
    }
    /**
     * Get Priority value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPriority()
    {
        return isset($this->Priority) ? $this->Priority : null;
    }
    /**
     * Set Priority value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $priority
     * @return \patest\StructType\GeneralAdmissionSettings
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: int
        if (!is_null($priority) && !(is_int($priority) || ctype_digit($priority))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($priority, true), gettype($priority)), __LINE__);
        }
        if (is_null($priority) || (is_array($priority) && empty($priority))) {
            unset($this->Priority);
        } else {
            $this->Priority = $priority;
        }
        return $this;
    }
    /**
     * Get Restrictions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfGeneralAdmissionRestrictionSettings|null
     */
    public function getRestrictions()
    {
        return isset($this->Restrictions) ? $this->Restrictions : null;
    }
    /**
     * Set Restrictions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfGeneralAdmissionRestrictionSettings $restrictions
     * @return \patest\StructType\GeneralAdmissionSettings
     */
    public function setRestrictions(\patest\ArrayType\ArrayOfGeneralAdmissionRestrictionSettings $restrictions = null)
    {
        if (is_null($restrictions) || (is_array($restrictions) && empty($restrictions))) {
            unset($this->Restrictions);
        } else {
            $this->Restrictions = $restrictions;
        }
        return $this;
    }
}
